<?php
 namespace MailPoetVendor\Doctrine\DBAL; if (!defined('ABSPATH')) exit; use MailPoetVendor\Doctrine\DBAL\Driver\ServerInfoAwareConnection; use MailPoetVendor\Doctrine\DBAL\Exception\InvalidArgumentException; use PDO; use Closure; use Exception; use MailPoetVendor\Doctrine\DBAL\Types\Type; use MailPoetVendor\Doctrine\DBAL\Driver\Connection as DriverConnection; use MailPoetVendor\Doctrine\Common\EventManager; use MailPoetVendor\Doctrine\DBAL\Cache\ResultCacheStatement; use MailPoetVendor\Doctrine\DBAL\Cache\QueryCacheProfile; use MailPoetVendor\Doctrine\DBAL\Cache\ArrayStatement; use MailPoetVendor\Doctrine\DBAL\Cache\CacheException; use MailPoetVendor\Doctrine\DBAL\Driver\PingableConnection; class Connection implements \MailPoetVendor\Doctrine\DBAL\Driver\Connection { const TRANSACTION_READ_UNCOMMITTED = 1; const TRANSACTION_READ_COMMITTED = 2; const TRANSACTION_REPEATABLE_READ = 3; const TRANSACTION_SERIALIZABLE = 4; const PARAM_INT_ARRAY = 101; const PARAM_STR_ARRAY = 102; const ARRAY_PARAM_OFFSET = 100; protected $_conn; protected $_config; protected $_eventManager; protected $_expr; private $_isConnected = \false; private $autoCommit = \true; private $_transactionNestingLevel = 0; private $_transactionIsolationLevel; private $_nestTransactionsWithSavepoints = \false; private $_params = array(); private $platform; protected $_schemaManager; protected $_driver; private $_isRollbackOnly = \false; protected $defaultFetchMode = \PDO::FETCH_ASSOC; public function __construct(array $params, \MailPoetVendor\Doctrine\DBAL\Driver $driver, \MailPoetVendor\Doctrine\DBAL\Configuration $config = null, \MailPoetVendor\Doctrine\Common\EventManager $eventManager = null) { $this->_driver = $driver; $this->_params = $params; if (isset($params['pdo'])) { $this->_conn = $params['pdo']; $this->_isConnected = \true; unset($this->_params['pdo']); } if (!$config) { $config = new \MailPoetVendor\Doctrine\DBAL\Configuration(); } if (!$eventManager) { $eventManager = new \MailPoetVendor\Doctrine\Common\EventManager(); } $this->_config = $config; $this->_eventManager = $eventManager; $this->_expr = new \MailPoetVendor\Doctrine\DBAL\Query\Expression\ExpressionBuilder($this); $this->autoCommit = $config->getAutoCommit(); } public function getParams() { return $this->_params; } public function getDatabase() { return $this->_driver->getDatabase($this); } public function getHost() { return isset($this->_params['host']) ? $this->_params['host'] : null; } public function getPort() { return isset($this->_params['port']) ? $this->_params['port'] : null; } public function getUsername() { return isset($this->_params['user']) ? $this->_params['user'] : null; } public function getPassword() { return isset($this->_params['password']) ? $this->_params['password'] : null; } public function getDriver() { return $this->_driver; } public function getConfiguration() { return $this->_config; } public function getEventManager() { return $this->_eventManager; } public function getDatabasePlatform() { if (null == $this->platform) { $this->detectDatabasePlatform(); } return $this->platform; } public function getExpressionBuilder() { return $this->_expr; } public function connect() { if ($this->_isConnected) { return \false; } $driverOptions = isset($this->_params['driverOptions']) ? $this->_params['driverOptions'] : array(); $user = isset($this->_params['user']) ? $this->_params['user'] : null; $password = isset($this->_params['password']) ? $this->_params['password'] : null; $this->_conn = $this->_driver->connect($this->_params, $user, $password, $driverOptions); $this->_isConnected = \true; if (null === $this->platform) { $this->detectDatabasePlatform(); } if (\false === $this->autoCommit) { $this->beginTransaction(); } if ($this->_eventManager->hasListeners(\MailPoetVendor\Doctrine\DBAL\Events::postConnect)) { $eventArgs = new \MailPoetVendor\Doctrine\DBAL\Event\ConnectionEventArgs($this); $this->_eventManager->dispatchEvent(\MailPoetVendor\Doctrine\DBAL\Events::postConnect, $eventArgs); } return \true; } private function detectDatabasePlatform() { if (!isset($this->_params['platform'])) { $version = $this->getDatabasePlatformVersion(); if (null !== $version) { $this->platform = $this->_driver->createDatabasePlatformForVersion($version); } else { $this->platform = $this->_driver->getDatabasePlatform(); } } elseif ($this->_params['platform'] instanceof \MailPoetVendor\Doctrine\DBAL\Platforms\AbstractPlatform) { $this->platform = $this->_params['platform']; } else { throw \MailPoetVendor\Doctrine\DBAL\DBALException::invalidPlatformSpecified(); } $this->platform->setEventManager($this->_eventManager); } private function getDatabasePlatformVersion() { if (!$this->_driver instanceof \MailPoetVendor\Doctrine\DBAL\VersionAwarePlatformDriver) { return null; } if (isset($this->_params['serverVersion'])) { return $this->_params['serverVersion']; } if (null === $this->_conn) { $this->connect(); } if ($this->_conn instanceof \MailPoetVendor\Doctrine\DBAL\Driver\ServerInfoAwareConnection && !$this->_conn->requiresQueryForServerVersion()) { return $this->_conn->getServerVersion(); } return null; } public function isAutoCommit() { return \true === $this->autoCommit; } public function setAutoCommit($autoCommit) { $autoCommit = (bool) $autoCommit; if ($autoCommit === $this->autoCommit) { return; } $this->autoCommit = $autoCommit; if (\true === $this->_isConnected && 0 !== $this->_transactionNestingLevel) { $this->commitAll(); } } public function setFetchMode($fetchMode) { $this->defaultFetchMode = $fetchMode; } public function fetchAssoc($statement, array $params = array(), array $types = array()) { return $this->executeQuery($statement, $params, $types)->fetch(\PDO::FETCH_ASSOC); } public function fetchArray($statement, array $params = array(), array $types = array()) { return $this->executeQuery($statement, $params, $types)->fetch(\PDO::FETCH_NUM); } public function fetchColumn($statement, array $params = array(), $column = 0, array $types = array()) { return $this->executeQuery($statement, $params, $types)->fetchColumn($column); } public function isConnected() { return $this->_isConnected; } public function isTransactionActive() { return $this->_transactionNestingLevel > 0; } public function delete($tableExpression, array $identifier, array $types = array()) { if (empty($identifier)) { throw \MailPoetVendor\Doctrine\DBAL\Exception\InvalidArgumentException::fromEmptyCriteria(); } $columnList = array(); $criteria = array(); $paramValues = array(); foreach ($identifier as $columnName => $value) { $columnList[] = $columnName; $criteria[] = $columnName . ' = ?'; $paramValues[] = $value; } return $this->executeUpdate('DELETE FROM ' . $tableExpression . ' WHERE ' . \implode(' AND ', $criteria), $paramValues, \is_string(\key($types)) ? $this->extractTypeValues($columnList, $types) : $types); } public function close() { $this->_conn = null; $this->_isConnected = \false; } public function setTransactionIsolation($level) { $this->_transactionIsolationLevel = $level; return $this->executeUpdate($this->getDatabasePlatform()->getSetTransactionIsolationSQL($level)); } public function getTransactionIsolation() { if (null === $this->_transactionIsolationLevel) { $this->_transactionIsolationLevel = $this->getDatabasePlatform()->getDefaultTransactionIsolationLevel(); } return $this->_transactionIsolationLevel; } public function update($tableExpression, array $data, array $identifier, array $types = array()) { $columnList = array(); $set = array(); $criteria = array(); $paramValues = array(); foreach ($data as $columnName => $value) { $columnList[] = $columnName; $set[] = $columnName . ' = ?'; $paramValues[] = $value; } foreach ($identifier as $columnName => $value) { $columnList[] = $columnName; $criteria[] = $columnName . ' = ?'; $paramValues[] = $value; } if (\is_string(\key($types))) { $types = $this->extractTypeValues($columnList, $types); } $sql = 'UPDATE ' . $tableExpression . ' SET ' . \implode(', ', $set) . ' WHERE ' . \implode(' AND ', $criteria); return $this->executeUpdate($sql, $paramValues, $types); } public function insert($tableExpression, array $data, array $types = array()) { $this->connect(); if (empty($data)) { return $this->executeUpdate('INSERT INTO ' . $tableExpression . ' ()' . ' VALUES ()'); } $columnList = array(); $paramPlaceholders = array(); $paramValues = array(); foreach ($data as $columnName => $value) { $columnList[] = $columnName; $paramPlaceholders[] = '?'; $paramValues[] = $value; } return $this->executeUpdate('INSERT INTO ' . $tableExpression . ' (' . \implode(', ', $columnList) . ')' . ' VALUES (' . \implode(', ', $paramPlaceholders) . ')', $paramValues, \is_string(\key($types)) ? $this->extractTypeValues($columnList, $types) : $types); } private function extractTypeValues(array $columnList, array $types) { $typeValues = array(); foreach ($columnList as $columnIndex => $columnName) { $typeValues[] = isset($types[$columnName]) ? $types[$columnName] : \PDO::PARAM_STR; } return $typeValues; } public function quoteIdentifier($str) { return $this->getDatabasePlatform()->quoteIdentifier($str); } public function quote($input, $type = null) { $this->connect(); list($value, $bindingType) = $this->getBindingInfo($input, $type); return $this->_conn->quote($value, $bindingType); } public function fetchAll($sql, array $params = array(), $types = array()) { return $this->executeQuery($sql, $params, $types)->fetchAll(); } public function prepare($statement) { $this->connect(); try { $stmt = new \MailPoetVendor\Doctrine\DBAL\Statement($statement, $this); } catch (\Exception $ex) { throw \MailPoetVendor\Doctrine\DBAL\DBALException::driverExceptionDuringQuery($this->_driver, $ex, $statement); } $stmt->setFetchMode($this->defaultFetchMode); return $stmt; } public function executeQuery($query, array $params = array(), $types = array(), \MailPoetVendor\Doctrine\DBAL\Cache\QueryCacheProfile $qcp = null) { if ($qcp !== null) { return $this->executeCacheQuery($query, $params, $types, $qcp); } $this->connect(); $logger = $this->_config->getSQLLogger(); if ($logger) { $logger->startQuery($query, $params, $types); } try { if ($params) { list($query, $params, $types) = \MailPoetVendor\Doctrine\DBAL\SQLParserUtils::expandListParameters($query, $params, $types); $stmt = $this->_conn->prepare($query); if ($types) { $this->_bindTypedValues($stmt, $params, $types); $stmt->execute(); } else { $stmt->execute($params); } } else { $stmt = $this->_conn->query($query); } } catch (\Exception $ex) { throw \MailPoetVendor\Doctrine\DBAL\DBALException::driverExceptionDuringQuery($this->_driver, $ex, $query, $this->resolveParams($params, $types)); } $stmt->setFetchMode($this->defaultFetchMode); if ($logger) { $logger->stopQuery(); } return $stmt; } public function executeCacheQuery($query, $params, $types, \MailPoetVendor\Doctrine\DBAL\Cache\QueryCacheProfile $qcp) { $resultCache = $qcp->getResultCacheDriver() ?: $this->_config->getResultCacheImpl(); if (!$resultCache) { throw \MailPoetVendor\Doctrine\DBAL\Cache\CacheException::noResultDriverConfigured(); } list($cacheKey, $realKey) = $qcp->generateCacheKeys($query, $params, $types); if ($data = $resultCache->fetch($cacheKey)) { if (isset($data[$realKey])) { $stmt = new \MailPoetVendor\Doctrine\DBAL\Cache\ArrayStatement($data[$realKey]); } elseif (\array_key_exists($realKey, $data)) { $stmt = new \MailPoetVendor\Doctrine\DBAL\Cache\ArrayStatement(array()); } } if (!isset($stmt)) { $stmt = new \MailPoetVendor\Doctrine\DBAL\Cache\ResultCacheStatement($this->executeQuery($query, $params, $types), $resultCache, $cacheKey, $realKey, $qcp->getLifetime()); } $stmt->setFetchMode($this->defaultFetchMode); return $stmt; } public function project($query, array $params, \Closure $function) { $result = array(); $stmt = $this->executeQuery($query, $params); while ($row = $stmt->fetch()) { $result[] = $function($row); } $stmt->closeCursor(); return $result; } public function query() { $this->connect(); $args = \func_get_args(); $logger = $this->_config->getSQLLogger(); if ($logger) { $logger->startQuery($args[0]); } try { switch (\func_num_args()) { case 1: $statement = $this->_conn->query($args[0]); break; case 2: $statement = $this->_conn->query($args[0], $args[1]); break; default: $statement = \call_user_func_array(array($this->_conn, 'query'), $args); break; } } catch (\Exception $ex) { throw \MailPoetVendor\Doctrine\DBAL\DBALException::driverExceptionDuringQuery($this->_driver, $ex, $args[0]); } $statement->setFetchMode($this->defaultFetchMode); if ($logger) { $logger->stopQuery(); } return $statement; } public function executeUpdate($query, array $params = array(), array $types = array()) { $this->connect(); $logger = $this->_config->getSQLLogger(); if ($logger) { $logger->startQuery($query, $params, $types); } try { if ($params) { list($query, $params, $types) = \MailPoetVendor\Doctrine\DBAL\SQLParserUtils::expandListParameters($query, $params, $types); $stmt = $this->_conn->prepare($query); if ($types) { $this->_bindTypedValues($stmt, $params, $types); $stmt->execute(); } else { $stmt->execute($params); } $result = $stmt->rowCount(); } else { $result = $this->_conn->exec($query); } } catch (\Exception $ex) { throw \MailPoetVendor\Doctrine\DBAL\DBALException::driverExceptionDuringQuery($this->_driver, $ex, $query, $this->resolveParams($params, $types)); } if ($logger) { $logger->stopQuery(); } return $result; } public function exec($statement) { $this->connect(); $logger = $this->_config->getSQLLogger(); if ($logger) { $logger->startQuery($statement); } try { $result = $this->_conn->exec($statement); } catch (\Exception $ex) { throw \MailPoetVendor\Doctrine\DBAL\DBALException::driverExceptionDuringQuery($this->_driver, $ex, $statement); } if ($logger) { $logger->stopQuery(); } return $result; } public function getTransactionNestingLevel() { return $this->_transactionNestingLevel; } public function errorCode() { $this->connect(); return $this->_conn->errorCode(); } public function errorInfo() { $this->connect(); return $this->_conn->errorInfo(); } public function lastInsertId($seqName = null) { $this->connect(); return $this->_conn->lastInsertId($seqName); } public function transactional(\Closure $func) { $this->beginTransaction(); try { $func($this); $this->commit(); } catch (\Exception $e) { $this->rollback(); throw $e; } } public function setNestTransactionsWithSavepoints($nestTransactionsWithSavepoints) { if ($this->_transactionNestingLevel > 0) { throw \MailPoetVendor\Doctrine\DBAL\ConnectionException::mayNotAlterNestedTransactionWithSavepointsInTransaction(); } if (!$this->getDatabasePlatform()->supportsSavepoints()) { throw \MailPoetVendor\Doctrine\DBAL\ConnectionException::savepointsNotSupported(); } $this->_nestTransactionsWithSavepoints = (bool) $nestTransactionsWithSavepoints; } public function getNestTransactionsWithSavepoints() { return $this->_nestTransactionsWithSavepoints; } protected function _getNestedTransactionSavePointName() { return 'DOCTRINE2_SAVEPOINT_' . $this->_transactionNestingLevel; } public function beginTransaction() { $this->connect(); ++$this->_transactionNestingLevel; $logger = $this->_config->getSQLLogger(); if ($this->_transactionNestingLevel == 1) { if ($logger) { $logger->startQuery('"START TRANSACTION"'); } $this->_conn->beginTransaction(); if ($logger) { $logger->stopQuery(); } } elseif ($this->_nestTransactionsWithSavepoints) { if ($logger) { $logger->startQuery('"SAVEPOINT"'); } $this->createSavepoint($this->_getNestedTransactionSavePointName()); if ($logger) { $logger->stopQuery(); } } } public function commit() { if ($this->_transactionNestingLevel == 0) { throw \MailPoetVendor\Doctrine\DBAL\ConnectionException::noActiveTransaction(); } if ($this->_isRollbackOnly) { throw \MailPoetVendor\Doctrine\DBAL\ConnectionException::commitFailedRollbackOnly(); } $this->connect(); $logger = $this->_config->getSQLLogger(); if ($this->_transactionNestingLevel == 1) { if ($logger) { $logger->startQuery('"COMMIT"'); } $this->_conn->commit(); if ($logger) { $logger->stopQuery(); } } elseif ($this->_nestTransactionsWithSavepoints) { if ($logger) { $logger->startQuery('"RELEASE SAVEPOINT"'); } $this->releaseSavepoint($this->_getNestedTransactionSavePointName()); if ($logger) { $logger->stopQuery(); } } --$this->_transactionNestingLevel; if (\false === $this->autoCommit && 0 === $this->_transactionNestingLevel) { $this->beginTransaction(); } } private function commitAll() { while (0 !== $this->_transactionNestingLevel) { if (\false === $this->autoCommit && 1 === $this->_transactionNestingLevel) { $this->commit(); return; } $this->commit(); } } public function rollBack() { if ($this->_transactionNestingLevel == 0) { throw \MailPoetVendor\Doctrine\DBAL\ConnectionException::noActiveTransaction(); } $this->connect(); $logger = $this->_config->getSQLLogger(); if ($this->_transactionNestingLevel == 1) { if ($logger) { $logger->startQuery('"ROLLBACK"'); } $this->_transactionNestingLevel = 0; $this->_conn->rollback(); $this->_isRollbackOnly = \false; if ($logger) { $logger->stopQuery(); } if (\false === $this->autoCommit) { $this->beginTransaction(); } } elseif ($this->_nestTransactionsWithSavepoints) { if ($logger) { $logger->startQuery('"ROLLBACK TO SAVEPOINT"'); } $this->rollbackSavepoint($this->_getNestedTransactionSavePointName()); --$this->_transactionNestingLevel; if ($logger) { $logger->stopQuery(); } } else { $this->_isRollbackOnly = \true; --$this->_transactionNestingLevel; } } public function createSavepoint($savepoint) { if (!$this->getDatabasePlatform()->supportsSavepoints()) { throw \MailPoetVendor\Doctrine\DBAL\ConnectionException::savepointsNotSupported(); } $this->_conn->exec($this->platform->createSavePoint($savepoint)); } public function releaseSavepoint($savepoint) { if (!$this->getDatabasePlatform()->supportsSavepoints()) { throw \MailPoetVendor\Doctrine\DBAL\ConnectionException::savepointsNotSupported(); } if ($this->platform->supportsReleaseSavepoints()) { $this->_conn->exec($this->platform->releaseSavePoint($savepoint)); } } public function rollbackSavepoint($savepoint) { if (!$this->getDatabasePlatform()->supportsSavepoints()) { throw \MailPoetVendor\Doctrine\DBAL\ConnectionException::savepointsNotSupported(); } $this->_conn->exec($this->platform->rollbackSavePoint($savepoint)); } public function getWrappedConnection() { $this->connect(); return $this->_conn; } public function getSchemaManager() { if (!$this->_schemaManager) { $this->_schemaManager = $this->_driver->getSchemaManager($this); } return $this->_schemaManager; } public function setRollbackOnly() { if ($this->_transactionNestingLevel == 0) { throw \MailPoetVendor\Doctrine\DBAL\ConnectionException::noActiveTransaction(); } $this->_isRollbackOnly = \true; } public function isRollbackOnly() { if ($this->_transactionNestingLevel == 0) { throw \MailPoetVendor\Doctrine\DBAL\ConnectionException::noActiveTransaction(); } return $this->_isRollbackOnly; } public function convertToDatabaseValue($value, $type) { return \MailPoetVendor\Doctrine\DBAL\Types\Type::getType($type)->convertToDatabaseValue($value, $this->getDatabasePlatform()); } public function convertToPHPValue($value, $type) { return \MailPoetVendor\Doctrine\DBAL\Types\Type::getType($type)->convertToPHPValue($value, $this->getDatabasePlatform()); } private function _bindTypedValues($stmt, array $params, array $types) { if (\is_int(\key($params))) { $typeOffset = \array_key_exists(0, $types) ? -1 : 0; $bindIndex = 1; foreach ($params as $value) { $typeIndex = $bindIndex + $typeOffset; if (isset($types[$typeIndex])) { $type = $types[$typeIndex]; list($value, $bindingType) = $this->getBindingInfo($value, $type); $stmt->bindValue($bindIndex, $value, $bindingType); } else { $stmt->bindValue($bindIndex, $value); } ++$bindIndex; } } else { foreach ($params as $name => $value) { if (isset($types[$name])) { $type = $types[$name]; list($value, $bindingType) = $this->getBindingInfo($value, $type); $stmt->bindValue($name, $value, $bindingType); } else { $stmt->bindValue($name, $value); } } } } private function getBindingInfo($value, $type) { if (\is_string($type)) { $type = \MailPoetVendor\Doctrine\DBAL\Types\Type::getType($type); } if ($type instanceof \MailPoetVendor\Doctrine\DBAL\Types\Type) { $value = $type->convertToDatabaseValue($value, $this->getDatabasePlatform()); $bindingType = $type->getBindingType(); } else { $bindingType = $type; } return array($value, $bindingType); } public function resolveParams(array $params, array $types) { $resolvedParams = array(); if (\is_int(\key($params))) { $typeOffset = \array_key_exists(0, $types) ? -1 : 0; $bindIndex = 1; foreach ($params as $value) { $typeIndex = $bindIndex + $typeOffset; if (isset($types[$typeIndex])) { $type = $types[$typeIndex]; list($value, ) = $this->getBindingInfo($value, $type); $resolvedParams[$bindIndex] = $value; } else { $resolvedParams[$bindIndex] = $value; } ++$bindIndex; } } else { foreach ($params as $name => $value) { if (isset($types[$name])) { $type = $types[$name]; list($value, ) = $this->getBindingInfo($value, $type); $resolvedParams[$name] = $value; } else { $resolvedParams[$name] = $value; } } } return $resolvedParams; } public function createQueryBuilder() { return new \MailPoetVendor\Doctrine\DBAL\Query\QueryBuilder($this); } public function ping() { $this->connect(); if ($this->_conn instanceof \MailPoetVendor\Doctrine\DBAL\Driver\PingableConnection) { return $this->_conn->ping(); } try { $this->query($this->getDatabasePlatform()->getDummySelectSQL()); return \true; } catch (\MailPoetVendor\Doctrine\DBAL\DBALException $e) { return \false; } } } 