<?php
 namespace MailPoetVendor\Doctrine\DBAL; if (!defined('ABSPATH')) exit; use MailPoetVendor\Doctrine\Common\EventManager; final class DriverManager { private static $_driverMap = array('pdo_mysql' => 'MailPoetVendor\\Doctrine\\DBAL\\Driver\\PDOMySql\\Driver', 'pdo_sqlite' => 'MailPoetVendor\\Doctrine\\DBAL\\Driver\\PDOSqlite\\Driver', 'pdo_pgsql' => 'MailPoetVendor\\Doctrine\\DBAL\\Driver\\PDOPgSql\\Driver', 'pdo_oci' => 'MailPoetVendor\\Doctrine\\DBAL\\Driver\\PDOOracle\\Driver', 'oci8' => 'MailPoetVendor\\Doctrine\\DBAL\\Driver\\OCI8\\Driver', 'ibm_db2' => 'MailPoetVendor\\Doctrine\\DBAL\\Driver\\IBMDB2\\DB2Driver', 'pdo_sqlsrv' => 'MailPoetVendor\\Doctrine\\DBAL\\Driver\\PDOSqlsrv\\Driver', 'mysqli' => 'MailPoetVendor\\Doctrine\\DBAL\\Driver\\Mysqli\\Driver', 'drizzle_pdo_mysql' => 'MailPoetVendor\\Doctrine\\DBAL\\Driver\\DrizzlePDOMySql\\Driver', 'sqlanywhere' => 'MailPoetVendor\\Doctrine\\DBAL\\Driver\\SQLAnywhere\\Driver', 'sqlsrv' => 'MailPoetVendor\\Doctrine\\DBAL\\Driver\\SQLSrv\\Driver'); private static $driverSchemeAliases = array( 'db2' => 'ibm_db2', 'mssql' => 'pdo_sqlsrv', 'mysql' => 'pdo_mysql', 'mysql2' => 'pdo_mysql', 'postgres' => 'pdo_pgsql', 'postgresql' => 'pdo_pgsql', 'pgsql' => 'pdo_pgsql', 'sqlite' => 'pdo_sqlite', 'sqlite3' => 'pdo_sqlite', ); private function __construct() { } public static function getConnection(array $params, \MailPoetVendor\Doctrine\DBAL\Configuration $config = null, \MailPoetVendor\Doctrine\Common\EventManager $eventManager = null) { if (!$config) { $config = new \MailPoetVendor\Doctrine\DBAL\Configuration(); } if (!$eventManager) { $eventManager = new \MailPoetVendor\Doctrine\Common\EventManager(); } $params = self::parseDatabaseUrl($params); if (isset($params['pdo']) && !$params['pdo'] instanceof \PDO) { throw \MailPoetVendor\Doctrine\DBAL\DBALException::invalidPdoInstance(); } elseif (isset($params['pdo'])) { $params['pdo']->setAttribute(\PDO::ATTR_ERRMODE, \PDO::ERRMODE_EXCEPTION); $params['driver'] = 'pdo_' . $params['pdo']->getAttribute(\PDO::ATTR_DRIVER_NAME); } else { self::_checkParams($params); } if (isset($params['driverClass'])) { $className = $params['driverClass']; } else { $className = self::$_driverMap[$params['driver']]; } $driver = new $className(); $wrapperClass = 'MailPoetVendor\\Doctrine\\DBAL\\Connection'; if (isset($params['wrapperClass'])) { if (\is_subclass_of($params['wrapperClass'], $wrapperClass)) { $wrapperClass = $params['wrapperClass']; } else { throw \MailPoetVendor\Doctrine\DBAL\DBALException::invalidWrapperClass($params['wrapperClass']); } } return new $wrapperClass($params, $driver, $config, $eventManager); } public static function getAvailableDrivers() { return \array_keys(self::$_driverMap); } private static function _checkParams(array $params) { if (!isset($params['driver']) && !isset($params['driverClass'])) { throw \MailPoetVendor\Doctrine\DBAL\DBALException::driverRequired(); } if (isset($params['driver']) && !isset(self::$_driverMap[$params['driver']])) { throw \MailPoetVendor\Doctrine\DBAL\DBALException::unknownDriver($params['driver'], \array_keys(self::$_driverMap)); } if (isset($params['driverClass']) && !\in_array('MailPoetVendor\\Doctrine\\DBAL\\Driver', \class_implements($params['driverClass'], \true))) { throw \MailPoetVendor\Doctrine\DBAL\DBALException::invalidDriverClass($params['driverClass']); } } private static function normalizeDatabaseUrlPath($urlPath) { return \substr($urlPath, 1); } private static function parseDatabaseUrl(array $params) { if (!isset($params['url'])) { return $params; } $url = \preg_replace('#^((?:pdo_)?sqlite3?):///#', '$1://localhost/', $params['url']); if (\PHP_VERSION_ID < 50408 && \strpos($url, '//') === 0) { $url = \parse_url('fake:' . $url); unset($url['scheme']); } else { $url = \parse_url($url); } if ($url === \false) { throw new \MailPoetVendor\Doctrine\DBAL\DBALException('Malformed parameter "url".'); } unset($params['pdo']); $params = self::parseDatabaseUrlScheme($url, $params); if (isset($url['host'])) { $params['host'] = $url['host']; } if (isset($url['port'])) { $params['port'] = $url['port']; } if (isset($url['user'])) { $params['user'] = $url['user']; } if (isset($url['pass'])) { $params['password'] = $url['pass']; } $params = self::parseDatabaseUrlPath($url, $params); $params = self::parseDatabaseUrlQuery($url, $params); return $params; } private static function parseDatabaseUrlPath(array $url, array $params) { if (!isset($url['path'])) { return $params; } $url['path'] = self::normalizeDatabaseUrlPath($url['path']); if (!isset($params['driver'])) { return self::parseRegularDatabaseUrlPath($url, $params); } if (\strpos($params['driver'], 'sqlite') !== \false) { return self::parseSqliteDatabaseUrlPath($url, $params); } return self::parseRegularDatabaseUrlPath($url, $params); } private static function parseDatabaseUrlQuery(array $url, array $params) { if (!isset($url['query'])) { return $params; } $query = array(); \parse_str($url['query'], $query); return \array_merge($params, $query); } private static function parseRegularDatabaseUrlPath(array $url, array $params) { $params['dbname'] = $url['path']; return $params; } private static function parseSqliteDatabaseUrlPath(array $url, array $params) { if ($url['path'] === ':memory:') { $params['memory'] = \true; return $params; } $params['path'] = $url['path']; return $params; } private static function parseDatabaseUrlScheme(array $url, array $params) { if (isset($url['scheme'])) { unset($params['driverClass']); $driver = \str_replace('-', '_', $url['scheme']); $params['driver'] = isset(self::$driverSchemeAliases[$driver]) ? self::$driverSchemeAliases[$driver] : $driver; return $params; } if (!isset($params['driverClass']) && !isset($params['driver'])) { throw \MailPoetVendor\Doctrine\DBAL\DBALException::driverRequired($params['url']); } return $params; } } 