<?php
 namespace MailPoetVendor\Doctrine\DBAL\Platforms; if (!defined('ABSPATH')) exit; use MailPoetVendor\Doctrine\DBAL\DBALException; use MailPoetVendor\Doctrine\DBAL\Connection; use MailPoetVendor\Doctrine\DBAL\Schema\Identifier; use MailPoetVendor\Doctrine\DBAL\Types; use MailPoetVendor\Doctrine\DBAL\Schema\Constraint; use MailPoetVendor\Doctrine\DBAL\Schema\Sequence; use MailPoetVendor\Doctrine\DBAL\Schema\Table; use MailPoetVendor\Doctrine\DBAL\Schema\Index; use MailPoetVendor\Doctrine\DBAL\Schema\ForeignKeyConstraint; use MailPoetVendor\Doctrine\DBAL\Schema\TableDiff; use MailPoetVendor\Doctrine\DBAL\Schema\Column; use MailPoetVendor\Doctrine\DBAL\Schema\ColumnDiff; use MailPoetVendor\Doctrine\DBAL\Types\Type; use MailPoetVendor\Doctrine\DBAL\Events; use MailPoetVendor\Doctrine\Common\EventManager; use MailPoetVendor\Doctrine\DBAL\Event\SchemaCreateTableEventArgs; use MailPoetVendor\Doctrine\DBAL\Event\SchemaCreateTableColumnEventArgs; use MailPoetVendor\Doctrine\DBAL\Event\SchemaDropTableEventArgs; use MailPoetVendor\Doctrine\DBAL\Event\SchemaAlterTableEventArgs; use MailPoetVendor\Doctrine\DBAL\Event\SchemaAlterTableAddColumnEventArgs; use MailPoetVendor\Doctrine\DBAL\Event\SchemaAlterTableRemoveColumnEventArgs; use MailPoetVendor\Doctrine\DBAL\Event\SchemaAlterTableChangeColumnEventArgs; use MailPoetVendor\Doctrine\DBAL\Event\SchemaAlterTableRenameColumnEventArgs; abstract class AbstractPlatform { const CREATE_INDEXES = 1; const CREATE_FOREIGNKEYS = 2; const DATE_INTERVAL_UNIT_SECOND = 'SECOND'; const DATE_INTERVAL_UNIT_MINUTE = 'MINUTE'; const DATE_INTERVAL_UNIT_HOUR = 'HOUR'; const DATE_INTERVAL_UNIT_DAY = 'DAY'; const DATE_INTERVAL_UNIT_WEEK = 'WEEK'; const DATE_INTERVAL_UNIT_MONTH = 'MONTH'; const DATE_INTERVAL_UNIT_QUARTER = 'QUARTER'; const DATE_INTERVAL_UNIT_YEAR = 'YEAR'; const TRIM_UNSPECIFIED = 0; const TRIM_LEADING = 1; const TRIM_TRAILING = 2; const TRIM_BOTH = 3; protected $doctrineTypeMapping = null; protected $doctrineTypeComments = null; protected $_eventManager; protected $_keywords; public function __construct() { } public function setEventManager(\MailPoetVendor\Doctrine\Common\EventManager $eventManager) { $this->_eventManager = $eventManager; } public function getEventManager() { return $this->_eventManager; } public abstract function getBooleanTypeDeclarationSQL(array $columnDef); public abstract function getIntegerTypeDeclarationSQL(array $columnDef); public abstract function getBigIntTypeDeclarationSQL(array $columnDef); public abstract function getSmallIntTypeDeclarationSQL(array $columnDef); protected abstract function _getCommonIntegerTypeDeclarationSQL(array $columnDef); protected abstract function initializeDoctrineTypeMappings(); private function initializeAllDoctrineTypeMappings() { $this->initializeDoctrineTypeMappings(); foreach (\MailPoetVendor\Doctrine\DBAL\Types\Type::getTypesMap() as $typeName => $className) { foreach (\MailPoetVendor\Doctrine\DBAL\Types\Type::getType($typeName)->getMappedDatabaseTypes($this) as $dbType) { $this->doctrineTypeMapping[$dbType] = $typeName; } } } public function getVarcharTypeDeclarationSQL(array $field) { if (!isset($field['length'])) { $field['length'] = $this->getVarcharDefaultLength(); } $fixed = isset($field['fixed']) ? $field['fixed'] : \false; if ($field['length'] > $this->getVarcharMaxLength()) { return $this->getClobTypeDeclarationSQL($field); } return $this->getVarcharTypeDeclarationSQLSnippet($field['length'], $fixed); } public function getBinaryTypeDeclarationSQL(array $field) { if (!isset($field['length'])) { $field['length'] = $this->getBinaryDefaultLength(); } $fixed = isset($field['fixed']) ? $field['fixed'] : \false; if ($field['length'] > $this->getBinaryMaxLength()) { return $this->getBlobTypeDeclarationSQL($field); } return $this->getBinaryTypeDeclarationSQLSnippet($field['length'], $fixed); } public function getGuidTypeDeclarationSQL(array $field) { $field['length'] = 36; $field['fixed'] = \true; return $this->getVarcharTypeDeclarationSQL($field); } public function getJsonTypeDeclarationSQL(array $field) { return $this->getClobTypeDeclarationSQL($field); } protected function getVarcharTypeDeclarationSQLSnippet($length, $fixed) { throw \MailPoetVendor\Doctrine\DBAL\DBALException::notSupported('VARCHARs not supported by Platform.'); } protected function getBinaryTypeDeclarationSQLSnippet($length, $fixed) { throw \MailPoetVendor\Doctrine\DBAL\DBALException::notSupported('BINARY/VARBINARY column types are not supported by this platform.'); } public abstract function getClobTypeDeclarationSQL(array $field); public abstract function getBlobTypeDeclarationSQL(array $field); public abstract function getName(); public function registerDoctrineTypeMapping($dbType, $doctrineType) { if ($this->doctrineTypeMapping === null) { $this->initializeAllDoctrineTypeMappings(); } if (!\MailPoetVendor\Doctrine\DBAL\Types\Type::hasType($doctrineType)) { throw \MailPoetVendor\Doctrine\DBAL\DBALException::typeNotFound($doctrineType); } $dbType = \strtolower($dbType); $this->doctrineTypeMapping[$dbType] = $doctrineType; } public function getDoctrineTypeMapping($dbType) { if ($this->doctrineTypeMapping === null) { $this->initializeAllDoctrineTypeMappings(); } $dbType = \strtolower($dbType); if (!isset($this->doctrineTypeMapping[$dbType])) { throw new \MailPoetVendor\Doctrine\DBAL\DBALException("Unknown database type " . $dbType . " requested, " . \get_class($this) . " may not support it."); } return $this->doctrineTypeMapping[$dbType]; } public function hasDoctrineTypeMappingFor($dbType) { if ($this->doctrineTypeMapping === null) { $this->initializeAllDoctrineTypeMappings(); } $dbType = \strtolower($dbType); return isset($this->doctrineTypeMapping[$dbType]); } protected function initializeCommentedDoctrineTypes() { $this->doctrineTypeComments = array(); foreach (\MailPoetVendor\Doctrine\DBAL\Types\Type::getTypesMap() as $typeName => $className) { $type = \MailPoetVendor\Doctrine\DBAL\Types\Type::getType($typeName); if ($type->requiresSQLCommentHint($this)) { $this->doctrineTypeComments[] = $typeName; } } } public function isCommentedDoctrineType(\MailPoetVendor\Doctrine\DBAL\Types\Type $doctrineType) { if ($this->doctrineTypeComments === null) { $this->initializeCommentedDoctrineTypes(); } return \in_array($doctrineType->getName(), $this->doctrineTypeComments); } public function markDoctrineTypeCommented($doctrineType) { if ($this->doctrineTypeComments === null) { $this->initializeCommentedDoctrineTypes(); } $this->doctrineTypeComments[] = $doctrineType instanceof \MailPoetVendor\Doctrine\DBAL\Types\Type ? $doctrineType->getName() : $doctrineType; } public function getDoctrineTypeComment(\MailPoetVendor\Doctrine\DBAL\Types\Type $doctrineType) { return '(DC2Type:' . $doctrineType->getName() . ')'; } protected function getColumnComment(\MailPoetVendor\Doctrine\DBAL\Schema\Column $column) { $comment = $column->getComment(); if ($this->isCommentedDoctrineType($column->getType())) { $comment .= $this->getDoctrineTypeComment($column->getType()); } return $comment; } public function getIdentifierQuoteCharacter() { return '"'; } public function getSqlCommentStartString() { return "--"; } public function getSqlCommentEndString() { return "\n"; } public function getVarcharMaxLength() { return 4000; } public function getVarcharDefaultLength() { return 255; } public function getBinaryMaxLength() { return 4000; } public function getBinaryDefaultLength() { return 255; } public function getWildcards() { return array('%', '_'); } public function getRegexpExpression() { throw \MailPoetVendor\Doctrine\DBAL\DBALException::notSupported(__METHOD__); } public function getGuidExpression() { throw \MailPoetVendor\Doctrine\DBAL\DBALException::notSupported(__METHOD__); } public function getAvgExpression($column) { return 'AVG(' . $column . ')'; } public function getCountExpression($column) { return 'COUNT(' . $column . ')'; } public function getMaxExpression($column) { return 'MAX(' . $column . ')'; } public function getMinExpression($column) { return 'MIN(' . $column . ')'; } public function getSumExpression($column) { return 'SUM(' . $column . ')'; } public function getMd5Expression($column) { return 'MD5(' . $column . ')'; } public function getLengthExpression($column) { return 'LENGTH(' . $column . ')'; } public function getSqrtExpression($column) { return 'SQRT(' . $column . ')'; } public function getRoundExpression($column, $decimals = 0) { return 'ROUND(' . $column . ', ' . $decimals . ')'; } public function getModExpression($expression1, $expression2) { return 'MOD(' . $expression1 . ', ' . $expression2 . ')'; } public function getTrimExpression($str, $pos = self::TRIM_UNSPECIFIED, $char = \false) { $expression = ''; switch ($pos) { case self::TRIM_LEADING: $expression = 'LEADING '; break; case self::TRIM_TRAILING: $expression = 'TRAILING '; break; case self::TRIM_BOTH: $expression = 'BOTH '; break; } if (\false !== $char) { $expression .= $char . ' '; } if ($pos || \false !== $char) { $expression .= 'FROM '; } return 'TRIM(' . $expression . $str . ')'; } public function getRtrimExpression($str) { return 'RTRIM(' . $str . ')'; } public function getLtrimExpression($str) { return 'LTRIM(' . $str . ')'; } public function getUpperExpression($str) { return 'UPPER(' . $str . ')'; } public function getLowerExpression($str) { return 'LOWER(' . $str . ')'; } public function getLocateExpression($str, $substr, $startPos = \false) { throw \MailPoetVendor\Doctrine\DBAL\DBALException::notSupported(__METHOD__); } public function getNowExpression() { return 'NOW()'; } public function getSubstringExpression($value, $from, $length = null) { if ($length === null) { return 'SUBSTRING(' . $value . ' FROM ' . $from . ')'; } return 'SUBSTRING(' . $value . ' FROM ' . $from . ' FOR ' . $length . ')'; } public function getConcatExpression() { return \join(' || ', \func_get_args()); } public function getNotExpression($expression) { return 'NOT(' . $expression . ')'; } public function getIsNullExpression($expression) { return $expression . ' IS NULL'; } public function getIsNotNullExpression($expression) { return $expression . ' IS NOT NULL'; } public function getBetweenExpression($expression, $value1, $value2) { return $expression . ' BETWEEN ' . $value1 . ' AND ' . $value2; } public function getAcosExpression($value) { return 'ACOS(' . $value . ')'; } public function getSinExpression($value) { return 'SIN(' . $value . ')'; } public function getPiExpression() { return 'PI()'; } public function getCosExpression($value) { return 'COS(' . $value . ')'; } public function getDateDiffExpression($date1, $date2) { throw \MailPoetVendor\Doctrine\DBAL\DBALException::notSupported(__METHOD__); } public function getDateAddSecondsExpression($date, $seconds) { return $this->getDateArithmeticIntervalExpression($date, '+', $seconds, self::DATE_INTERVAL_UNIT_SECOND); } public function getDateSubSecondsExpression($date, $seconds) { return $this->getDateArithmeticIntervalExpression($date, '-', $seconds, self::DATE_INTERVAL_UNIT_SECOND); } public function getDateAddMinutesExpression($date, $minutes) { return $this->getDateArithmeticIntervalExpression($date, '+', $minutes, self::DATE_INTERVAL_UNIT_MINUTE); } public function getDateSubMinutesExpression($date, $minutes) { return $this->getDateArithmeticIntervalExpression($date, '-', $minutes, self::DATE_INTERVAL_UNIT_MINUTE); } public function getDateAddHourExpression($date, $hours) { return $this->getDateArithmeticIntervalExpression($date, '+', $hours, self::DATE_INTERVAL_UNIT_HOUR); } public function getDateSubHourExpression($date, $hours) { return $this->getDateArithmeticIntervalExpression($date, '-', $hours, self::DATE_INTERVAL_UNIT_HOUR); } public function getDateAddDaysExpression($date, $days) { return $this->getDateArithmeticIntervalExpression($date, '+', $days, self::DATE_INTERVAL_UNIT_DAY); } public function getDateSubDaysExpression($date, $days) { return $this->getDateArithmeticIntervalExpression($date, '-', $days, self::DATE_INTERVAL_UNIT_DAY); } public function getDateAddWeeksExpression($date, $weeks) { return $this->getDateArithmeticIntervalExpression($date, '+', $weeks, self::DATE_INTERVAL_UNIT_WEEK); } public function getDateSubWeeksExpression($date, $weeks) { return $this->getDateArithmeticIntervalExpression($date, '-', $weeks, self::DATE_INTERVAL_UNIT_WEEK); } public function getDateAddMonthExpression($date, $months) { return $this->getDateArithmeticIntervalExpression($date, '+', $months, self::DATE_INTERVAL_UNIT_MONTH); } public function getDateSubMonthExpression($date, $months) { return $this->getDateArithmeticIntervalExpression($date, '-', $months, self::DATE_INTERVAL_UNIT_MONTH); } public function getDateAddQuartersExpression($date, $quarters) { return $this->getDateArithmeticIntervalExpression($date, '+', $quarters, self::DATE_INTERVAL_UNIT_QUARTER); } public function getDateSubQuartersExpression($date, $quarters) { return $this->getDateArithmeticIntervalExpression($date, '-', $quarters, self::DATE_INTERVAL_UNIT_QUARTER); } public function getDateAddYearsExpression($date, $years) { return $this->getDateArithmeticIntervalExpression($date, '+', $years, self::DATE_INTERVAL_UNIT_YEAR); } public function getDateSubYearsExpression($date, $years) { return $this->getDateArithmeticIntervalExpression($date, '-', $years, self::DATE_INTERVAL_UNIT_YEAR); } protected function getDateArithmeticIntervalExpression($date, $operator, $interval, $unit) { throw \MailPoetVendor\Doctrine\DBAL\DBALException::notSupported(__METHOD__); } public function getBitAndComparisonExpression($value1, $value2) { return '(' . $value1 . ' & ' . $value2 . ')'; } public function getBitOrComparisonExpression($value1, $value2) { return '(' . $value1 . ' | ' . $value2 . ')'; } public function getForUpdateSQL() { return 'FOR UPDATE'; } public function appendLockHint($fromClause, $lockMode) { return $fromClause; } public function getReadLockSQL() { return $this->getForUpdateSQL(); } public function getWriteLockSQL() { return $this->getForUpdateSQL(); } public function getDropDatabaseSQL($database) { return 'DROP DATABASE ' . $database; } public function getDropTableSQL($table) { $tableArg = $table; if ($table instanceof \MailPoetVendor\Doctrine\DBAL\Schema\Table) { $table = $table->getQuotedName($this); } elseif (!\is_string($table)) { throw new \InvalidArgumentException('getDropTableSQL() expects $table parameter to be string or \\Doctrine\\DBAL\\Schema\\Table.'); } if (null !== $this->_eventManager && $this->_eventManager->hasListeners(\MailPoetVendor\Doctrine\DBAL\Events::onSchemaDropTable)) { $eventArgs = new \MailPoetVendor\Doctrine\DBAL\Event\SchemaDropTableEventArgs($tableArg, $this); $this->_eventManager->dispatchEvent(\MailPoetVendor\Doctrine\DBAL\Events::onSchemaDropTable, $eventArgs); if ($eventArgs->isDefaultPrevented()) { return $eventArgs->getSql(); } } return 'DROP TABLE ' . $table; } public function getDropTemporaryTableSQL($table) { return $this->getDropTableSQL($table); } public function getDropIndexSQL($index, $table = null) { if ($index instanceof \MailPoetVendor\Doctrine\DBAL\Schema\Index) { $index = $index->getQuotedName($this); } elseif (!\is_string($index)) { throw new \InvalidArgumentException('AbstractPlatform::getDropIndexSQL() expects $index parameter to be string or \\Doctrine\\DBAL\\Schema\\Index.'); } return 'DROP INDEX ' . $index; } public function getDropConstraintSQL($constraint, $table) { if (!$constraint instanceof \MailPoetVendor\Doctrine\DBAL\Schema\Constraint) { $constraint = new \MailPoetVendor\Doctrine\DBAL\Schema\Identifier($constraint); } if (!$table instanceof \MailPoetVendor\Doctrine\DBAL\Schema\Table) { $table = new \MailPoetVendor\Doctrine\DBAL\Schema\Identifier($table); } $constraint = $constraint->getQuotedName($this); $table = $table->getQuotedName($this); return 'ALTER TABLE ' . $table . ' DROP CONSTRAINT ' . $constraint; } public function getDropForeignKeySQL($foreignKey, $table) { if (!$foreignKey instanceof \MailPoetVendor\Doctrine\DBAL\Schema\ForeignKeyConstraint) { $foreignKey = new \MailPoetVendor\Doctrine\DBAL\Schema\Identifier($foreignKey); } if (!$table instanceof \MailPoetVendor\Doctrine\DBAL\Schema\Table) { $table = new \MailPoetVendor\Doctrine\DBAL\Schema\Identifier($table); } $foreignKey = $foreignKey->getQuotedName($this); $table = $table->getQuotedName($this); return 'ALTER TABLE ' . $table . ' DROP FOREIGN KEY ' . $foreignKey; } public function getCreateTableSQL(\MailPoetVendor\Doctrine\DBAL\Schema\Table $table, $createFlags = self::CREATE_INDEXES) { if (!\is_int($createFlags)) { throw new \InvalidArgumentException("Second argument of AbstractPlatform::getCreateTableSQL() has to be integer."); } if (\count($table->getColumns()) === 0) { throw \MailPoetVendor\Doctrine\DBAL\DBALException::noColumnsSpecifiedForTable($table->getName()); } $tableName = $table->getQuotedName($this); $options = $table->getOptions(); $options['uniqueConstraints'] = array(); $options['indexes'] = array(); $options['primary'] = array(); if (($createFlags & self::CREATE_INDEXES) > 0) { foreach ($table->getIndexes() as $index) { if ($index->isPrimary()) { $options['primary'] = $index->getQuotedColumns($this); $options['primary_index'] = $index; } else { $options['indexes'][$index->getQuotedName($this)] = $index; } } } $columnSql = array(); $columns = array(); foreach ($table->getColumns() as $column) { if (null !== $this->_eventManager && $this->_eventManager->hasListeners(\MailPoetVendor\Doctrine\DBAL\Events::onSchemaCreateTableColumn)) { $eventArgs = new \MailPoetVendor\Doctrine\DBAL\Event\SchemaCreateTableColumnEventArgs($column, $table, $this); $this->_eventManager->dispatchEvent(\MailPoetVendor\Doctrine\DBAL\Events::onSchemaCreateTableColumn, $eventArgs); $columnSql = \array_merge($columnSql, $eventArgs->getSql()); if ($eventArgs->isDefaultPrevented()) { continue; } } $columnData = $column->toArray(); $columnData['name'] = $column->getQuotedName($this); $columnData['version'] = $column->hasPlatformOption("version") ? $column->getPlatformOption('version') : \false; $columnData['comment'] = $this->getColumnComment($column); if (\strtolower($columnData['type']) == "string" && $columnData['length'] === null) { $columnData['length'] = 255; } if (\in_array($column->getName(), $options['primary'])) { $columnData['primary'] = \true; } $columns[$columnData['name']] = $columnData; } if (($createFlags & self::CREATE_FOREIGNKEYS) > 0) { $options['foreignKeys'] = array(); foreach ($table->getForeignKeys() as $fkConstraint) { $options['foreignKeys'][] = $fkConstraint; } } if (null !== $this->_eventManager && $this->_eventManager->hasListeners(\MailPoetVendor\Doctrine\DBAL\Events::onSchemaCreateTable)) { $eventArgs = new \MailPoetVendor\Doctrine\DBAL\Event\SchemaCreateTableEventArgs($table, $columns, $options, $this); $this->_eventManager->dispatchEvent(\MailPoetVendor\Doctrine\DBAL\Events::onSchemaCreateTable, $eventArgs); if ($eventArgs->isDefaultPrevented()) { return \array_merge($eventArgs->getSql(), $columnSql); } } $sql = $this->_getCreateTableSQL($tableName, $columns, $options); if ($this->supportsCommentOnStatement()) { foreach ($table->getColumns() as $column) { $comment = $this->getColumnComment($column); if (null !== $comment && '' !== $comment) { $sql[] = $this->getCommentOnColumnSQL($tableName, $column->getQuotedName($this), $comment); } } } return \array_merge($sql, $columnSql); } public function getCommentOnColumnSQL($tableName, $columnName, $comment) { $tableName = new \MailPoetVendor\Doctrine\DBAL\Schema\Identifier($tableName); $columnName = new \MailPoetVendor\Doctrine\DBAL\Schema\Identifier($columnName); $comment = $this->quoteStringLiteral($comment); return "COMMENT ON COLUMN " . $tableName->getQuotedName($this) . "." . $columnName->getQuotedName($this) . " IS " . $comment; } protected function _getCreateTableSQL($tableName, array $columns, array $options = array()) { $columnListSql = $this->getColumnDeclarationListSQL($columns); if (isset($options['uniqueConstraints']) && !empty($options['uniqueConstraints'])) { foreach ($options['uniqueConstraints'] as $name => $definition) { $columnListSql .= ', ' . $this->getUniqueConstraintDeclarationSQL($name, $definition); } } if (isset($options['primary']) && !empty($options['primary'])) { $columnListSql .= ', PRIMARY KEY(' . \implode(', ', \array_unique(\array_values($options['primary']))) . ')'; } if (isset($options['indexes']) && !empty($options['indexes'])) { foreach ($options['indexes'] as $index => $definition) { $columnListSql .= ', ' . $this->getIndexDeclarationSQL($index, $definition); } } $query = 'CREATE TABLE ' . $tableName . ' (' . $columnListSql; $check = $this->getCheckDeclarationSQL($columns); if (!empty($check)) { $query .= ', ' . $check; } $query .= ')'; $sql[] = $query; if (isset($options['foreignKeys'])) { foreach ((array) $options['foreignKeys'] as $definition) { $sql[] = $this->getCreateForeignKeySQL($definition, $tableName); } } return $sql; } public function getCreateTemporaryTableSnippetSQL() { return "CREATE TEMPORARY TABLE"; } public function getCreateSequenceSQL(\MailPoetVendor\Doctrine\DBAL\Schema\Sequence $sequence) { throw \MailPoetVendor\Doctrine\DBAL\DBALException::notSupported(__METHOD__); } public function getAlterSequenceSQL(\MailPoetVendor\Doctrine\DBAL\Schema\Sequence $sequence) { throw \MailPoetVendor\Doctrine\DBAL\DBALException::notSupported(__METHOD__); } public function getCreateConstraintSQL(\MailPoetVendor\Doctrine\DBAL\Schema\Constraint $constraint, $table) { if ($table instanceof \MailPoetVendor\Doctrine\DBAL\Schema\Table) { $table = $table->getQuotedName($this); } $query = 'ALTER TABLE ' . $table . ' ADD CONSTRAINT ' . $constraint->getQuotedName($this); $columnList = '(' . \implode(', ', $constraint->getQuotedColumns($this)) . ')'; $referencesClause = ''; if ($constraint instanceof \MailPoetVendor\Doctrine\DBAL\Schema\Index) { if ($constraint->isPrimary()) { $query .= ' PRIMARY KEY'; } elseif ($constraint->isUnique()) { $query .= ' UNIQUE'; } else { throw new \InvalidArgumentException('Can only create primary or unique constraints, no common indexes with getCreateConstraintSQL().'); } } elseif ($constraint instanceof \MailPoetVendor\Doctrine\DBAL\Schema\ForeignKeyConstraint) { $query .= ' FOREIGN KEY'; $referencesClause = ' REFERENCES ' . $constraint->getQuotedForeignTableName($this) . ' (' . \implode(', ', $constraint->getQuotedForeignColumns($this)) . ')'; } $query .= ' ' . $columnList . $referencesClause; return $query; } public function getCreateIndexSQL(\MailPoetVendor\Doctrine\DBAL\Schema\Index $index, $table) { if ($table instanceof \MailPoetVendor\Doctrine\DBAL\Schema\Table) { $table = $table->getQuotedName($this); } $name = $index->getQuotedName($this); $columns = $index->getQuotedColumns($this); if (\count($columns) == 0) { throw new \InvalidArgumentException("Incomplete definition. 'columns' required."); } if ($index->isPrimary()) { return $this->getCreatePrimaryKeySQL($index, $table); } $query = 'CREATE ' . $this->getCreateIndexSQLFlags($index) . 'INDEX ' . $name . ' ON ' . $table; $query .= ' (' . $this->getIndexFieldDeclarationListSQL($columns) . ')' . $this->getPartialIndexSQL($index); return $query; } protected function getPartialIndexSQL(\MailPoetVendor\Doctrine\DBAL\Schema\Index $index) { if ($this->supportsPartialIndexes() && $index->hasOption('where')) { return ' WHERE ' . $index->getOption('where'); } return ''; } protected function getCreateIndexSQLFlags(\MailPoetVendor\Doctrine\DBAL\Schema\Index $index) { return $index->isUnique() ? 'UNIQUE ' : ''; } public function getCreatePrimaryKeySQL(\MailPoetVendor\Doctrine\DBAL\Schema\Index $index, $table) { return 'ALTER TABLE ' . $table . ' ADD PRIMARY KEY (' . $this->getIndexFieldDeclarationListSQL($index->getQuotedColumns($this)) . ')'; } public function getCreateSchemaSQL($schemaName) { throw \MailPoetVendor\Doctrine\DBAL\DBALException::notSupported(__METHOD__); } public function quoteIdentifier($str) { if (\strpos($str, ".") !== \false) { $parts = \array_map(array($this, "quoteSingleIdentifier"), \explode(".", $str)); return \implode(".", $parts); } return $this->quoteSingleIdentifier($str); } public function quoteSingleIdentifier($str) { $c = $this->getIdentifierQuoteCharacter(); return $c . \str_replace($c, $c . $c, $str) . $c; } public function getCreateForeignKeySQL(\MailPoetVendor\Doctrine\DBAL\Schema\ForeignKeyConstraint $foreignKey, $table) { if ($table instanceof \MailPoetVendor\Doctrine\DBAL\Schema\Table) { $table = $table->getQuotedName($this); } $query = 'ALTER TABLE ' . $table . ' ADD ' . $this->getForeignKeyDeclarationSQL($foreignKey); return $query; } public function getAlterTableSQL(\MailPoetVendor\Doctrine\DBAL\Schema\TableDiff $diff) { throw \MailPoetVendor\Doctrine\DBAL\DBALException::notSupported(__METHOD__); } protected function onSchemaAlterTableAddColumn(\MailPoetVendor\Doctrine\DBAL\Schema\Column $column, \MailPoetVendor\Doctrine\DBAL\Schema\TableDiff $diff, &$columnSql) { if (null === $this->_eventManager) { return \false; } if (!$this->_eventManager->hasListeners(\MailPoetVendor\Doctrine\DBAL\Events::onSchemaAlterTableAddColumn)) { return \false; } $eventArgs = new \MailPoetVendor\Doctrine\DBAL\Event\SchemaAlterTableAddColumnEventArgs($column, $diff, $this); $this->_eventManager->dispatchEvent(\MailPoetVendor\Doctrine\DBAL\Events::onSchemaAlterTableAddColumn, $eventArgs); $columnSql = \array_merge($columnSql, $eventArgs->getSql()); return $eventArgs->isDefaultPrevented(); } protected function onSchemaAlterTableRemoveColumn(\MailPoetVendor\Doctrine\DBAL\Schema\Column $column, \MailPoetVendor\Doctrine\DBAL\Schema\TableDiff $diff, &$columnSql) { if (null === $this->_eventManager) { return \false; } if (!$this->_eventManager->hasListeners(\MailPoetVendor\Doctrine\DBAL\Events::onSchemaAlterTableRemoveColumn)) { return \false; } $eventArgs = new \MailPoetVendor\Doctrine\DBAL\Event\SchemaAlterTableRemoveColumnEventArgs($column, $diff, $this); $this->_eventManager->dispatchEvent(\MailPoetVendor\Doctrine\DBAL\Events::onSchemaAlterTableRemoveColumn, $eventArgs); $columnSql = \array_merge($columnSql, $eventArgs->getSql()); return $eventArgs->isDefaultPrevented(); } protected function onSchemaAlterTableChangeColumn(\MailPoetVendor\Doctrine\DBAL\Schema\ColumnDiff $columnDiff, \MailPoetVendor\Doctrine\DBAL\Schema\TableDiff $diff, &$columnSql) { if (null === $this->_eventManager) { return \false; } if (!$this->_eventManager->hasListeners(\MailPoetVendor\Doctrine\DBAL\Events::onSchemaAlterTableChangeColumn)) { return \false; } $eventArgs = new \MailPoetVendor\Doctrine\DBAL\Event\SchemaAlterTableChangeColumnEventArgs($columnDiff, $diff, $this); $this->_eventManager->dispatchEvent(\MailPoetVendor\Doctrine\DBAL\Events::onSchemaAlterTableChangeColumn, $eventArgs); $columnSql = \array_merge($columnSql, $eventArgs->getSql()); return $eventArgs->isDefaultPrevented(); } protected function onSchemaAlterTableRenameColumn($oldColumnName, \MailPoetVendor\Doctrine\DBAL\Schema\Column $column, \MailPoetVendor\Doctrine\DBAL\Schema\TableDiff $diff, &$columnSql) { if (null === $this->_eventManager) { return \false; } if (!$this->_eventManager->hasListeners(\MailPoetVendor\Doctrine\DBAL\Events::onSchemaAlterTableRenameColumn)) { return \false; } $eventArgs = new \MailPoetVendor\Doctrine\DBAL\Event\SchemaAlterTableRenameColumnEventArgs($oldColumnName, $column, $diff, $this); $this->_eventManager->dispatchEvent(\MailPoetVendor\Doctrine\DBAL\Events::onSchemaAlterTableRenameColumn, $eventArgs); $columnSql = \array_merge($columnSql, $eventArgs->getSql()); return $eventArgs->isDefaultPrevented(); } protected function onSchemaAlterTable(\MailPoetVendor\Doctrine\DBAL\Schema\TableDiff $diff, &$sql) { if (null === $this->_eventManager) { return \false; } if (!$this->_eventManager->hasListeners(\MailPoetVendor\Doctrine\DBAL\Events::onSchemaAlterTable)) { return \false; } $eventArgs = new \MailPoetVendor\Doctrine\DBAL\Event\SchemaAlterTableEventArgs($diff, $this); $this->_eventManager->dispatchEvent(\MailPoetVendor\Doctrine\DBAL\Events::onSchemaAlterTable, $eventArgs); $sql = \array_merge($sql, $eventArgs->getSql()); return $eventArgs->isDefaultPrevented(); } protected function getPreAlterTableIndexForeignKeySQL(\MailPoetVendor\Doctrine\DBAL\Schema\TableDiff $diff) { $tableName = $diff->getName($this)->getQuotedName($this); $sql = array(); if ($this->supportsForeignKeyConstraints()) { foreach ($diff->removedForeignKeys as $foreignKey) { $sql[] = $this->getDropForeignKeySQL($foreignKey, $tableName); } foreach ($diff->changedForeignKeys as $foreignKey) { $sql[] = $this->getDropForeignKeySQL($foreignKey, $tableName); } } foreach ($diff->removedIndexes as $index) { $sql[] = $this->getDropIndexSQL($index, $tableName); } foreach ($diff->changedIndexes as $index) { $sql[] = $this->getDropIndexSQL($index, $tableName); } return $sql; } protected function getPostAlterTableIndexForeignKeySQL(\MailPoetVendor\Doctrine\DBAL\Schema\TableDiff $diff) { $tableName = \false !== $diff->newName ? $diff->getNewName()->getQuotedName($this) : $diff->getName($this)->getQuotedName($this); $sql = array(); if ($this->supportsForeignKeyConstraints()) { foreach ($diff->addedForeignKeys as $foreignKey) { $sql[] = $this->getCreateForeignKeySQL($foreignKey, $tableName); } foreach ($diff->changedForeignKeys as $foreignKey) { $sql[] = $this->getCreateForeignKeySQL($foreignKey, $tableName); } } foreach ($diff->addedIndexes as $index) { $sql[] = $this->getCreateIndexSQL($index, $tableName); } foreach ($diff->changedIndexes as $index) { $sql[] = $this->getCreateIndexSQL($index, $tableName); } foreach ($diff->renamedIndexes as $oldIndexName => $index) { $oldIndexName = new \MailPoetVendor\Doctrine\DBAL\Schema\Identifier($oldIndexName); $sql = \array_merge($sql, $this->getRenameIndexSQL($oldIndexName->getQuotedName($this), $index, $tableName)); } return $sql; } protected function getRenameIndexSQL($oldIndexName, \MailPoetVendor\Doctrine\DBAL\Schema\Index $index, $tableName) { return array($this->getDropIndexSQL($oldIndexName, $tableName), $this->getCreateIndexSQL($index, $tableName)); } protected function _getAlterTableIndexForeignKeySQL(\MailPoetVendor\Doctrine\DBAL\Schema\TableDiff $diff) { return \array_merge($this->getPreAlterTableIndexForeignKeySQL($diff), $this->getPostAlterTableIndexForeignKeySQL($diff)); } public function getColumnDeclarationListSQL(array $fields) { $queryFields = array(); foreach ($fields as $fieldName => $field) { $queryFields[] = $this->getColumnDeclarationSQL($fieldName, $field); } return \implode(', ', $queryFields); } public function getColumnDeclarationSQL($name, array $field) { if (isset($field['columnDefinition'])) { $columnDef = $this->getCustomTypeDeclarationSQL($field); } else { $default = $this->getDefaultValueDeclarationSQL($field); $charset = isset($field['charset']) && $field['charset'] ? ' ' . $this->getColumnCharsetDeclarationSQL($field['charset']) : ''; $collation = isset($field['collation']) && $field['collation'] ? ' ' . $this->getColumnCollationDeclarationSQL($field['collation']) : ''; $notnull = isset($field['notnull']) && $field['notnull'] ? ' NOT NULL' : ''; $unique = isset($field['unique']) && $field['unique'] ? ' ' . $this->getUniqueFieldDeclarationSQL() : ''; $check = isset($field['check']) && $field['check'] ? ' ' . $field['check'] : ''; $typeDecl = $field['type']->getSqlDeclaration($field, $this); $columnDef = $typeDecl . $charset . $default . $notnull . $unique . $check . $collation; if ($this->supportsInlineColumnComments() && isset($field['comment']) && $field['comment'] !== '') { $columnDef .= " COMMENT " . $this->quoteStringLiteral($field['comment']); } } return $name . ' ' . $columnDef; } public function getDecimalTypeDeclarationSQL(array $columnDef) { $columnDef['precision'] = !isset($columnDef['precision']) || empty($columnDef['precision']) ? 10 : $columnDef['precision']; $columnDef['scale'] = !isset($columnDef['scale']) || empty($columnDef['scale']) ? 0 : $columnDef['scale']; return 'NUMERIC(' . $columnDef['precision'] . ', ' . $columnDef['scale'] . ')'; } public function getDefaultValueDeclarationSQL($field) { $default = empty($field['notnull']) ? ' DEFAULT NULL' : ''; if (isset($field['default'])) { $default = " DEFAULT '" . $field['default'] . "'"; if (isset($field['type'])) { if (\in_array((string) $field['type'], array("Integer", "BigInt", "SmallInt"))) { $default = " DEFAULT " . $field['default']; } elseif (\in_array((string) $field['type'], array('DateTime', 'DateTimeTz')) && $field['default'] == $this->getCurrentTimestampSQL()) { $default = " DEFAULT " . $this->getCurrentTimestampSQL(); } elseif ((string) $field['type'] == 'Time' && $field['default'] == $this->getCurrentTimeSQL()) { $default = " DEFAULT " . $this->getCurrentTimeSQL(); } elseif ((string) $field['type'] == 'Date' && $field['default'] == $this->getCurrentDateSQL()) { $default = " DEFAULT " . $this->getCurrentDateSQL(); } elseif ((string) $field['type'] == 'Boolean') { $default = " DEFAULT '" . $this->convertBooleans($field['default']) . "'"; } } } return $default; } public function getCheckDeclarationSQL(array $definition) { $constraints = array(); foreach ($definition as $field => $def) { if (\is_string($def)) { $constraints[] = 'CHECK (' . $def . ')'; } else { if (isset($def['min'])) { $constraints[] = 'CHECK (' . $field . ' >= ' . $def['min'] . ')'; } if (isset($def['max'])) { $constraints[] = 'CHECK (' . $field . ' <= ' . $def['max'] . ')'; } } } return \implode(', ', $constraints); } public function getUniqueConstraintDeclarationSQL($name, \MailPoetVendor\Doctrine\DBAL\Schema\Index $index) { $columns = $index->getQuotedColumns($this); $name = new \MailPoetVendor\Doctrine\DBAL\Schema\Identifier($name); if (\count($columns) === 0) { throw new \InvalidArgumentException("Incomplete definition. 'columns' required."); } return 'CONSTRAINT ' . $name->getQuotedName($this) . ' UNIQUE (' . $this->getIndexFieldDeclarationListSQL($columns) . ')' . $this->getPartialIndexSQL($index); } public function getIndexDeclarationSQL($name, \MailPoetVendor\Doctrine\DBAL\Schema\Index $index) { $columns = $index->getQuotedColumns($this); $name = new \MailPoetVendor\Doctrine\DBAL\Schema\Identifier($name); if (\count($columns) === 0) { throw new \InvalidArgumentException("Incomplete definition. 'columns' required."); } return $this->getCreateIndexSQLFlags($index) . 'INDEX ' . $name->getQuotedName($this) . ' (' . $this->getIndexFieldDeclarationListSQL($columns) . ')' . $this->getPartialIndexSQL($index); } public function getCustomTypeDeclarationSQL(array $columnDef) { return $columnDef['columnDefinition']; } public function getIndexFieldDeclarationListSQL(array $fields) { $ret = array(); foreach ($fields as $field => $definition) { if (\is_array($definition)) { $ret[] = $field; } else { $ret[] = $definition; } } return \implode(', ', $ret); } public function getTemporaryTableSQL() { return 'TEMPORARY'; } public function getTemporaryTableName($tableName) { return $tableName; } public function getForeignKeyDeclarationSQL(\MailPoetVendor\Doctrine\DBAL\Schema\ForeignKeyConstraint $foreignKey) { $sql = $this->getForeignKeyBaseDeclarationSQL($foreignKey); $sql .= $this->getAdvancedForeignKeyOptionsSQL($foreignKey); return $sql; } public function getAdvancedForeignKeyOptionsSQL(\MailPoetVendor\Doctrine\DBAL\Schema\ForeignKeyConstraint $foreignKey) { $query = ''; if ($this->supportsForeignKeyOnUpdate() && $foreignKey->hasOption('onUpdate')) { $query .= ' ON UPDATE ' . $this->getForeignKeyReferentialActionSQL($foreignKey->getOption('onUpdate')); } if ($foreignKey->hasOption('onDelete')) { $query .= ' ON DELETE ' . $this->getForeignKeyReferentialActionSQL($foreignKey->getOption('onDelete')); } return $query; } public function getForeignKeyReferentialActionSQL($action) { $upper = \strtoupper($action); switch ($upper) { case 'CASCADE': case 'SET NULL': case 'NO ACTION': case 'RESTRICT': case 'SET DEFAULT': return $upper; default: throw new \InvalidArgumentException('Invalid foreign key action: ' . $upper); } } public function getForeignKeyBaseDeclarationSQL(\MailPoetVendor\Doctrine\DBAL\Schema\ForeignKeyConstraint $foreignKey) { $sql = ''; if (\strlen($foreignKey->getName())) { $sql .= 'CONSTRAINT ' . $foreignKey->getQuotedName($this) . ' '; } $sql .= 'FOREIGN KEY ('; if (\count($foreignKey->getLocalColumns()) === 0) { throw new \InvalidArgumentException("Incomplete definition. 'local' required."); } if (\count($foreignKey->getForeignColumns()) === 0) { throw new \InvalidArgumentException("Incomplete definition. 'foreign' required."); } if (\strlen($foreignKey->getForeignTableName()) === 0) { throw new \InvalidArgumentException("Incomplete definition. 'foreignTable' required."); } $sql .= \implode(', ', $foreignKey->getQuotedLocalColumns($this)) . ') REFERENCES ' . $foreignKey->getQuotedForeignTableName($this) . ' (' . \implode(', ', $foreignKey->getQuotedForeignColumns($this)) . ')'; return $sql; } public function getUniqueFieldDeclarationSQL() { return 'UNIQUE'; } public function getColumnCharsetDeclarationSQL($charset) { return ''; } public function getColumnCollationDeclarationSQL($collation) { return $this->supportsColumnCollation() ? 'COLLATE ' . $collation : ''; } public function prefersSequences() { return \false; } public function prefersIdentityColumns() { return \false; } public function convertBooleans($item) { if (\is_array($item)) { foreach ($item as $k => $value) { if (\is_bool($value)) { $item[$k] = (int) $value; } } } elseif (\is_bool($item)) { $item = (int) $item; } return $item; } public function convertFromBoolean($item) { return null === $item ? null : (bool) $item; } public function convertBooleansToDatabaseValue($item) { return $this->convertBooleans($item); } public function getCurrentDateSQL() { return 'CURRENT_DATE'; } public function getCurrentTimeSQL() { return 'CURRENT_TIME'; } public function getCurrentTimestampSQL() { return 'CURRENT_TIMESTAMP'; } protected function _getTransactionIsolationLevelSQL($level) { switch ($level) { case \MailPoetVendor\Doctrine\DBAL\Connection::TRANSACTION_READ_UNCOMMITTED: return 'READ UNCOMMITTED'; case \MailPoetVendor\Doctrine\DBAL\Connection::TRANSACTION_READ_COMMITTED: return 'READ COMMITTED'; case \MailPoetVendor\Doctrine\DBAL\Connection::TRANSACTION_REPEATABLE_READ: return 'REPEATABLE READ'; case \MailPoetVendor\Doctrine\DBAL\Connection::TRANSACTION_SERIALIZABLE: return 'SERIALIZABLE'; default: throw new \InvalidArgumentException('Invalid isolation level:' . $level); } } public function getListDatabasesSQL() { throw \MailPoetVendor\Doctrine\DBAL\DBALException::notSupported(__METHOD__); } public function getListNamespacesSQL() { throw \MailPoetVendor\Doctrine\DBAL\DBALException::notSupported(__METHOD__); } public function getListSequencesSQL($database) { throw \MailPoetVendor\Doctrine\DBAL\DBALException::notSupported(__METHOD__); } public function getListTableConstraintsSQL($table) { throw \MailPoetVendor\Doctrine\DBAL\DBALException::notSupported(__METHOD__); } public function getListTableColumnsSQL($table, $database = null) { throw \MailPoetVendor\Doctrine\DBAL\DBALException::notSupported(__METHOD__); } public function getListTablesSQL() { throw \MailPoetVendor\Doctrine\DBAL\DBALException::notSupported(__METHOD__); } public function getListUsersSQL() { throw \MailPoetVendor\Doctrine\DBAL\DBALException::notSupported(__METHOD__); } public function getListViewsSQL($database) { throw \MailPoetVendor\Doctrine\DBAL\DBALException::notSupported(__METHOD__); } public function getListTableIndexesSQL($table, $currentDatabase = null) { throw \MailPoetVendor\Doctrine\DBAL\DBALException::notSupported(__METHOD__); } public function getListTableForeignKeysSQL($table) { throw \MailPoetVendor\Doctrine\DBAL\DBALException::notSupported(__METHOD__); } public function getCreateViewSQL($name, $sql) { throw \MailPoetVendor\Doctrine\DBAL\DBALException::notSupported(__METHOD__); } public function getDropViewSQL($name) { throw \MailPoetVendor\Doctrine\DBAL\DBALException::notSupported(__METHOD__); } public function getDropSequenceSQL($sequence) { throw \MailPoetVendor\Doctrine\DBAL\DBALException::notSupported(__METHOD__); } public function getSequenceNextValSQL($sequenceName) { throw \MailPoetVendor\Doctrine\DBAL\DBALException::notSupported(__METHOD__); } public function getCreateDatabaseSQL($database) { throw \MailPoetVendor\Doctrine\DBAL\DBALException::notSupported(__METHOD__); } public function getSetTransactionIsolationSQL($level) { throw \MailPoetVendor\Doctrine\DBAL\DBALException::notSupported(__METHOD__); } public function getDateTimeTypeDeclarationSQL(array $fieldDeclaration) { throw \MailPoetVendor\Doctrine\DBAL\DBALException::notSupported(__METHOD__); } public function getDateTimeTzTypeDeclarationSQL(array $fieldDeclaration) { return $this->getDateTimeTypeDeclarationSQL($fieldDeclaration); } public function getDateTypeDeclarationSQL(array $fieldDeclaration) { throw \MailPoetVendor\Doctrine\DBAL\DBALException::notSupported(__METHOD__); } public function getTimeTypeDeclarationSQL(array $fieldDeclaration) { throw \MailPoetVendor\Doctrine\DBAL\DBALException::notSupported(__METHOD__); } public function getFloatDeclarationSQL(array $fieldDeclaration) { return 'DOUBLE PRECISION'; } public function getDefaultTransactionIsolationLevel() { return \MailPoetVendor\Doctrine\DBAL\Connection::TRANSACTION_READ_COMMITTED; } public function supportsSequences() { return \false; } public function supportsIdentityColumns() { return \false; } public function usesSequenceEmulatedIdentityColumns() { return \false; } public function getIdentitySequenceName($tableName, $columnName) { throw \MailPoetVendor\Doctrine\DBAL\DBALException::notSupported(__METHOD__); } public function supportsIndexes() { return \true; } public function supportsPartialIndexes() { return \false; } public function supportsAlterTable() { return \true; } public function supportsTransactions() { return \true; } public function supportsSavepoints() { return \true; } public function supportsReleaseSavepoints() { return $this->supportsSavepoints(); } public function supportsPrimaryConstraints() { return \true; } public function supportsForeignKeyConstraints() { return \true; } public function supportsForeignKeyOnUpdate() { return $this->supportsForeignKeyConstraints() && \true; } public function supportsSchemas() { return \false; } public function canEmulateSchemas() { return \false; } public function getDefaultSchemaName() { throw \MailPoetVendor\Doctrine\DBAL\DBALException::notSupported(__METHOD__); } public function supportsCreateDropDatabase() { return \true; } public function supportsGettingAffectedRows() { return \true; } public function supportsInlineColumnComments() { return \false; } public function supportsCommentOnStatement() { return \false; } public function hasNativeGuidType() { return \false; } public function hasNativeJsonType() { return \false; } public function getIdentityColumnNullInsertSQL() { return ""; } public function supportsViews() { return \true; } public function supportsColumnCollation() { return \false; } public function getDateTimeFormatString() { return 'Y-m-d H:i:s'; } public function getDateTimeTzFormatString() { return 'Y-m-d H:i:s'; } public function getDateFormatString() { return 'Y-m-d'; } public function getTimeFormatString() { return 'H:i:s'; } public final function modifyLimitQuery($query, $limit, $offset = null) { if ($limit !== null) { $limit = (int) $limit; } if ($offset !== null) { $offset = (int) $offset; if ($offset < 0) { throw new \MailPoetVendor\Doctrine\DBAL\DBALException("LIMIT argument offset={$offset} is not valid"); } if ($offset > 0 && !$this->supportsLimitOffset()) { throw new \MailPoetVendor\Doctrine\DBAL\DBALException(\sprintf("Platform %s does not support offset values in limit queries.", $this->getName())); } } return $this->doModifyLimitQuery($query, $limit, $offset); } protected function doModifyLimitQuery($query, $limit, $offset) { if ($limit !== null) { $query .= ' LIMIT ' . $limit; } if ($offset !== null) { $query .= ' OFFSET ' . $offset; } return $query; } public function supportsLimitOffset() { return \true; } public function getSQLResultCasing($column) { return $column; } public function fixSchemaElementName($schemaElementName) { return $schemaElementName; } public function getMaxIdentifierLength() { return 63; } public function getEmptyIdentityInsertSQL($tableName, $identifierColumnName) { return 'INSERT INTO ' . $tableName . ' (' . $identifierColumnName . ') VALUES (null)'; } public function getTruncateTableSQL($tableName, $cascade = \false) { $tableIdentifier = new \MailPoetVendor\Doctrine\DBAL\Schema\Identifier($tableName); return 'TRUNCATE ' . $tableIdentifier->getQuotedName($this); } public function getDummySelectSQL() { return 'SELECT 1'; } public function createSavePoint($savepoint) { return 'SAVEPOINT ' . $savepoint; } public function releaseSavePoint($savepoint) { return 'RELEASE SAVEPOINT ' . $savepoint; } public function rollbackSavePoint($savepoint) { return 'ROLLBACK TO SAVEPOINT ' . $savepoint; } public final function getReservedKeywordsList() { if ($this->_keywords) { return $this->_keywords; } $class = $this->getReservedKeywordsClass(); $keywords = new $class(); if (!$keywords instanceof \MailPoetVendor\Doctrine\DBAL\Platforms\Keywords\KeywordList) { throw \MailPoetVendor\Doctrine\DBAL\DBALException::notSupported(__METHOD__); } $this->_keywords = $keywords; return $keywords; } protected function getReservedKeywordsClass() { throw \MailPoetVendor\Doctrine\DBAL\DBALException::notSupported(__METHOD__); } public function quoteStringLiteral($str) { $c = $this->getStringLiteralQuoteCharacter(); return $c . \str_replace($c, $c . $c, $str) . $c; } public function getStringLiteralQuoteCharacter() { return "'"; } } 