<?php
 namespace MailPoetVendor\Doctrine\DBAL; if (!defined('ABSPATH')) exit; class SQLParserUtils { const POSITIONAL_TOKEN = '\\?'; const NAMED_TOKEN = '(?<!:):[a-zA-Z_][a-zA-Z0-9_]*'; const ESCAPED_SINGLE_QUOTED_TEXT = "(?:'(?:\\\\\\\\)+'|'(?:[^'\\\\]|\\\\'?|'')*')"; const ESCAPED_DOUBLE_QUOTED_TEXT = '(?:"(?:\\\\\\\\)+"|"(?:[^"\\\\]|\\\\"?)*")'; const ESCAPED_BACKTICK_QUOTED_TEXT = '(?:`(?:\\\\\\\\)+`|`(?:[^`\\\\]|\\\\`?)*`)'; const ESCAPED_BRACKET_QUOTED_TEXT = '(?<!\\bARRAY)\\[(?:[^\\]])*\\]'; public static function getPlaceholderPositions($statement, $isPositional = \true) { $match = $isPositional ? '?' : ':'; if (\strpos($statement, $match) === \false) { return array(); } $token = $isPositional ? self::POSITIONAL_TOKEN : self::NAMED_TOKEN; $paramMap = array(); foreach (self::getUnquotedStatementFragments($statement) as $fragment) { \preg_match_all("/{$token}/", $fragment[0], $matches, \PREG_OFFSET_CAPTURE); foreach ($matches[0] as $placeholder) { if ($isPositional) { $paramMap[] = $placeholder[1] + $fragment[1]; } else { $pos = $placeholder[1] + $fragment[1]; $paramMap[$pos] = \substr($placeholder[0], 1, \strlen($placeholder[0])); } } } return $paramMap; } public static function expandListParameters($query, $params, $types) { $isPositional = \is_int(\key($params)); $arrayPositions = array(); $bindIndex = -1; if ($isPositional) { \ksort($params); \ksort($types); } foreach ($types as $name => $type) { ++$bindIndex; if ($type !== \MailPoetVendor\Doctrine\DBAL\Connection::PARAM_INT_ARRAY && $type !== \MailPoetVendor\Doctrine\DBAL\Connection::PARAM_STR_ARRAY) { continue; } if ($isPositional) { $name = $bindIndex; } $arrayPositions[$name] = \false; } if (!$arrayPositions && $isPositional) { return array($query, $params, $types); } $paramPos = self::getPlaceholderPositions($query, $isPositional); if ($isPositional) { $paramOffset = 0; $queryOffset = 0; $params = \array_values($params); $types = \array_values($types); foreach ($paramPos as $needle => $needlePos) { if (!isset($arrayPositions[$needle])) { continue; } $needle += $paramOffset; $needlePos += $queryOffset; $count = \count($params[$needle]); $params = \array_merge(\array_slice($params, 0, $needle), $params[$needle], \array_slice($params, $needle + 1)); $types = \array_merge(\array_slice($types, 0, $needle), $count ? \array_fill(0, $count, $types[$needle] - \MailPoetVendor\Doctrine\DBAL\Connection::ARRAY_PARAM_OFFSET) : array(), \array_slice($types, $needle + 1)); $expandStr = $count ? \implode(", ", \array_fill(0, $count, "?")) : 'NULL'; $query = \substr($query, 0, $needlePos) . $expandStr . \substr($query, $needlePos + 1); $paramOffset += $count - 1; $queryOffset += \strlen($expandStr) - 1; } return array($query, $params, $types); } $queryOffset = 0; $typesOrd = array(); $paramsOrd = array(); foreach ($paramPos as $pos => $paramName) { $paramLen = \strlen($paramName) + 1; $value = static::extractParam($paramName, $params, \true); if (!isset($arrayPositions[$paramName]) && !isset($arrayPositions[':' . $paramName])) { $pos += $queryOffset; $queryOffset -= $paramLen - 1; $paramsOrd[] = $value; $typesOrd[] = static::extractParam($paramName, $types, \false, \PDO::PARAM_STR); $query = \substr($query, 0, $pos) . '?' . \substr($query, $pos + $paramLen); continue; } $count = \count($value); $expandStr = $count > 0 ? \implode(', ', \array_fill(0, $count, '?')) : 'NULL'; foreach ($value as $val) { $paramsOrd[] = $val; $typesOrd[] = static::extractParam($paramName, $types, \false) - \MailPoetVendor\Doctrine\DBAL\Connection::ARRAY_PARAM_OFFSET; } $pos += $queryOffset; $queryOffset += \strlen($expandStr) - $paramLen; $query = \substr($query, 0, $pos) . $expandStr . \substr($query, $pos + $paramLen); } return array($query, $paramsOrd, $typesOrd); } private static function getUnquotedStatementFragments($statement) { $literal = self::ESCAPED_SINGLE_QUOTED_TEXT . '|' . self::ESCAPED_DOUBLE_QUOTED_TEXT . '|' . self::ESCAPED_BACKTICK_QUOTED_TEXT . '|' . self::ESCAPED_BRACKET_QUOTED_TEXT; \preg_match_all("/([^'\"`\\[]+)(?:{$literal})?/s", $statement, $fragments, \PREG_OFFSET_CAPTURE); return $fragments[1]; } private static function extractParam($paramName, $paramsOrTypes, $isParam, $defaultValue = null) { if (\array_key_exists($paramName, $paramsOrTypes)) { return $paramsOrTypes[$paramName]; } if (\array_key_exists(':' . $paramName, $paramsOrTypes)) { return $paramsOrTypes[':' . $paramName]; } if (null !== $defaultValue) { return $defaultValue; } if ($isParam) { throw \MailPoetVendor\Doctrine\DBAL\SQLParserUtilsException::missingParam($paramName); } throw \MailPoetVendor\Doctrine\DBAL\SQLParserUtilsException::missingType($paramName); } } 