<?php
 namespace MailPoetVendor\Doctrine\ORM; if (!defined('ABSPATH')) exit; use Exception; use MailPoetVendor\Doctrine\Common\EventManager; use MailPoetVendor\Doctrine\DBAL\Connection; use MailPoetVendor\Doctrine\DBAL\LockMode; use MailPoetVendor\Doctrine\ORM\Query\ResultSetMapping; use MailPoetVendor\Doctrine\ORM\Proxy\ProxyFactory; use MailPoetVendor\Doctrine\ORM\Query\FilterCollection; use MailPoetVendor\Doctrine\Common\Util\ClassUtils; class EntityManager implements \MailPoetVendor\Doctrine\ORM\EntityManagerInterface { private $config; private $conn; private $metadataFactory; private $unitOfWork; private $eventManager; private $proxyFactory; private $repositoryFactory; private $expressionBuilder; private $closed = \false; private $filterCollection; private $cache; protected function __construct(\MailPoetVendor\Doctrine\DBAL\Connection $conn, \MailPoetVendor\Doctrine\ORM\Configuration $config, \MailPoetVendor\Doctrine\Common\EventManager $eventManager) { $this->conn = $conn; $this->config = $config; $this->eventManager = $eventManager; $metadataFactoryClassName = $config->getClassMetadataFactoryName(); $this->metadataFactory = new $metadataFactoryClassName(); $this->metadataFactory->setEntityManager($this); $this->metadataFactory->setCacheDriver($this->config->getMetadataCacheImpl()); $this->repositoryFactory = $config->getRepositoryFactory(); $this->unitOfWork = new \MailPoetVendor\Doctrine\ORM\UnitOfWork($this); $this->proxyFactory = new \MailPoetVendor\Doctrine\ORM\Proxy\ProxyFactory($this, $config->getProxyDir(), $config->getProxyNamespace(), $config->getAutoGenerateProxyClasses()); if ($config->isSecondLevelCacheEnabled()) { $cacheConfig = $config->getSecondLevelCacheConfiguration(); $cacheFactory = $cacheConfig->getCacheFactory(); $this->cache = $cacheFactory->createCache($this); } } public function getConnection() { return $this->conn; } public function getMetadataFactory() { return $this->metadataFactory; } public function getExpressionBuilder() { if ($this->expressionBuilder === null) { $this->expressionBuilder = new \MailPoetVendor\Doctrine\ORM\Query\Expr(); } return $this->expressionBuilder; } public function beginTransaction() { $this->conn->beginTransaction(); } public function getCache() { return $this->cache; } public function transactional($func) { if (!\is_callable($func)) { throw new \InvalidArgumentException('Expected argument of type "callable", got "' . \gettype($func) . '"'); } $this->conn->beginTransaction(); try { $return = \call_user_func($func, $this); $this->flush(); $this->conn->commit(); return $return ?: \true; } catch (\Exception $e) { $this->close(); $this->conn->rollback(); throw $e; } } public function commit() { $this->conn->commit(); } public function rollback() { $this->conn->rollback(); } public function getClassMetadata($className) { return $this->metadataFactory->getMetadataFor($className); } public function createQuery($dql = '') { $query = new \MailPoetVendor\Doctrine\ORM\Query($this); if (!empty($dql)) { $query->setDql($dql); } return $query; } public function createNamedQuery($name) { return $this->createQuery($this->config->getNamedQuery($name)); } public function createNativeQuery($sql, \MailPoetVendor\Doctrine\ORM\Query\ResultSetMapping $rsm) { $query = new \MailPoetVendor\Doctrine\ORM\NativeQuery($this); $query->setSql($sql); $query->setResultSetMapping($rsm); return $query; } public function createNamedNativeQuery($name) { list($sql, $rsm) = $this->config->getNamedNativeQuery($name); return $this->createNativeQuery($sql, $rsm); } public function createQueryBuilder() { return new \MailPoetVendor\Doctrine\ORM\QueryBuilder($this); } public function flush($entity = null) { $this->errorIfClosed(); $this->unitOfWork->commit($entity); } public function find($entityName, $id, $lockMode = null, $lockVersion = null) { $class = $this->metadataFactory->getMetadataFor(\ltrim($entityName, '\\')); if (!\is_array($id)) { if ($class->isIdentifierComposite) { throw \MailPoetVendor\Doctrine\ORM\ORMInvalidArgumentException::invalidCompositeIdentifier(); } $id = array($class->identifier[0] => $id); } foreach ($id as $i => $value) { if (\is_object($value) && $this->metadataFactory->hasMetadataFor(\MailPoetVendor\Doctrine\Common\Util\ClassUtils::getClass($value))) { $id[$i] = $this->unitOfWork->getSingleIdentifierValue($value); if ($id[$i] === null) { throw \MailPoetVendor\Doctrine\ORM\ORMInvalidArgumentException::invalidIdentifierBindingEntity(); } } } $sortedId = array(); foreach ($class->identifier as $identifier) { if (!isset($id[$identifier])) { throw \MailPoetVendor\Doctrine\ORM\ORMException::missingIdentifierField($class->name, $identifier); } $sortedId[$identifier] = $id[$identifier]; unset($id[$identifier]); } if ($id) { throw \MailPoetVendor\Doctrine\ORM\ORMException::unrecognizedIdentifierFields($class->name, \array_keys($id)); } $unitOfWork = $this->getUnitOfWork(); if (($entity = $unitOfWork->tryGetById($sortedId, $class->rootEntityName)) !== \false) { if (!$entity instanceof $class->name) { return null; } switch (\true) { case \MailPoetVendor\Doctrine\DBAL\LockMode::OPTIMISTIC === $lockMode: $this->lock($entity, $lockMode, $lockVersion); break; case \MailPoetVendor\Doctrine\DBAL\LockMode::NONE === $lockMode: case \MailPoetVendor\Doctrine\DBAL\LockMode::PESSIMISTIC_READ === $lockMode: case \MailPoetVendor\Doctrine\DBAL\LockMode::PESSIMISTIC_WRITE === $lockMode: $persister = $unitOfWork->getEntityPersister($class->name); $persister->refresh($sortedId, $entity, $lockMode); break; } return $entity; } $persister = $unitOfWork->getEntityPersister($class->name); switch (\true) { case \MailPoetVendor\Doctrine\DBAL\LockMode::OPTIMISTIC === $lockMode: if (!$class->isVersioned) { throw \MailPoetVendor\Doctrine\ORM\OptimisticLockException::notVersioned($class->name); } $entity = $persister->load($sortedId); $unitOfWork->lock($entity, $lockMode, $lockVersion); return $entity; case \MailPoetVendor\Doctrine\DBAL\LockMode::NONE === $lockMode: case \MailPoetVendor\Doctrine\DBAL\LockMode::PESSIMISTIC_READ === $lockMode: case \MailPoetVendor\Doctrine\DBAL\LockMode::PESSIMISTIC_WRITE === $lockMode: if (!$this->getConnection()->isTransactionActive()) { throw \MailPoetVendor\Doctrine\ORM\TransactionRequiredException::transactionRequired(); } return $persister->load($sortedId, null, null, array(), $lockMode); default: return $persister->loadById($sortedId); } } public function getReference($entityName, $id) { $class = $this->metadataFactory->getMetadataFor(\ltrim($entityName, '\\')); if (!\is_array($id)) { $id = array($class->identifier[0] => $id); } $sortedId = array(); foreach ($class->identifier as $identifier) { if (!isset($id[$identifier])) { throw \MailPoetVendor\Doctrine\ORM\ORMException::missingIdentifierField($class->name, $identifier); } $sortedId[$identifier] = $id[$identifier]; } if (($entity = $this->unitOfWork->tryGetById($sortedId, $class->rootEntityName)) !== \false) { return $entity instanceof $class->name ? $entity : null; } if ($class->subClasses) { return $this->find($entityName, $sortedId); } if (!\is_array($sortedId)) { $sortedId = array($class->identifier[0] => $sortedId); } $entity = $this->proxyFactory->getProxy($class->name, $sortedId); $this->unitOfWork->registerManaged($entity, $sortedId, array()); return $entity; } public function getPartialReference($entityName, $identifier) { $class = $this->metadataFactory->getMetadataFor(\ltrim($entityName, '\\')); if (($entity = $this->unitOfWork->tryGetById($identifier, $class->rootEntityName)) !== \false) { return $entity instanceof $class->name ? $entity : null; } if (!\is_array($identifier)) { $identifier = array($class->identifier[0] => $identifier); } $entity = $class->newInstance(); $class->setIdentifierValues($entity, $identifier); $this->unitOfWork->registerManaged($entity, $identifier, array()); $this->unitOfWork->markReadOnly($entity); return $entity; } public function clear($entityName = null) { $this->unitOfWork->clear($entityName); } public function close() { $this->clear(); $this->closed = \true; } public function persist($entity) { if (!\is_object($entity)) { throw \MailPoetVendor\Doctrine\ORM\ORMInvalidArgumentException::invalidObject('EntityManager#persist()', $entity); } $this->errorIfClosed(); $this->unitOfWork->persist($entity); } public function remove($entity) { if (!\is_object($entity)) { throw \MailPoetVendor\Doctrine\ORM\ORMInvalidArgumentException::invalidObject('EntityManager#remove()', $entity); } $this->errorIfClosed(); $this->unitOfWork->remove($entity); } public function refresh($entity) { if (!\is_object($entity)) { throw \MailPoetVendor\Doctrine\ORM\ORMInvalidArgumentException::invalidObject('EntityManager#refresh()', $entity); } $this->errorIfClosed(); $this->unitOfWork->refresh($entity); } public function detach($entity) { if (!\is_object($entity)) { throw \MailPoetVendor\Doctrine\ORM\ORMInvalidArgumentException::invalidObject('EntityManager#detach()', $entity); } $this->unitOfWork->detach($entity); } public function merge($entity) { if (!\is_object($entity)) { throw \MailPoetVendor\Doctrine\ORM\ORMInvalidArgumentException::invalidObject('EntityManager#merge()', $entity); } $this->errorIfClosed(); return $this->unitOfWork->merge($entity); } public function copy($entity, $deep = \false) { throw new \BadMethodCallException("Not implemented."); } public function lock($entity, $lockMode, $lockVersion = null) { $this->unitOfWork->lock($entity, $lockMode, $lockVersion); } public function getRepository($entityName) { return $this->repositoryFactory->getRepository($this, $entityName); } public function contains($entity) { return $this->unitOfWork->isScheduledForInsert($entity) || $this->unitOfWork->isInIdentityMap($entity) && !$this->unitOfWork->isScheduledForDelete($entity); } public function getEventManager() { return $this->eventManager; } public function getConfiguration() { return $this->config; } private function errorIfClosed() { if ($this->closed) { throw \MailPoetVendor\Doctrine\ORM\ORMException::entityManagerClosed(); } } public function isOpen() { return !$this->closed; } public function getUnitOfWork() { return $this->unitOfWork; } public function getHydrator($hydrationMode) { return $this->newHydrator($hydrationMode); } public function newHydrator($hydrationMode) { switch ($hydrationMode) { case \MailPoetVendor\Doctrine\ORM\Query::HYDRATE_OBJECT: return new \MailPoetVendor\Doctrine\ORM\Internal\Hydration\ObjectHydrator($this); case \MailPoetVendor\Doctrine\ORM\Query::HYDRATE_ARRAY: return new \MailPoetVendor\Doctrine\ORM\Internal\Hydration\ArrayHydrator($this); case \MailPoetVendor\Doctrine\ORM\Query::HYDRATE_SCALAR: return new \MailPoetVendor\Doctrine\ORM\Internal\Hydration\ScalarHydrator($this); case \MailPoetVendor\Doctrine\ORM\Query::HYDRATE_SINGLE_SCALAR: return new \MailPoetVendor\Doctrine\ORM\Internal\Hydration\SingleScalarHydrator($this); case \MailPoetVendor\Doctrine\ORM\Query::HYDRATE_SIMPLEOBJECT: return new \MailPoetVendor\Doctrine\ORM\Internal\Hydration\SimpleObjectHydrator($this); default: if (($class = $this->config->getCustomHydrationMode($hydrationMode)) !== null) { return new $class($this); } } throw \MailPoetVendor\Doctrine\ORM\ORMException::invalidHydrationMode($hydrationMode); } public function getProxyFactory() { return $this->proxyFactory; } public function initializeObject($obj) { $this->unitOfWork->initializeObject($obj); } public static function create($conn, \MailPoetVendor\Doctrine\ORM\Configuration $config, \MailPoetVendor\Doctrine\Common\EventManager $eventManager = null) { if (!$config->getMetadataDriverImpl()) { throw \MailPoetVendor\Doctrine\ORM\ORMException::missingMappingDriverImpl(); } switch (\true) { case \is_array($conn): $conn = \MailPoetVendor\Doctrine\DBAL\DriverManager::getConnection($conn, $config, $eventManager ?: new \MailPoetVendor\Doctrine\Common\EventManager()); break; case $conn instanceof \MailPoetVendor\Doctrine\DBAL\Connection: if ($eventManager !== null && $conn->getEventManager() !== $eventManager) { throw \MailPoetVendor\Doctrine\ORM\ORMException::mismatchedEventManager(); } break; default: throw new \InvalidArgumentException("Invalid argument: " . $conn); } return new \MailPoetVendor\Doctrine\ORM\EntityManager($conn, $config, $conn->getEventManager()); } public function getFilters() { if (null === $this->filterCollection) { $this->filterCollection = new \MailPoetVendor\Doctrine\ORM\Query\FilterCollection($this); } return $this->filterCollection; } public function isFiltersStateClean() { return null === $this->filterCollection || $this->filterCollection->isClean(); } public function hasFilters() { return null !== $this->filterCollection; } } 