<?php
 namespace MailPoetVendor\Doctrine\ORM\Internal\Hydration; if (!defined('ABSPATH')) exit; use MailPoetVendor\Doctrine\DBAL\Types\Type; use MailPoetVendor\Doctrine\ORM\EntityManagerInterface; use MailPoetVendor\Doctrine\ORM\Events; use MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata; use PDO; abstract class AbstractHydrator { protected $_rsm; protected $_em; protected $_platform; protected $_uow; protected $_metadataCache = array(); protected $_cache = array(); protected $_stmt; protected $_hints; public function __construct(\MailPoetVendor\Doctrine\ORM\EntityManagerInterface $em) { $this->_em = $em; $this->_platform = $em->getConnection()->getDatabasePlatform(); $this->_uow = $em->getUnitOfWork(); } public function iterate($stmt, $resultSetMapping, array $hints = array()) { $this->_stmt = $stmt; $this->_rsm = $resultSetMapping; $this->_hints = $hints; $evm = $this->_em->getEventManager(); $evm->addEventListener(array(\MailPoetVendor\Doctrine\ORM\Events::onClear), $this); $this->prepare(); return new \MailPoetVendor\Doctrine\ORM\Internal\Hydration\IterableResult($this); } public function hydrateAll($stmt, $resultSetMapping, array $hints = array()) { $this->_stmt = $stmt; $this->_rsm = $resultSetMapping; $this->_hints = $hints; $evm = $this->_em->getEventManager(); $evm->addEventListener(array(\MailPoetVendor\Doctrine\ORM\Events::onClear), $this); $this->prepare(); $result = $this->hydrateAllData(); $this->cleanup(); return $result; } public function hydrateRow() { $row = $this->_stmt->fetch(\PDO::FETCH_ASSOC); if (!$row) { $this->cleanup(); return \false; } $result = array(); $this->hydrateRowData($row, $result); return $result; } public function onClear($eventArgs) { } protected function prepare() { } protected function cleanup() { $this->_stmt->closeCursor(); $this->_stmt = null; $this->_rsm = null; $this->_cache = array(); $this->_metadataCache = array(); $evm = $this->_em->getEventManager(); $evm->removeEventListener(array(\MailPoetVendor\Doctrine\ORM\Events::onClear), $this); } protected function hydrateRowData(array $data, array &$result) { throw new \MailPoetVendor\Doctrine\ORM\Internal\Hydration\HydrationException("hydrateRowData() not implemented by this hydrator."); } protected abstract function hydrateAllData(); protected function gatherRowData(array $data, array &$id, array &$nonemptyComponents) { $rowData = array('data' => array()); foreach ($data as $key => $value) { if (($cacheKeyInfo = $this->hydrateColumnInfo($key)) === null) { continue; } $fieldName = $cacheKeyInfo['fieldName']; switch (\true) { case isset($cacheKeyInfo['isNewObjectParameter']): $argIndex = $cacheKeyInfo['argIndex']; $objIndex = $cacheKeyInfo['objIndex']; $type = $cacheKeyInfo['type']; $value = $type->convertToPHPValue($value, $this->_platform); $rowData['newObjects'][$objIndex]['class'] = $cacheKeyInfo['class']; $rowData['newObjects'][$objIndex]['args'][$argIndex] = $value; break; case isset($cacheKeyInfo['isScalar']): $type = $cacheKeyInfo['type']; $value = $type->convertToPHPValue($value, $this->_platform); $rowData['scalars'][$fieldName] = $value; break; default: $dqlAlias = $cacheKeyInfo['dqlAlias']; $type = $cacheKeyInfo['type']; if (isset($rowData['data'][$dqlAlias][$fieldName])) { break; } $rowData['data'][$dqlAlias][$fieldName] = $type ? $type->convertToPHPValue($value, $this->_platform) : $value; if ($cacheKeyInfo['isIdentifier'] && $value !== null) { $id[$dqlAlias] .= '|' . $value; $nonemptyComponents[$dqlAlias] = \true; } break; } } return $rowData; } protected function gatherScalarRowData(&$data) { $rowData = array(); foreach ($data as $key => $value) { if (($cacheKeyInfo = $this->hydrateColumnInfo($key)) === null) { continue; } $fieldName = $cacheKeyInfo['fieldName']; if (!isset($cacheKeyInfo['isScalar'])) { $dqlAlias = $cacheKeyInfo['dqlAlias']; $type = $cacheKeyInfo['type']; $fieldName = $dqlAlias . '_' . $fieldName; $value = $type ? $type->convertToPHPValue($value, $this->_platform) : $value; } $rowData[$fieldName] = $value; } return $rowData; } protected function hydrateColumnInfo($key) { if (isset($this->_cache[$key])) { return $this->_cache[$key]; } switch (\true) { case isset($this->_rsm->fieldMappings[$key]): $classMetadata = $this->getClassMetadata($this->_rsm->declaringClasses[$key]); $fieldName = $this->_rsm->fieldMappings[$key]; $fieldMapping = $classMetadata->fieldMappings[$fieldName]; return $this->_cache[$key] = array('isIdentifier' => \in_array($fieldName, $classMetadata->identifier), 'fieldName' => $fieldName, 'type' => \MailPoetVendor\Doctrine\DBAL\Types\Type::getType($fieldMapping['type']), 'dqlAlias' => $this->_rsm->columnOwnerMap[$key]); case isset($this->_rsm->newObjectMappings[$key]): $mapping = $this->_rsm->newObjectMappings[$key]; return $this->_cache[$key] = array('isScalar' => \true, 'isNewObjectParameter' => \true, 'fieldName' => $this->_rsm->scalarMappings[$key], 'type' => \MailPoetVendor\Doctrine\DBAL\Types\Type::getType($this->_rsm->typeMappings[$key]), 'argIndex' => $mapping['argIndex'], 'objIndex' => $mapping['objIndex'], 'class' => new \ReflectionClass($mapping['className'])); case isset($this->_rsm->scalarMappings[$key]): return $this->_cache[$key] = array('isScalar' => \true, 'fieldName' => $this->_rsm->scalarMappings[$key], 'type' => \MailPoetVendor\Doctrine\DBAL\Types\Type::getType($this->_rsm->typeMappings[$key])); case isset($this->_rsm->metaMappings[$key]): $fieldName = $this->_rsm->metaMappings[$key]; $dqlAlias = $this->_rsm->columnOwnerMap[$key]; $classMetadata = $this->getClassMetadata($this->_rsm->aliasMap[$dqlAlias]); $type = isset($this->_rsm->typeMappings[$key]) ? \MailPoetVendor\Doctrine\DBAL\Types\Type::getType($this->_rsm->typeMappings[$key]) : null; return $this->_cache[$key] = array('isIdentifier' => isset($this->_rsm->isIdentifierColumn[$dqlAlias][$key]), 'isMetaColumn' => \true, 'fieldName' => $fieldName, 'type' => $type, 'dqlAlias' => $dqlAlias); } return null; } protected function getClassMetadata($className) { if (!isset($this->_metadataCache[$className])) { $this->_metadataCache[$className] = $this->_em->getClassMetadata($className); } return $this->_metadataCache[$className]; } protected function registerManaged(\MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata $class, $entity, array $data) { if ($class->isIdentifierComposite) { $id = array(); foreach ($class->identifier as $fieldName) { $id[$fieldName] = isset($class->associationMappings[$fieldName]) ? $data[$class->associationMappings[$fieldName]['joinColumns'][0]['name']] : $data[$fieldName]; } } else { $fieldName = $class->identifier[0]; $id = array($fieldName => isset($class->associationMappings[$fieldName]) ? $data[$class->associationMappings[$fieldName]['joinColumns'][0]['name']] : $data[$fieldName]); } $this->_em->getUnitOfWork()->registerManaged($entity, $id, $data); } } 