<?php
 namespace MailPoetVendor\Doctrine\ORM\Mapping; if (!defined('ABSPATH')) exit; use MailPoetVendor\Doctrine\Common\Persistence\Mapping\AbstractClassMetadataFactory; use MailPoetVendor\Doctrine\Common\Persistence\Mapping\ClassMetadata as ClassMetadataInterface; use MailPoetVendor\Doctrine\Common\Persistence\Mapping\ReflectionService; use MailPoetVendor\Doctrine\DBAL\Platforms; use MailPoetVendor\Doctrine\ORM\EntityManagerInterface; use MailPoetVendor\Doctrine\ORM\Event\LoadClassMetadataEventArgs; use MailPoetVendor\Doctrine\ORM\Event\OnClassMetadataNotFoundEventArgs; use MailPoetVendor\Doctrine\ORM\Events; use MailPoetVendor\Doctrine\ORM\Id\BigIntegerIdentityGenerator; use MailPoetVendor\Doctrine\ORM\Id\IdentityGenerator; use MailPoetVendor\Doctrine\ORM\ORMException; use ReflectionException; class ClassMetadataFactory extends \MailPoetVendor\Doctrine\Common\Persistence\Mapping\AbstractClassMetadataFactory { private $em; private $targetPlatform; private $driver; private $evm; private $embeddablesActiveNesting = array(); protected function loadMetadata($name) { $loaded = parent::loadMetadata($name); \array_map([$this, 'resolveDiscriminatorValue'], \array_map([$this, 'getMetadataFor'], $loaded)); return $loaded; } public function setEntityManager(\MailPoetVendor\Doctrine\ORM\EntityManagerInterface $em) { $this->em = $em; } protected function initialize() { $this->driver = $this->em->getConfiguration()->getMetadataDriverImpl(); $this->evm = $this->em->getEventManager(); $this->initialized = \true; } protected function onNotFoundMetadata($className) { if (!$this->evm->hasListeners(\MailPoetVendor\Doctrine\ORM\Events::onClassMetadataNotFound)) { return; } $eventArgs = new \MailPoetVendor\Doctrine\ORM\Event\OnClassMetadataNotFoundEventArgs($className, $this->em); $this->evm->dispatchEvent(\MailPoetVendor\Doctrine\ORM\Events::onClassMetadataNotFound, $eventArgs); return $eventArgs->getFoundMetadata(); } protected function doLoadMetadata($class, $parent, $rootEntityFound, array $nonSuperclassParents) { if ($parent) { $class->setInheritanceType($parent->inheritanceType); $class->setDiscriminatorColumn($parent->discriminatorColumn); $class->setIdGeneratorType($parent->generatorType); $this->addInheritedFields($class, $parent); $this->addInheritedRelations($class, $parent); $this->addInheritedEmbeddedClasses($class, $parent); $class->setIdentifier($parent->identifier); $class->setVersioned($parent->isVersioned); $class->setVersionField($parent->versionField); $class->setDiscriminatorMap($parent->discriminatorMap); $class->setLifecycleCallbacks($parent->lifecycleCallbacks); $class->setChangeTrackingPolicy($parent->changeTrackingPolicy); if (!empty($parent->customGeneratorDefinition)) { $class->setCustomGeneratorDefinition($parent->customGeneratorDefinition); } if ($parent->isMappedSuperclass) { $class->setCustomRepositoryClass($parent->customRepositoryClassName); } } try { $this->driver->loadMetadataForClass($class->getName(), $class); } catch (\ReflectionException $e) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::reflectionFailure($class->getName(), $e); } if ($parent && $rootEntityFound) { if ($parent->isIdGeneratorSequence()) { $class->setSequenceGeneratorDefinition($parent->sequenceGeneratorDefinition); } else { if ($parent->isIdGeneratorTable()) { $class->tableGeneratorDefinition = $parent->tableGeneratorDefinition; } } if ($parent->generatorType) { $class->setIdGeneratorType($parent->generatorType); } if ($parent->idGenerator) { $class->setIdGenerator($parent->idGenerator); } } else { $this->completeIdGeneratorMapping($class); } if (!$class->isMappedSuperclass) { foreach ($class->embeddedClasses as $property => $embeddableClass) { if (isset($embeddableClass['inherited'])) { continue; } if (!(isset($embeddableClass['class']) && $embeddableClass['class'])) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::missingEmbeddedClass($property); } if (isset($this->embeddablesActiveNesting[$embeddableClass['class']])) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::infiniteEmbeddableNesting($class->name, $property); } $this->embeddablesActiveNesting[$class->name] = \true; $embeddableMetadata = $this->getMetadataFor($embeddableClass['class']); if ($embeddableMetadata->isEmbeddedClass) { $this->addNestedEmbeddedClasses($embeddableMetadata, $class, $property); } $class->inlineEmbeddable($property, $embeddableMetadata); unset($this->embeddablesActiveNesting[$class->name]); } } if ($parent) { if ($parent->isInheritanceTypeSingleTable()) { $class->setPrimaryTable($parent->table); } if ($parent) { $this->addInheritedIndexes($class, $parent); } if ($parent->cache) { $class->cache = $parent->cache; } if ($parent->containsForeignIdentifier) { $class->containsForeignIdentifier = \true; } if (!empty($parent->namedQueries)) { $this->addInheritedNamedQueries($class, $parent); } if (!empty($parent->namedNativeQueries)) { $this->addInheritedNamedNativeQueries($class, $parent); } if (!empty($parent->sqlResultSetMappings)) { $this->addInheritedSqlResultSetMappings($class, $parent); } if (!empty($parent->entityListeners) && empty($class->entityListeners)) { $class->entityListeners = $parent->entityListeners; } } $class->setParentClasses($nonSuperclassParents); if ($class->isRootEntity() && !$class->isInheritanceTypeNone() && !$class->discriminatorMap) { $this->addDefaultDiscriminatorMap($class); } if ($this->evm->hasListeners(\MailPoetVendor\Doctrine\ORM\Events::loadClassMetadata)) { $eventArgs = new \MailPoetVendor\Doctrine\ORM\Event\LoadClassMetadataEventArgs($class, $this->em); $this->evm->dispatchEvent(\MailPoetVendor\Doctrine\ORM\Events::loadClassMetadata, $eventArgs); } $this->validateRuntimeMetadata($class, $parent); } protected function validateRuntimeMetadata($class, $parent) { if (!$class->reflClass) { return; } $class->validateIdentifier(); $class->validateAssociations(); $class->validateLifecycleCallbacks($this->getReflectionService()); if (!$class->isMappedSuperclass && !$class->isInheritanceTypeNone()) { if (!$parent) { if (\count($class->discriminatorMap) == 0) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::missingDiscriminatorMap($class->name); } if (!$class->discriminatorColumn) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::missingDiscriminatorColumn($class->name); } } } else { if ($class->isMappedSuperclass && $class->name == $class->rootEntityName && (\count($class->discriminatorMap) || $class->discriminatorColumn)) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::noInheritanceOnMappedSuperClass($class->name); } } } protected function newClassMetadataInstance($className) { return new \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata($className, $this->em->getConfiguration()->getNamingStrategy()); } private function resolveDiscriminatorValue(\MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata $metadata) { if ($metadata->discriminatorValue || !$metadata->discriminatorMap || $metadata->isMappedSuperclass || !$metadata->reflClass || $metadata->reflClass->isAbstract()) { return; } foreach ($metadata->discriminatorMap as $discriminatorValue => $discriminatorClass) { if ($discriminatorClass === $metadata->name) { $metadata->discriminatorValue = $discriminatorValue; return; } } foreach ($metadata->discriminatorMap as $discriminatorValue => $discriminatorClass) { if ($metadata->name === $this->getMetadataFor($discriminatorClass)->getName()) { $metadata->discriminatorValue = $discriminatorValue; return; } } throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::mappedClassNotPartOfDiscriminatorMap($metadata->name, $metadata->rootEntityName); } private function addDefaultDiscriminatorMap(\MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata $class) { $allClasses = $this->driver->getAllClassNames(); $fqcn = $class->getName(); $map = array($this->getShortName($class->name) => $fqcn); $duplicates = array(); foreach ($allClasses as $subClassCandidate) { if (\is_subclass_of($subClassCandidate, $fqcn)) { $shortName = $this->getShortName($subClassCandidate); if (isset($map[$shortName])) { $duplicates[] = $shortName; } $map[$shortName] = $subClassCandidate; } } if ($duplicates) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::duplicateDiscriminatorEntry($class->name, $duplicates, $map); } $class->setDiscriminatorMap($map); } private function getShortName($className) { if (\strpos($className, "\\") === \false) { return \strtolower($className); } $parts = \explode("\\", $className); return \strtolower(\end($parts)); } private function addInheritedFields(\MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata $subClass, \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata $parentClass) { foreach ($parentClass->fieldMappings as $mapping) { if (!isset($mapping['inherited']) && !$parentClass->isMappedSuperclass) { $mapping['inherited'] = $parentClass->name; } if (!isset($mapping['declared'])) { $mapping['declared'] = $parentClass->name; } $subClass->addInheritedFieldMapping($mapping); } foreach ($parentClass->reflFields as $name => $field) { $subClass->reflFields[$name] = $field; } } private function addInheritedRelations(\MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata $subClass, \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata $parentClass) { foreach ($parentClass->associationMappings as $field => $mapping) { if ($parentClass->isMappedSuperclass) { if ($mapping['type'] & \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata::TO_MANY && !$mapping['isOwningSide']) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::illegalToManyAssociationOnMappedSuperclass($parentClass->name, $field); } $mapping['sourceEntity'] = $subClass->name; } if (!isset($mapping['inherited']) && !$parentClass->isMappedSuperclass) { $mapping['inherited'] = $parentClass->name; } if (!isset($mapping['declared'])) { $mapping['declared'] = $parentClass->name; } $subClass->addInheritedAssociationMapping($mapping); } } private function addInheritedEmbeddedClasses(\MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata $subClass, \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata $parentClass) { foreach ($parentClass->embeddedClasses as $field => $embeddedClass) { if (!isset($embeddedClass['inherited']) && !$parentClass->isMappedSuperclass) { $embeddedClass['inherited'] = $parentClass->name; } if (!isset($embeddedClass['declared'])) { $embeddedClass['declared'] = $parentClass->name; } $subClass->embeddedClasses[$field] = $embeddedClass; } } private function addNestedEmbeddedClasses(\MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata $subClass, \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata $parentClass, $prefix) { foreach ($subClass->embeddedClasses as $property => $embeddableClass) { if (isset($embeddableClass['inherited'])) { continue; } $embeddableMetadata = $this->getMetadataFor($embeddableClass['class']); $parentClass->mapEmbedded(array('fieldName' => $prefix . '.' . $property, 'class' => $embeddableMetadata->name, 'columnPrefix' => $embeddableClass['columnPrefix'], 'declaredField' => $embeddableClass['declaredField'] ? $prefix . '.' . $embeddableClass['declaredField'] : $prefix, 'originalField' => $embeddableClass['originalField'] ?: $property)); } } private function addInheritedIndexes(\MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata $subClass, \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata $parentClass) { if (!$parentClass->isMappedSuperclass) { return; } foreach (array('uniqueConstraints', 'indexes') as $indexType) { if (isset($parentClass->table[$indexType])) { foreach ($parentClass->table[$indexType] as $indexName => $index) { if (isset($subClass->table[$indexType][$indexName])) { continue; } $subClass->table[$indexType][$indexName] = $index; } } } } private function addInheritedNamedQueries(\MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata $subClass, \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata $parentClass) { foreach ($parentClass->namedQueries as $name => $query) { if (!isset($subClass->namedQueries[$name])) { $subClass->addNamedQuery(array('name' => $query['name'], 'query' => $query['query'])); } } } private function addInheritedNamedNativeQueries(\MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata $subClass, \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata $parentClass) { foreach ($parentClass->namedNativeQueries as $name => $query) { if (!isset($subClass->namedNativeQueries[$name])) { $subClass->addNamedNativeQuery(array('name' => $query['name'], 'query' => $query['query'], 'isSelfClass' => $query['isSelfClass'], 'resultSetMapping' => $query['resultSetMapping'], 'resultClass' => $query['isSelfClass'] ? $subClass->name : $query['resultClass'])); } } } private function addInheritedSqlResultSetMappings(\MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata $subClass, \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata $parentClass) { foreach ($parentClass->sqlResultSetMappings as $name => $mapping) { if (!isset($subClass->sqlResultSetMappings[$name])) { $entities = array(); foreach ($mapping['entities'] as $entity) { $entities[] = array('fields' => $entity['fields'], 'isSelfClass' => $entity['isSelfClass'], 'discriminatorColumn' => $entity['discriminatorColumn'], 'entityClass' => $entity['isSelfClass'] ? $subClass->name : $entity['entityClass']); } $subClass->addSqlResultSetMapping(array('name' => $mapping['name'], 'columns' => $mapping['columns'], 'entities' => $entities)); } } } private function completeIdGeneratorMapping(\MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadataInfo $class) { $idGenType = $class->generatorType; if ($idGenType == \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata::GENERATOR_TYPE_AUTO) { if ($this->getTargetPlatform()->prefersSequences()) { $class->setIdGeneratorType(\MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata::GENERATOR_TYPE_SEQUENCE); } else { if ($this->getTargetPlatform()->prefersIdentityColumns()) { $class->setIdGeneratorType(\MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata::GENERATOR_TYPE_IDENTITY); } else { $class->setIdGeneratorType(\MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata::GENERATOR_TYPE_TABLE); } } } switch ($class->generatorType) { case \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata::GENERATOR_TYPE_IDENTITY: $sequenceName = null; $fieldName = $class->identifier ? $class->getSingleIdentifierFieldName() : null; if ($this->getTargetPlatform()->usesSequenceEmulatedIdentityColumns()) { $columnName = $class->getSingleIdentifierColumnName(); $quoted = isset($class->fieldMappings[$fieldName]['quoted']) || isset($class->table['quoted']); $sequencePrefix = $class->getSequencePrefix($this->getTargetPlatform()); $sequenceName = $this->getTargetPlatform()->getIdentitySequenceName($sequencePrefix, $columnName); $definition = array('sequenceName' => $this->getTargetPlatform()->fixSchemaElementName($sequenceName)); if ($quoted) { $definition['quoted'] = \true; } $sequenceName = $this->em->getConfiguration()->getQuoteStrategy()->getSequenceName($definition, $class, $this->getTargetPlatform()); } $generator = $fieldName && $class->fieldMappings[$fieldName]['type'] === 'bigint' ? new \MailPoetVendor\Doctrine\ORM\Id\BigIntegerIdentityGenerator($sequenceName) : new \MailPoetVendor\Doctrine\ORM\Id\IdentityGenerator($sequenceName); $class->setIdGenerator($generator); break; case \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata::GENERATOR_TYPE_SEQUENCE: $definition = $class->sequenceGeneratorDefinition; if (!$definition) { $fieldName = $class->getSingleIdentifierFieldName(); $sequenceName = $class->getSequenceName($this->getTargetPlatform()); $quoted = isset($class->fieldMappings[$fieldName]['quoted']) || isset($class->table['quoted']); $definition = array('sequenceName' => $this->getTargetPlatform()->fixSchemaElementName($sequenceName), 'allocationSize' => 1, 'initialValue' => 1); if ($quoted) { $definition['quoted'] = \true; } $class->setSequenceGeneratorDefinition($definition); } $sequenceGenerator = new \MailPoetVendor\Doctrine\ORM\Id\SequenceGenerator($this->em->getConfiguration()->getQuoteStrategy()->getSequenceName($definition, $class, $this->getTargetPlatform()), $definition['allocationSize']); $class->setIdGenerator($sequenceGenerator); break; case \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata::GENERATOR_TYPE_NONE: $class->setIdGenerator(new \MailPoetVendor\Doctrine\ORM\Id\AssignedGenerator()); break; case \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata::GENERATOR_TYPE_UUID: $class->setIdGenerator(new \MailPoetVendor\Doctrine\ORM\Id\UuidGenerator()); break; case \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata::GENERATOR_TYPE_TABLE: throw new \MailPoetVendor\Doctrine\ORM\ORMException("TableGenerator not yet implemented."); break; case \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata::GENERATOR_TYPE_CUSTOM: $definition = $class->customGeneratorDefinition; if (!\class_exists($definition['class'])) { throw new \MailPoetVendor\Doctrine\ORM\ORMException("Can't instantiate custom generator : " . $definition['class']); } $class->setIdGenerator(new $definition['class']()); break; default: throw new \MailPoetVendor\Doctrine\ORM\ORMException("Unknown generator type: " . $class->generatorType); } } protected function wakeupReflection(\MailPoetVendor\Doctrine\Common\Persistence\Mapping\ClassMetadata $class, \MailPoetVendor\Doctrine\Common\Persistence\Mapping\ReflectionService $reflService) { $class->wakeupReflection($reflService); } protected function initializeReflection(\MailPoetVendor\Doctrine\Common\Persistence\Mapping\ClassMetadata $class, \MailPoetVendor\Doctrine\Common\Persistence\Mapping\ReflectionService $reflService) { $class->initializeReflection($reflService); } protected function getFqcnFromAlias($namespaceAlias, $simpleClassName) { return $this->em->getConfiguration()->getEntityNamespace($namespaceAlias) . '\\' . $simpleClassName; } protected function getDriver() { return $this->driver; } protected function isEntity(\MailPoetVendor\Doctrine\Common\Persistence\Mapping\ClassMetadata $class) { return isset($class->isMappedSuperclass) && $class->isMappedSuperclass === \false; } private function getTargetPlatform() { if (!$this->targetPlatform) { $this->targetPlatform = $this->em->getConnection()->getDatabasePlatform(); } return $this->targetPlatform; } } 