<?php
 namespace MailPoetVendor\Doctrine\ORM\Mapping; if (!defined('ABSPATH')) exit; use BadMethodCallException; use MailPoetVendor\Doctrine\Instantiator\Instantiator; use InvalidArgumentException; use RuntimeException; use MailPoetVendor\Doctrine\DBAL\Types\Type; use MailPoetVendor\Doctrine\DBAL\Platforms\AbstractPlatform; use ReflectionClass; use MailPoetVendor\Doctrine\Common\Persistence\Mapping\ClassMetadata; use MailPoetVendor\Doctrine\Common\ClassLoader; class ClassMetadataInfo implements \MailPoetVendor\Doctrine\Common\Persistence\Mapping\ClassMetadata { const INHERITANCE_TYPE_NONE = 1; const INHERITANCE_TYPE_JOINED = 2; const INHERITANCE_TYPE_SINGLE_TABLE = 3; const INHERITANCE_TYPE_TABLE_PER_CLASS = 4; const GENERATOR_TYPE_AUTO = 1; const GENERATOR_TYPE_SEQUENCE = 2; const GENERATOR_TYPE_TABLE = 3; const GENERATOR_TYPE_IDENTITY = 4; const GENERATOR_TYPE_NONE = 5; const GENERATOR_TYPE_UUID = 6; const GENERATOR_TYPE_CUSTOM = 7; const CHANGETRACKING_DEFERRED_IMPLICIT = 1; const CHANGETRACKING_DEFERRED_EXPLICIT = 2; const CHANGETRACKING_NOTIFY = 3; const FETCH_LAZY = 2; const FETCH_EAGER = 3; const FETCH_EXTRA_LAZY = 4; const ONE_TO_ONE = 1; const MANY_TO_ONE = 2; const ONE_TO_MANY = 4; const MANY_TO_MANY = 8; const TO_ONE = 3; const TO_MANY = 12; const CACHE_USAGE_READ_ONLY = 1; const CACHE_USAGE_NONSTRICT_READ_WRITE = 2; const CACHE_USAGE_READ_WRITE = 3; public $name; public $namespace; public $rootEntityName; public $customGeneratorDefinition; public $customRepositoryClassName; public $isMappedSuperclass = \false; public $isEmbeddedClass = \false; public $parentClasses = array(); public $subClasses = array(); public $embeddedClasses = array(); public $namedQueries = array(); public $namedNativeQueries = array(); public $sqlResultSetMappings = array(); public $identifier = array(); public $inheritanceType = self::INHERITANCE_TYPE_NONE; public $generatorType = self::GENERATOR_TYPE_NONE; public $fieldMappings = array(); public $fieldNames = array(); public $columnNames = array(); public $discriminatorValue; public $discriminatorMap = array(); public $discriminatorColumn; public $table; public $lifecycleCallbacks = array(); public $entityListeners = array(); public $associationMappings = array(); public $isIdentifierComposite = \false; public $containsForeignIdentifier = \false; public $idGenerator; public $sequenceGeneratorDefinition; public $tableGeneratorDefinition; public $changeTrackingPolicy = self::CHANGETRACKING_DEFERRED_IMPLICIT; public $isVersioned; public $versionField; public $cache = null; public $reflClass; public $isReadOnly = \false; protected $namingStrategy; public $reflFields = array(); private $instantiator; public function __construct($entityName, \MailPoetVendor\Doctrine\ORM\Mapping\NamingStrategy $namingStrategy = null) { $this->name = $entityName; $this->rootEntityName = $entityName; $this->namingStrategy = $namingStrategy ?: new \MailPoetVendor\Doctrine\ORM\Mapping\DefaultNamingStrategy(); $this->instantiator = new \MailPoetVendor\Doctrine\Instantiator\Instantiator(); } public function getReflectionProperties() { return $this->reflFields; } public function getReflectionProperty($name) { return $this->reflFields[$name]; } public function getSingleIdReflectionProperty() { if ($this->isIdentifierComposite) { throw new \BadMethodCallException("Class " . $this->name . " has a composite identifier."); } return $this->reflFields[$this->identifier[0]]; } public function getIdentifierValues($entity) { if ($this->isIdentifierComposite) { $id = array(); foreach ($this->identifier as $idField) { $value = $this->reflFields[$idField]->getValue($entity); if ($value !== null) { $id[$idField] = $value; } } return $id; } $id = $this->identifier[0]; $value = $this->reflFields[$id]->getValue($entity); if (null === $value) { return array(); } return array($id => $value); } public function setIdentifierValues($entity, array $id) { foreach ($id as $idField => $idValue) { $this->reflFields[$idField]->setValue($entity, $idValue); } } public function setFieldValue($entity, $field, $value) { $this->reflFields[$field]->setValue($entity, $value); } public function getFieldValue($entity, $field) { return $this->reflFields[$field]->getValue($entity); } public function __toString() { return __CLASS__ . '@' . \spl_object_hash($this); } public function __sleep() { $serialized = array( 'associationMappings', 'columnNames', 'fieldMappings', 'fieldNames', 'embeddedClasses', 'identifier', 'isIdentifierComposite', 'name', 'namespace', 'table', 'rootEntityName', 'idGenerator', ); if ($this->changeTrackingPolicy != self::CHANGETRACKING_DEFERRED_IMPLICIT) { $serialized[] = 'changeTrackingPolicy'; } if ($this->customRepositoryClassName) { $serialized[] = 'customRepositoryClassName'; } if ($this->inheritanceType != self::INHERITANCE_TYPE_NONE) { $serialized[] = 'inheritanceType'; $serialized[] = 'discriminatorColumn'; $serialized[] = 'discriminatorValue'; $serialized[] = 'discriminatorMap'; $serialized[] = 'parentClasses'; $serialized[] = 'subClasses'; } if ($this->generatorType != self::GENERATOR_TYPE_NONE) { $serialized[] = 'generatorType'; if ($this->generatorType == self::GENERATOR_TYPE_SEQUENCE) { $serialized[] = 'sequenceGeneratorDefinition'; } } if ($this->isMappedSuperclass) { $serialized[] = 'isMappedSuperclass'; } if ($this->isEmbeddedClass) { $serialized[] = 'isEmbeddedClass'; } if ($this->containsForeignIdentifier) { $serialized[] = 'containsForeignIdentifier'; } if ($this->isVersioned) { $serialized[] = 'isVersioned'; $serialized[] = 'versionField'; } if ($this->lifecycleCallbacks) { $serialized[] = 'lifecycleCallbacks'; } if ($this->entityListeners) { $serialized[] = 'entityListeners'; } if ($this->namedQueries) { $serialized[] = 'namedQueries'; } if ($this->namedNativeQueries) { $serialized[] = 'namedNativeQueries'; } if ($this->sqlResultSetMappings) { $serialized[] = 'sqlResultSetMappings'; } if ($this->isReadOnly) { $serialized[] = 'isReadOnly'; } if ($this->customGeneratorDefinition) { $serialized[] = "customGeneratorDefinition"; } if ($this->cache) { $serialized[] = 'cache'; } return $serialized; } public function newInstance() { return $this->instantiator->instantiate($this->name); } public function wakeupReflection($reflService) { $this->reflClass = $reflService->getClass($this->name); $this->instantiator = $this->instantiator ?: new \MailPoetVendor\Doctrine\Instantiator\Instantiator(); $parentReflFields = array(); foreach ($this->embeddedClasses as $property => $embeddedClass) { if (isset($embeddedClass['declaredField'])) { $parentReflFields[$property] = new \MailPoetVendor\Doctrine\ORM\Mapping\ReflectionEmbeddedProperty($parentReflFields[$embeddedClass['declaredField']], $reflService->getAccessibleProperty($this->embeddedClasses[$embeddedClass['declaredField']]['class'], $embeddedClass['originalField']), $this->embeddedClasses[$embeddedClass['declaredField']]['class']); continue; } $fieldRefl = $reflService->getAccessibleProperty(isset($embeddedClass['declared']) ? $embeddedClass['declared'] : $this->name, $property); $parentReflFields[$property] = $fieldRefl; $this->reflFields[$property] = $fieldRefl; } foreach ($this->fieldMappings as $field => $mapping) { if (isset($mapping['declaredField']) && isset($parentReflFields[$mapping['declaredField']])) { $this->reflFields[$field] = new \MailPoetVendor\Doctrine\ORM\Mapping\ReflectionEmbeddedProperty($parentReflFields[$mapping['declaredField']], $reflService->getAccessibleProperty($mapping['originalClass'], $mapping['originalField']), $mapping['originalClass']); continue; } $this->reflFields[$field] = isset($mapping['declared']) ? $reflService->getAccessibleProperty($mapping['declared'], $field) : $reflService->getAccessibleProperty($this->name, $field); } foreach ($this->associationMappings as $field => $mapping) { $this->reflFields[$field] = isset($mapping['declared']) ? $reflService->getAccessibleProperty($mapping['declared'], $field) : $reflService->getAccessibleProperty($this->name, $field); } } public function initializeReflection($reflService) { $this->reflClass = $reflService->getClass($this->name); $this->namespace = $reflService->getClassNamespace($this->name); if ($this->reflClass) { $this->name = $this->rootEntityName = $this->reflClass->getName(); } $this->table['name'] = $this->namingStrategy->classToTableName($this->name); } public function validateIdentifier() { if ($this->isMappedSuperclass || $this->isEmbeddedClass) { return; } if (!$this->identifier) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::identifierRequired($this->name); } if ($this->usesIdGenerator() && $this->isIdentifierComposite) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::compositeKeyAssignedIdGeneratorRequired($this->name); } } public function validateAssociations() { foreach ($this->associationMappings as $mapping) { if (!\MailPoetVendor\Doctrine\Common\ClassLoader::classExists($mapping['targetEntity'])) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::invalidTargetEntityClass($mapping['targetEntity'], $this->name, $mapping['fieldName']); } } } public function validateLifecycleCallbacks($reflService) { foreach ($this->lifecycleCallbacks as $callbacks) { foreach ($callbacks as $callbackFuncName) { if (!$reflService->hasPublicMethod($this->name, $callbackFuncName)) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::lifecycleCallbackMethodNotFound($this->name, $callbackFuncName); } } } } public function getReflectionClass() { return $this->reflClass; } public function enableCache(array $cache) { if (!isset($cache['usage'])) { $cache['usage'] = self::CACHE_USAGE_READ_ONLY; } if (!isset($cache['region'])) { $cache['region'] = \strtolower(\str_replace('\\', '_', $this->rootEntityName)); } $this->cache = $cache; } public function enableAssociationCache($fieldName, array $cache) { if (!isset($cache['usage'])) { $cache['usage'] = isset($this->cache['usage']) ? $this->cache['usage'] : self::CACHE_USAGE_READ_ONLY; } if (!isset($cache['region'])) { $cache['region'] = \strtolower(\str_replace('\\', '_', $this->rootEntityName)) . '__' . $fieldName; } $this->associationMappings[$fieldName]['cache'] = $cache; } public function setChangeTrackingPolicy($policy) { $this->changeTrackingPolicy = $policy; } public function isChangeTrackingDeferredExplicit() { return $this->changeTrackingPolicy == self::CHANGETRACKING_DEFERRED_EXPLICIT; } public function isChangeTrackingDeferredImplicit() { return $this->changeTrackingPolicy == self::CHANGETRACKING_DEFERRED_IMPLICIT; } public function isChangeTrackingNotify() { return $this->changeTrackingPolicy == self::CHANGETRACKING_NOTIFY; } public function isIdentifier($fieldName) { if (!$this->identifier) { return \false; } if (!$this->isIdentifierComposite) { return $fieldName === $this->identifier[0]; } return \in_array($fieldName, $this->identifier); } public function isUniqueField($fieldName) { $mapping = $this->getFieldMapping($fieldName); if ($mapping !== \false) { return isset($mapping['unique']) && $mapping['unique'] == \true; } return \false; } public function isNullable($fieldName) { $mapping = $this->getFieldMapping($fieldName); if ($mapping !== \false) { return isset($mapping['nullable']) && $mapping['nullable'] == \true; } return \false; } public function getColumnName($fieldName) { return isset($this->columnNames[$fieldName]) ? $this->columnNames[$fieldName] : $fieldName; } public function getFieldMapping($fieldName) { if (!isset($this->fieldMappings[$fieldName])) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::mappingNotFound($this->name, $fieldName); } return $this->fieldMappings[$fieldName]; } public function getAssociationMapping($fieldName) { if (!isset($this->associationMappings[$fieldName])) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::mappingNotFound($this->name, $fieldName); } return $this->associationMappings[$fieldName]; } public function getAssociationMappings() { return $this->associationMappings; } public function getFieldName($columnName) { return isset($this->fieldNames[$columnName]) ? $this->fieldNames[$columnName] : $columnName; } public function getNamedQuery($queryName) { if (!isset($this->namedQueries[$queryName])) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::queryNotFound($this->name, $queryName); } return $this->namedQueries[$queryName]['dql']; } public function getNamedQueries() { return $this->namedQueries; } public function getNamedNativeQuery($queryName) { if (!isset($this->namedNativeQueries[$queryName])) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::queryNotFound($this->name, $queryName); } return $this->namedNativeQueries[$queryName]; } public function getNamedNativeQueries() { return $this->namedNativeQueries; } public function getSqlResultSetMapping($name) { if (!isset($this->sqlResultSetMappings[$name])) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::resultMappingNotFound($this->name, $name); } return $this->sqlResultSetMappings[$name]; } public function getSqlResultSetMappings() { return $this->sqlResultSetMappings; } protected function _validateAndCompleteFieldMapping(array &$mapping) { if (!isset($mapping['fieldName']) || \strlen($mapping['fieldName']) == 0) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::missingFieldName($this->name); } if (!isset($mapping['type'])) { $mapping['type'] = 'string'; } if (!isset($mapping['columnName'])) { $mapping['columnName'] = $this->namingStrategy->propertyToColumnName($mapping['fieldName'], $this->name); } if ($mapping['columnName'][0] === '`') { $mapping['columnName'] = \trim($mapping['columnName'], '`'); $mapping['quoted'] = \true; } $this->columnNames[$mapping['fieldName']] = $mapping['columnName']; if (isset($this->fieldNames[$mapping['columnName']]) || $this->discriminatorColumn != null && $this->discriminatorColumn['name'] == $mapping['columnName']) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::duplicateColumnName($this->name, $mapping['columnName']); } $this->fieldNames[$mapping['columnName']] = $mapping['fieldName']; if (isset($mapping['id']) && $mapping['id'] === \true) { if ($this->versionField == $mapping['fieldName']) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::cannotVersionIdField($this->name, $mapping['fieldName']); } if (!\in_array($mapping['fieldName'], $this->identifier)) { $this->identifier[] = $mapping['fieldName']; } if (!$this->isIdentifierComposite && \count($this->identifier) > 1) { $this->isIdentifierComposite = \true; } } if (\MailPoetVendor\Doctrine\DBAL\Types\Type::hasType($mapping['type']) && \MailPoetVendor\Doctrine\DBAL\Types\Type::getType($mapping['type'])->canRequireSQLConversion()) { if (isset($mapping['id']) && $mapping['id'] === \true) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::sqlConversionNotAllowedForIdentifiers($this->name, $mapping['fieldName'], $mapping['type']); } $mapping['requireSQLConversion'] = \true; } } protected function _validateAndCompleteAssociationMapping(array $mapping) { if (!isset($mapping['mappedBy'])) { $mapping['mappedBy'] = null; } if (!isset($mapping['inversedBy'])) { $mapping['inversedBy'] = null; } $mapping['isOwningSide'] = \true; if (!isset($mapping['indexBy']) || !$mapping['indexBy']) { unset($mapping['indexBy']); } $mapping['sourceEntity'] = $this->name; if (isset($mapping['targetEntity'])) { $mapping['targetEntity'] = $this->fullyQualifiedClassName($mapping['targetEntity']); $mapping['targetEntity'] = \ltrim($mapping['targetEntity'], '\\'); } if (($mapping['type'] & self::MANY_TO_ONE) > 0 && isset($mapping['orphanRemoval']) && $mapping['orphanRemoval'] == \true) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::illegalOrphanRemoval($this->name, $mapping['fieldName']); } if (isset($mapping['id']) && $mapping['id'] === \true) { if (isset($mapping['orphanRemoval']) && $mapping['orphanRemoval'] == \true) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::illegalOrphanRemovalOnIdentifierAssociation($this->name, $mapping['fieldName']); } if (!\in_array($mapping['fieldName'], $this->identifier)) { if (isset($mapping['joinColumns']) && \count($mapping['joinColumns']) >= 2) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::cannotMapCompositePrimaryKeyEntitiesAsForeignId($mapping['targetEntity'], $this->name, $mapping['fieldName']); } $this->identifier[] = $mapping['fieldName']; $this->containsForeignIdentifier = \true; } if (!$this->isIdentifierComposite && \count($this->identifier) > 1) { $this->isIdentifierComposite = \true; } } if (!isset($mapping['fieldName']) || \strlen($mapping['fieldName']) == 0) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::missingFieldName($this->name); } if (!isset($mapping['targetEntity'])) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::missingTargetEntity($mapping['fieldName']); } if (!$mapping['mappedBy']) { if (isset($mapping['joinTable']) && $mapping['joinTable']) { if (isset($mapping['joinTable']['name']) && $mapping['joinTable']['name'][0] === '`') { $mapping['joinTable']['name'] = \trim($mapping['joinTable']['name'], '`'); $mapping['joinTable']['quoted'] = \true; } } } else { $mapping['isOwningSide'] = \false; } if (isset($mapping['id']) && $mapping['id'] === \true && $mapping['type'] & self::TO_MANY) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::illegalToManyIdentifierAssociation($this->name, $mapping['fieldName']); } if (!isset($mapping['fetch'])) { $mapping['fetch'] = self::FETCH_LAZY; } $cascades = isset($mapping['cascade']) ? \array_map('strtolower', $mapping['cascade']) : array(); if (\in_array('all', $cascades)) { $cascades = array('remove', 'persist', 'refresh', 'merge', 'detach'); } if (\count($cascades) !== \count(\array_intersect($cascades, array('remove', 'persist', 'refresh', 'merge', 'detach')))) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::invalidCascadeOption(\array_diff($cascades, \array_intersect($cascades, array('remove', 'persist', 'refresh', 'merge', 'detach'))), $this->name, $mapping['fieldName']); } $mapping['cascade'] = $cascades; $mapping['isCascadeRemove'] = \in_array('remove', $cascades); $mapping['isCascadePersist'] = \in_array('persist', $cascades); $mapping['isCascadeRefresh'] = \in_array('refresh', $cascades); $mapping['isCascadeMerge'] = \in_array('merge', $cascades); $mapping['isCascadeDetach'] = \in_array('detach', $cascades); return $mapping; } protected function _validateAndCompleteOneToOneMapping(array $mapping) { $mapping = $this->_validateAndCompleteAssociationMapping($mapping); if (isset($mapping['joinColumns']) && $mapping['joinColumns']) { $mapping['isOwningSide'] = \true; } if ($mapping['isOwningSide']) { if (!isset($mapping['joinColumns']) || !$mapping['joinColumns']) { $mapping['joinColumns'] = array(array('name' => $this->namingStrategy->joinColumnName($mapping['fieldName'], $this->name), 'referencedColumnName' => $this->namingStrategy->referenceColumnName())); } $uniqueConstraintColumns = array(); foreach ($mapping['joinColumns'] as &$joinColumn) { if ($mapping['type'] === self::ONE_TO_ONE && !$this->isInheritanceTypeSingleTable()) { if (\count($mapping['joinColumns']) == 1) { if (!isset($mapping['id']) || !$mapping['id']) { $joinColumn['unique'] = \true; } } else { $uniqueConstraintColumns[] = $joinColumn['name']; } } if (empty($joinColumn['name'])) { $joinColumn['name'] = $this->namingStrategy->joinColumnName($mapping['fieldName'], $this->name); } if (empty($joinColumn['referencedColumnName'])) { $joinColumn['referencedColumnName'] = $this->namingStrategy->referenceColumnName(); } if ($joinColumn['name'][0] === '`') { $joinColumn['name'] = \trim($joinColumn['name'], '`'); $joinColumn['quoted'] = \true; } if ($joinColumn['referencedColumnName'][0] === '`') { $joinColumn['referencedColumnName'] = \trim($joinColumn['referencedColumnName'], '`'); $joinColumn['quoted'] = \true; } $mapping['sourceToTargetKeyColumns'][$joinColumn['name']] = $joinColumn['referencedColumnName']; $mapping['joinColumnFieldNames'][$joinColumn['name']] = isset($joinColumn['fieldName']) ? $joinColumn['fieldName'] : $joinColumn['name']; } if ($uniqueConstraintColumns) { if (!$this->table) { throw new \RuntimeException("ClassMetadataInfo::setTable() has to be called before defining a one to one relationship."); } $this->table['uniqueConstraints'][$mapping['fieldName'] . "_uniq"] = array('columns' => $uniqueConstraintColumns); } $mapping['targetToSourceKeyColumns'] = \array_flip($mapping['sourceToTargetKeyColumns']); } $mapping['orphanRemoval'] = isset($mapping['orphanRemoval']) ? (bool) $mapping['orphanRemoval'] : \false; $mapping['isCascadeRemove'] = $mapping['orphanRemoval'] ? \true : $mapping['isCascadeRemove']; if ($mapping['orphanRemoval']) { unset($mapping['unique']); } if (isset($mapping['id']) && $mapping['id'] === \true && !$mapping['isOwningSide']) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::illegalInverseIdentifierAssociation($this->name, $mapping['fieldName']); } return $mapping; } protected function _validateAndCompleteOneToManyMapping(array $mapping) { $mapping = $this->_validateAndCompleteAssociationMapping($mapping); if (!isset($mapping['mappedBy'])) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::oneToManyRequiresMappedBy($mapping['fieldName']); } $mapping['orphanRemoval'] = isset($mapping['orphanRemoval']) ? (bool) $mapping['orphanRemoval'] : \false; $mapping['isCascadeRemove'] = $mapping['orphanRemoval'] ? \true : $mapping['isCascadeRemove']; if (isset($mapping['orderBy'])) { if (!\is_array($mapping['orderBy'])) { throw new \InvalidArgumentException("'orderBy' is expected to be an array, not " . \gettype($mapping['orderBy'])); } } return $mapping; } protected function _validateAndCompleteManyToManyMapping(array $mapping) { $mapping = $this->_validateAndCompleteAssociationMapping($mapping); if ($mapping['isOwningSide']) { if (!isset($mapping['joinTable']['name'])) { $mapping['joinTable']['name'] = $this->namingStrategy->joinTableName($mapping['sourceEntity'], $mapping['targetEntity'], $mapping['fieldName']); } $selfReferencingEntityWithoutJoinColumns = $mapping['sourceEntity'] == $mapping['targetEntity'] && !(isset($mapping['joinTable']['joinColumns']) || isset($mapping['joinTable']['inverseJoinColumns'])); if (!isset($mapping['joinTable']['joinColumns'])) { $mapping['joinTable']['joinColumns'] = array(array('name' => $this->namingStrategy->joinKeyColumnName($mapping['sourceEntity'], $selfReferencingEntityWithoutJoinColumns ? 'source' : null), 'referencedColumnName' => $this->namingStrategy->referenceColumnName(), 'onDelete' => 'CASCADE')); } if (!isset($mapping['joinTable']['inverseJoinColumns'])) { $mapping['joinTable']['inverseJoinColumns'] = array(array('name' => $this->namingStrategy->joinKeyColumnName($mapping['targetEntity'], $selfReferencingEntityWithoutJoinColumns ? 'target' : null), 'referencedColumnName' => $this->namingStrategy->referenceColumnName(), 'onDelete' => 'CASCADE')); } $mapping['joinTableColumns'] = array(); foreach ($mapping['joinTable']['joinColumns'] as &$joinColumn) { if (empty($joinColumn['name'])) { $joinColumn['name'] = $this->namingStrategy->joinKeyColumnName($mapping['sourceEntity'], $joinColumn['referencedColumnName']); } if (empty($joinColumn['referencedColumnName'])) { $joinColumn['referencedColumnName'] = $this->namingStrategy->referenceColumnName(); } if ($joinColumn['name'][0] === '`') { $joinColumn['name'] = \trim($joinColumn['name'], '`'); $joinColumn['quoted'] = \true; } if ($joinColumn['referencedColumnName'][0] === '`') { $joinColumn['referencedColumnName'] = \trim($joinColumn['referencedColumnName'], '`'); $joinColumn['quoted'] = \true; } if (isset($joinColumn['onDelete']) && \strtolower($joinColumn['onDelete']) == 'cascade') { $mapping['isOnDeleteCascade'] = \true; } $mapping['relationToSourceKeyColumns'][$joinColumn['name']] = $joinColumn['referencedColumnName']; $mapping['joinTableColumns'][] = $joinColumn['name']; } foreach ($mapping['joinTable']['inverseJoinColumns'] as &$inverseJoinColumn) { if (empty($inverseJoinColumn['name'])) { $inverseJoinColumn['name'] = $this->namingStrategy->joinKeyColumnName($mapping['targetEntity'], $inverseJoinColumn['referencedColumnName']); } if (empty($inverseJoinColumn['referencedColumnName'])) { $inverseJoinColumn['referencedColumnName'] = $this->namingStrategy->referenceColumnName(); } if ($inverseJoinColumn['name'][0] === '`') { $inverseJoinColumn['name'] = \trim($inverseJoinColumn['name'], '`'); $inverseJoinColumn['quoted'] = \true; } if ($inverseJoinColumn['referencedColumnName'][0] === '`') { $inverseJoinColumn['referencedColumnName'] = \trim($inverseJoinColumn['referencedColumnName'], '`'); $inverseJoinColumn['quoted'] = \true; } if (isset($inverseJoinColumn['onDelete']) && \strtolower($inverseJoinColumn['onDelete']) == 'cascade') { $mapping['isOnDeleteCascade'] = \true; } $mapping['relationToTargetKeyColumns'][$inverseJoinColumn['name']] = $inverseJoinColumn['referencedColumnName']; $mapping['joinTableColumns'][] = $inverseJoinColumn['name']; } } $mapping['orphanRemoval'] = isset($mapping['orphanRemoval']) ? (bool) $mapping['orphanRemoval'] : \false; if (isset($mapping['orderBy'])) { if (!\is_array($mapping['orderBy'])) { throw new \InvalidArgumentException("'orderBy' is expected to be an array, not " . \gettype($mapping['orderBy'])); } } return $mapping; } public function getIdentifierFieldNames() { return $this->identifier; } public function getSingleIdentifierFieldName() { if ($this->isIdentifierComposite) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::singleIdNotAllowedOnCompositePrimaryKey($this->name); } return $this->identifier[0]; } public function getSingleIdentifierColumnName() { return $this->getColumnName($this->getSingleIdentifierFieldName()); } public function setIdentifier(array $identifier) { $this->identifier = $identifier; $this->isIdentifierComposite = \count($this->identifier) > 1; } public function getIdentifier() { return $this->identifier; } public function hasField($fieldName) { return isset($this->fieldMappings[$fieldName]); } public function getColumnNames(array $fieldNames = null) { if ($fieldNames === null) { return \array_keys($this->fieldNames); } else { $columnNames = array(); foreach ($fieldNames as $fieldName) { $columnNames[] = $this->getColumnName($fieldName); } return $columnNames; } } public function getIdentifierColumnNames() { $columnNames = array(); foreach ($this->identifier as $idProperty) { if (isset($this->fieldMappings[$idProperty])) { $columnNames[] = $this->fieldMappings[$idProperty]['columnName']; continue; } $joinColumns = $this->associationMappings[$idProperty]['joinColumns']; $assocColumnNames = \array_map(function ($joinColumn) { return $joinColumn['name']; }, $joinColumns); $columnNames = \array_merge($columnNames, $assocColumnNames); } return $columnNames; } public function setIdGeneratorType($generatorType) { $this->generatorType = $generatorType; } public function usesIdGenerator() { return $this->generatorType != self::GENERATOR_TYPE_NONE; } public function isInheritanceTypeNone() { return $this->inheritanceType == self::INHERITANCE_TYPE_NONE; } public function isInheritanceTypeJoined() { return $this->inheritanceType == self::INHERITANCE_TYPE_JOINED; } public function isInheritanceTypeSingleTable() { return $this->inheritanceType == self::INHERITANCE_TYPE_SINGLE_TABLE; } public function isInheritanceTypeTablePerClass() { return $this->inheritanceType == self::INHERITANCE_TYPE_TABLE_PER_CLASS; } public function isIdGeneratorIdentity() { return $this->generatorType == self::GENERATOR_TYPE_IDENTITY; } public function isIdGeneratorSequence() { return $this->generatorType == self::GENERATOR_TYPE_SEQUENCE; } public function isIdGeneratorTable() { return $this->generatorType == self::GENERATOR_TYPE_TABLE; } public function isIdentifierNatural() { return $this->generatorType == self::GENERATOR_TYPE_NONE; } public function isIdentifierUuid() { return $this->generatorType == self::GENERATOR_TYPE_UUID; } public function getTypeOfField($fieldName) { return isset($this->fieldMappings[$fieldName]) ? $this->fieldMappings[$fieldName]['type'] : null; } public function getTypeOfColumn($columnName) { return $this->getTypeOfField($this->getFieldName($columnName)); } public function getTableName() { return $this->table['name']; } public function getSchemaName() { return isset($this->table['schema']) ? $this->table['schema'] : null; } public function getTemporaryIdTableName() { return \str_replace('.', '_', $this->getTableName() . '_id_tmp'); } public function setSubclasses(array $subclasses) { foreach ($subclasses as $subclass) { $this->subClasses[] = $this->fullyQualifiedClassName($subclass); } } public function setParentClasses(array $classNames) { $this->parentClasses = $classNames; if (\count($classNames) > 0) { $this->rootEntityName = \array_pop($classNames); } } public function setInheritanceType($type) { if (!$this->_isInheritanceType($type)) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::invalidInheritanceType($this->name, $type); } $this->inheritanceType = $type; } public function setAssociationOverride($fieldName, array $overrideMapping) { if (!isset($this->associationMappings[$fieldName])) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::invalidOverrideFieldName($this->name, $fieldName); } $mapping = $this->associationMappings[$fieldName]; if (isset($overrideMapping['joinColumns'])) { $mapping['joinColumns'] = $overrideMapping['joinColumns']; } if (isset($overrideMapping['joinTable'])) { $mapping['joinTable'] = $overrideMapping['joinTable']; } $mapping['joinColumnFieldNames'] = null; $mapping['joinTableColumns'] = null; $mapping['sourceToTargetKeyColumns'] = null; $mapping['relationToSourceKeyColumns'] = null; $mapping['relationToTargetKeyColumns'] = null; switch ($mapping['type']) { case self::ONE_TO_ONE: $mapping = $this->_validateAndCompleteOneToOneMapping($mapping); break; case self::ONE_TO_MANY: $mapping = $this->_validateAndCompleteOneToManyMapping($mapping); break; case self::MANY_TO_ONE: $mapping = $this->_validateAndCompleteOneToOneMapping($mapping); break; case self::MANY_TO_MANY: $mapping = $this->_validateAndCompleteManyToManyMapping($mapping); break; } $this->associationMappings[$fieldName] = $mapping; } public function setAttributeOverride($fieldName, array $overrideMapping) { if (!isset($this->fieldMappings[$fieldName])) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::invalidOverrideFieldName($this->name, $fieldName); } $mapping = $this->fieldMappings[$fieldName]; if (isset($mapping['id'])) { $overrideMapping['id'] = $mapping['id']; } if (!isset($overrideMapping['type']) || $overrideMapping['type'] === null) { $overrideMapping['type'] = $mapping['type']; } if (!isset($overrideMapping['fieldName']) || $overrideMapping['fieldName'] === null) { $overrideMapping['fieldName'] = $mapping['fieldName']; } if ($overrideMapping['type'] !== $mapping['type']) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::invalidOverrideFieldType($this->name, $fieldName); } unset($this->fieldMappings[$fieldName]); unset($this->fieldNames[$mapping['columnName']]); unset($this->columnNames[$mapping['fieldName']]); $this->_validateAndCompleteFieldMapping($overrideMapping); $this->fieldMappings[$fieldName] = $overrideMapping; } public function isInheritedField($fieldName) { return isset($this->fieldMappings[$fieldName]['inherited']); } public function isRootEntity() { return $this->name == $this->rootEntityName; } public function isInheritedAssociation($fieldName) { return isset($this->associationMappings[$fieldName]['inherited']); } public function isInheritedEmbeddedClass($fieldName) { return isset($this->embeddedClasses[$fieldName]['inherited']); } public function setTableName($tableName) { $this->table['name'] = $tableName; } public function setPrimaryTable(array $table) { if (isset($table['name'])) { if (\strpos($table['name'], '.') !== \false) { list($this->table['schema'], $table['name']) = \explode('.', $table['name'], 2); } if ($table['name'][0] === '`') { $table['name'] = \trim($table['name'], '`'); $this->table['quoted'] = \true; } $this->table['name'] = $table['name']; } if (isset($table['schema'])) { $this->table['schema'] = $table['schema']; } if (isset($table['indexes'])) { $this->table['indexes'] = $table['indexes']; } if (isset($table['uniqueConstraints'])) { $this->table['uniqueConstraints'] = $table['uniqueConstraints']; } if (isset($table['options'])) { $this->table['options'] = $table['options']; } } private function _isInheritanceType($type) { return $type == self::INHERITANCE_TYPE_NONE || $type == self::INHERITANCE_TYPE_SINGLE_TABLE || $type == self::INHERITANCE_TYPE_JOINED || $type == self::INHERITANCE_TYPE_TABLE_PER_CLASS; } public function mapField(array $mapping) { $this->_validateAndCompleteFieldMapping($mapping); $this->assertFieldNotMapped($mapping['fieldName']); $this->fieldMappings[$mapping['fieldName']] = $mapping; } public function addInheritedAssociationMapping(array $mapping) { if (isset($this->associationMappings[$mapping['fieldName']])) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::duplicateAssociationMapping($this->name, $mapping['fieldName']); } $this->associationMappings[$mapping['fieldName']] = $mapping; } public function addInheritedFieldMapping(array $fieldMapping) { $this->fieldMappings[$fieldMapping['fieldName']] = $fieldMapping; $this->columnNames[$fieldMapping['fieldName']] = $fieldMapping['columnName']; $this->fieldNames[$fieldMapping['columnName']] = $fieldMapping['fieldName']; } public function addNamedQuery(array $queryMapping) { if (!isset($queryMapping['name'])) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::nameIsMandatoryForQueryMapping($this->name); } if (isset($this->namedQueries[$queryMapping['name']])) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::duplicateQueryMapping($this->name, $queryMapping['name']); } if (!isset($queryMapping['query'])) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::emptyQueryMapping($this->name, $queryMapping['name']); } $name = $queryMapping['name']; $query = $queryMapping['query']; $dql = \str_replace('__CLASS__', $this->name, $query); $this->namedQueries[$name] = array('name' => $name, 'query' => $query, 'dql' => $dql); } public function addNamedNativeQuery(array $queryMapping) { if (!isset($queryMapping['name'])) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::nameIsMandatoryForQueryMapping($this->name); } if (isset($this->namedNativeQueries[$queryMapping['name']])) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::duplicateQueryMapping($this->name, $queryMapping['name']); } if (!isset($queryMapping['query'])) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::emptyQueryMapping($this->name, $queryMapping['name']); } if (!isset($queryMapping['resultClass']) && !isset($queryMapping['resultSetMapping'])) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::missingQueryMapping($this->name, $queryMapping['name']); } $queryMapping['isSelfClass'] = \false; if (isset($queryMapping['resultClass'])) { if ($queryMapping['resultClass'] === '__CLASS__') { $queryMapping['isSelfClass'] = \true; $queryMapping['resultClass'] = $this->name; } $queryMapping['resultClass'] = $this->fullyQualifiedClassName($queryMapping['resultClass']); $queryMapping['resultClass'] = \ltrim($queryMapping['resultClass'], '\\'); } $this->namedNativeQueries[$queryMapping['name']] = $queryMapping; } public function addSqlResultSetMapping(array $resultMapping) { if (!isset($resultMapping['name'])) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::nameIsMandatoryForSqlResultSetMapping($this->name); } if (isset($this->sqlResultSetMappings[$resultMapping['name']])) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::duplicateResultSetMapping($this->name, $resultMapping['name']); } if (isset($resultMapping['entities'])) { foreach ($resultMapping['entities'] as $key => $entityResult) { if (!isset($entityResult['entityClass'])) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::missingResultSetMappingEntity($this->name, $resultMapping['name']); } $entityResult['isSelfClass'] = \false; if ($entityResult['entityClass'] === '__CLASS__') { $entityResult['isSelfClass'] = \true; $entityResult['entityClass'] = $this->name; } $entityResult['entityClass'] = $this->fullyQualifiedClassName($entityResult['entityClass']); $resultMapping['entities'][$key]['entityClass'] = \ltrim($entityResult['entityClass'], '\\'); $resultMapping['entities'][$key]['isSelfClass'] = $entityResult['isSelfClass']; if (isset($entityResult['fields'])) { foreach ($entityResult['fields'] as $k => $field) { if (!isset($field['name'])) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::missingResultSetMappingFieldName($this->name, $resultMapping['name']); } if (!isset($field['column'])) { $fieldName = $field['name']; if (\strpos($fieldName, '.')) { list(, $fieldName) = \explode('.', $fieldName); } $resultMapping['entities'][$key]['fields'][$k]['column'] = $fieldName; } } } } } $this->sqlResultSetMappings[$resultMapping['name']] = $resultMapping; } public function mapOneToOne(array $mapping) { $mapping['type'] = self::ONE_TO_ONE; $mapping = $this->_validateAndCompleteOneToOneMapping($mapping); $this->_storeAssociationMapping($mapping); } public function mapOneToMany(array $mapping) { $mapping['type'] = self::ONE_TO_MANY; $mapping = $this->_validateAndCompleteOneToManyMapping($mapping); $this->_storeAssociationMapping($mapping); } public function mapManyToOne(array $mapping) { $mapping['type'] = self::MANY_TO_ONE; $mapping = $this->_validateAndCompleteOneToOneMapping($mapping); $this->_storeAssociationMapping($mapping); } public function mapManyToMany(array $mapping) { $mapping['type'] = self::MANY_TO_MANY; $mapping = $this->_validateAndCompleteManyToManyMapping($mapping); $this->_storeAssociationMapping($mapping); } protected function _storeAssociationMapping(array $assocMapping) { $sourceFieldName = $assocMapping['fieldName']; $this->assertFieldNotMapped($sourceFieldName); $this->associationMappings[$sourceFieldName] = $assocMapping; } public function setCustomRepositoryClass($repositoryClassName) { $this->customRepositoryClassName = $this->fullyQualifiedClassName($repositoryClassName); } public function invokeLifecycleCallbacks($lifecycleEvent, $entity) { foreach ($this->lifecycleCallbacks[$lifecycleEvent] as $callback) { $entity->{$callback}(); } } public function hasLifecycleCallbacks($lifecycleEvent) { return isset($this->lifecycleCallbacks[$lifecycleEvent]); } public function getLifecycleCallbacks($event) { return isset($this->lifecycleCallbacks[$event]) ? $this->lifecycleCallbacks[$event] : array(); } public function addLifecycleCallback($callback, $event) { if (isset($this->lifecycleCallbacks[$event]) && \in_array($callback, $this->lifecycleCallbacks[$event])) { return; } $this->lifecycleCallbacks[$event][] = $callback; } public function setLifecycleCallbacks(array $callbacks) { $this->lifecycleCallbacks = $callbacks; } public function addEntityListener($eventName, $class, $method) { $class = $this->fullyQualifiedClassName($class); $listener = array('class' => $class, 'method' => $method); if (!\class_exists($class)) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::entityListenerClassNotFound($class, $this->name); } if (!\method_exists($class, $method)) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::entityListenerMethodNotFound($class, $method, $this->name); } if (isset($this->entityListeners[$eventName]) && \in_array($listener, $this->entityListeners[$eventName])) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::duplicateEntityListener($class, $method, $this->name); } $this->entityListeners[$eventName][] = $listener; } public function setDiscriminatorColumn($columnDef) { if ($columnDef !== null) { if (!isset($columnDef['name'])) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::nameIsMandatoryForDiscriminatorColumns($this->name); } if (isset($this->fieldNames[$columnDef['name']])) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::duplicateColumnName($this->name, $columnDef['name']); } if (!isset($columnDef['fieldName'])) { $columnDef['fieldName'] = $columnDef['name']; } if (!isset($columnDef['type'])) { $columnDef['type'] = "string"; } if (\in_array($columnDef['type'], array("boolean", "array", "object", "datetime", "time", "date"))) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::invalidDiscriminatorColumnType($this->name, $columnDef['type']); } $this->discriminatorColumn = $columnDef; } } public function setDiscriminatorMap(array $map) { foreach ($map as $value => $className) { $this->addDiscriminatorMapClass($value, $className); } } public function addDiscriminatorMapClass($name, $className) { $className = $this->fullyQualifiedClassName($className); $className = \ltrim($className, '\\'); $this->discriminatorMap[$name] = $className; if ($this->name === $className) { $this->discriminatorValue = $name; return; } if (!(\class_exists($className) || \interface_exists($className))) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::invalidClassInDiscriminatorMap($className, $this->name); } if (\is_subclass_of($className, $this->name) && !\in_array($className, $this->subClasses)) { $this->subClasses[] = $className; } } public function hasNamedQuery($queryName) { return isset($this->namedQueries[$queryName]); } public function hasNamedNativeQuery($queryName) { return isset($this->namedNativeQueries[$queryName]); } public function hasSqlResultSetMapping($name) { return isset($this->sqlResultSetMappings[$name]); } public function hasAssociation($fieldName) { return isset($this->associationMappings[$fieldName]); } public function isSingleValuedAssociation($fieldName) { return isset($this->associationMappings[$fieldName]) && $this->associationMappings[$fieldName]['type'] & self::TO_ONE; } public function isCollectionValuedAssociation($fieldName) { return isset($this->associationMappings[$fieldName]) && !($this->associationMappings[$fieldName]['type'] & self::TO_ONE); } public function isAssociationWithSingleJoinColumn($fieldName) { return isset($this->associationMappings[$fieldName]) && isset($this->associationMappings[$fieldName]['joinColumns'][0]) && !isset($this->associationMappings[$fieldName]['joinColumns'][1]); } public function getSingleAssociationJoinColumnName($fieldName) { if (!$this->isAssociationWithSingleJoinColumn($fieldName)) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::noSingleAssociationJoinColumnFound($this->name, $fieldName); } return $this->associationMappings[$fieldName]['joinColumns'][0]['name']; } public function getSingleAssociationReferencedJoinColumnName($fieldName) { if (!$this->isAssociationWithSingleJoinColumn($fieldName)) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::noSingleAssociationJoinColumnFound($this->name, $fieldName); } return $this->associationMappings[$fieldName]['joinColumns'][0]['referencedColumnName']; } public function getFieldForColumn($columnName) { if (isset($this->fieldNames[$columnName])) { return $this->fieldNames[$columnName]; } else { foreach ($this->associationMappings as $assocName => $mapping) { if ($this->isAssociationWithSingleJoinColumn($assocName) && $this->associationMappings[$assocName]['joinColumns'][0]['name'] == $columnName) { return $assocName; } } throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::noFieldNameFoundForColumn($this->name, $columnName); } } public function setIdGenerator($generator) { $this->idGenerator = $generator; } public function setCustomGeneratorDefinition(array $definition) { $this->customGeneratorDefinition = $definition; } public function setSequenceGeneratorDefinition(array $definition) { if (!isset($definition['sequenceName']) || \trim($definition['sequenceName']) === '') { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::missingSequenceName($this->name); } if ($definition['sequenceName'][0] == '`') { $definition['sequenceName'] = \trim($definition['sequenceName'], '`'); $definition['quoted'] = \true; } if (!isset($definition['allocationSize']) || \trim($definition['allocationSize']) === '') { $definition['allocationSize'] = '1'; } if (!isset($definition['initialValue']) || \trim($definition['initialValue']) === '') { $definition['initialValue'] = '1'; } $this->sequenceGeneratorDefinition = $definition; } public function setVersionMapping(array &$mapping) { $this->isVersioned = \true; $this->versionField = $mapping['fieldName']; if (!isset($mapping['default'])) { if (\in_array($mapping['type'], array('integer', 'bigint', 'smallint'))) { $mapping['default'] = 1; } else { if ($mapping['type'] == 'datetime') { $mapping['default'] = 'CURRENT_TIMESTAMP'; } else { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::unsupportedOptimisticLockingType($this->name, $mapping['fieldName'], $mapping['type']); } } } } public function setVersioned($bool) { $this->isVersioned = $bool; } public function setVersionField($versionField) { $this->versionField = $versionField; } public function markReadOnly() { $this->isReadOnly = \true; } public function getFieldNames() { return \array_keys($this->fieldMappings); } public function getAssociationNames() { return \array_keys($this->associationMappings); } public function getAssociationTargetClass($assocName) { if (!isset($this->associationMappings[$assocName])) { throw new \InvalidArgumentException("Association name expected, '" . $assocName . "' is not an association."); } return $this->associationMappings[$assocName]['targetEntity']; } public function getName() { return $this->name; } public function getQuotedIdentifierColumnNames($platform) { $quotedColumnNames = array(); foreach ($this->identifier as $idProperty) { if (isset($this->fieldMappings[$idProperty])) { $quotedColumnNames[] = isset($this->fieldMappings[$idProperty]['quoted']) ? $platform->quoteIdentifier($this->fieldMappings[$idProperty]['columnName']) : $this->fieldMappings[$idProperty]['columnName']; continue; } $joinColumns = $this->associationMappings[$idProperty]['joinColumns']; $assocQuotedColumnNames = \array_map(function ($joinColumn) use($platform) { return isset($joinColumn['quoted']) ? $platform->quoteIdentifier($joinColumn['name']) : $joinColumn['name']; }, $joinColumns); $quotedColumnNames = \array_merge($quotedColumnNames, $assocQuotedColumnNames); } return $quotedColumnNames; } public function getQuotedColumnName($field, $platform) { return isset($this->fieldMappings[$field]['quoted']) ? $platform->quoteIdentifier($this->fieldMappings[$field]['columnName']) : $this->fieldMappings[$field]['columnName']; } public function getQuotedTableName($platform) { return isset($this->table['quoted']) ? $platform->quoteIdentifier($this->table['name']) : $this->table['name']; } public function getQuotedJoinTableName(array $assoc, $platform) { return isset($assoc['joinTable']['quoted']) ? $platform->quoteIdentifier($assoc['joinTable']['name']) : $assoc['joinTable']['name']; } public function isAssociationInverseSide($fieldName) { return isset($this->associationMappings[$fieldName]) && !$this->associationMappings[$fieldName]['isOwningSide']; } public function getAssociationMappedByTargetField($fieldName) { return $this->associationMappings[$fieldName]['mappedBy']; } public function getAssociationsByTargetClass($targetClass) { $relations = array(); foreach ($this->associationMappings as $mapping) { if ($mapping['targetEntity'] == $targetClass) { $relations[$mapping['fieldName']] = $mapping; } } return $relations; } public function fullyQualifiedClassName($className) { if (empty($className)) { return $className; } if ($className !== null && \strpos($className, '\\') === \false && \strlen($this->namespace) > 0) { return $this->namespace . '\\' . $className; } return $className; } public function getMetadataValue($name) { if (isset($this->{$name})) { return $this->{$name}; } return null; } public function mapEmbedded(array $mapping) { $this->assertFieldNotMapped($mapping['fieldName']); $this->embeddedClasses[$mapping['fieldName']] = array('class' => $this->fullyQualifiedClassName($mapping['class']), 'columnPrefix' => $mapping['columnPrefix'], 'declaredField' => isset($mapping['declaredField']) ? $mapping['declaredField'] : null, 'originalField' => isset($mapping['originalField']) ? $mapping['originalField'] : null); } public function inlineEmbeddable($property, \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadataInfo $embeddable) { foreach ($embeddable->fieldMappings as $fieldMapping) { $fieldMapping['originalClass'] = isset($fieldMapping['originalClass']) ? $fieldMapping['originalClass'] : $embeddable->name; $fieldMapping['declaredField'] = isset($fieldMapping['declaredField']) ? $property . '.' . $fieldMapping['declaredField'] : $property; $fieldMapping['originalField'] = isset($fieldMapping['originalField']) ? $fieldMapping['originalField'] : $fieldMapping['fieldName']; $fieldMapping['fieldName'] = $property . "." . $fieldMapping['fieldName']; if (!empty($this->embeddedClasses[$property]['columnPrefix'])) { $fieldMapping['columnName'] = $this->embeddedClasses[$property]['columnPrefix'] . $fieldMapping['columnName']; } elseif ($this->embeddedClasses[$property]['columnPrefix'] !== \false) { $fieldMapping['columnName'] = $this->namingStrategy->embeddedFieldToColumnName($property, $fieldMapping['columnName'], $this->reflClass->name, $embeddable->reflClass->name); } $this->mapField($fieldMapping); } } private function assertFieldNotMapped($fieldName) { if (isset($this->fieldMappings[$fieldName]) || isset($this->associationMappings[$fieldName]) || isset($this->embeddedClasses[$fieldName])) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::duplicateFieldMapping($this->name, $fieldName); } } public function getSequenceName(\MailPoetVendor\Doctrine\DBAL\Platforms\AbstractPlatform $platform) { $sequencePrefix = $this->getSequencePrefix($platform); $columnName = $this->getSingleIdentifierColumnName(); $sequenceName = $sequencePrefix . '_' . $columnName . '_seq'; return $sequenceName; } public function getSequencePrefix(\MailPoetVendor\Doctrine\DBAL\Platforms\AbstractPlatform $platform) { $tableName = $this->getTableName(); $sequencePrefix = $tableName; if ($schemaName = $this->getSchemaName()) { $sequencePrefix = $schemaName . '.' . $tableName; if (!$platform->supportsSchemas() && $platform->canEmulateSchemas()) { $sequencePrefix = $schemaName . '__' . $tableName; } } return $sequencePrefix; } } 