<?php
 namespace MailPoetVendor\Doctrine\ORM\Query; if (!defined('ABSPATH')) exit; use MailPoetVendor\Doctrine\ORM\Query; use MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata; use function in_array; class Parser { private static $_STRING_FUNCTIONS = array('concat' => 'MailPoetVendor\\Doctrine\\ORM\\Query\\AST\\Functions\\ConcatFunction', 'substring' => 'MailPoetVendor\\Doctrine\\ORM\\Query\\AST\\Functions\\SubstringFunction', 'trim' => 'MailPoetVendor\\Doctrine\\ORM\\Query\\AST\\Functions\\TrimFunction', 'lower' => 'MailPoetVendor\\Doctrine\\ORM\\Query\\AST\\Functions\\LowerFunction', 'upper' => 'MailPoetVendor\\Doctrine\\ORM\\Query\\AST\\Functions\\UpperFunction', 'identity' => 'MailPoetVendor\\Doctrine\\ORM\\Query\\AST\\Functions\\IdentityFunction'); private static $_NUMERIC_FUNCTIONS = array('length' => 'MailPoetVendor\\Doctrine\\ORM\\Query\\AST\\Functions\\LengthFunction', 'locate' => 'MailPoetVendor\\Doctrine\\ORM\\Query\\AST\\Functions\\LocateFunction', 'abs' => 'MailPoetVendor\\Doctrine\\ORM\\Query\\AST\\Functions\\AbsFunction', 'sqrt' => 'MailPoetVendor\\Doctrine\\ORM\\Query\\AST\\Functions\\SqrtFunction', 'mod' => 'MailPoetVendor\\Doctrine\\ORM\\Query\\AST\\Functions\\ModFunction', 'size' => 'MailPoetVendor\\Doctrine\\ORM\\Query\\AST\\Functions\\SizeFunction', 'date_diff' => 'MailPoetVendor\\Doctrine\\ORM\\Query\\AST\\Functions\\DateDiffFunction', 'bit_and' => 'MailPoetVendor\\Doctrine\\ORM\\Query\\AST\\Functions\\BitAndFunction', 'bit_or' => 'MailPoetVendor\\Doctrine\\ORM\\Query\\AST\\Functions\\BitOrFunction'); private static $_DATETIME_FUNCTIONS = array('current_date' => 'MailPoetVendor\\Doctrine\\ORM\\Query\\AST\\Functions\\CurrentDateFunction', 'current_time' => 'MailPoetVendor\\Doctrine\\ORM\\Query\\AST\\Functions\\CurrentTimeFunction', 'current_timestamp' => 'MailPoetVendor\\Doctrine\\ORM\\Query\\AST\\Functions\\CurrentTimestampFunction', 'date_add' => 'MailPoetVendor\\Doctrine\\ORM\\Query\\AST\\Functions\\DateAddFunction', 'date_sub' => 'MailPoetVendor\\Doctrine\\ORM\\Query\\AST\\Functions\\DateSubFunction'); private $deferredIdentificationVariables = array(); private $deferredPartialObjectExpressions = array(); private $deferredPathExpressions = array(); private $deferredResultVariables = array(); private $deferredNewObjectExpressions = array(); private $lexer; private $parserResult; private $em; private $query; private $queryComponents = array(); private $nestingLevel = 0; private $customTreeWalkers = array(); private $customOutputWalker; private $identVariableExpressions = array(); public static function isInternalFunction($functionName) { $functionName = \strtolower($functionName); return isset(self::$_STRING_FUNCTIONS[$functionName]) || isset(self::$_DATETIME_FUNCTIONS[$functionName]) || isset(self::$_NUMERIC_FUNCTIONS[$functionName]); } public function __construct(\MailPoetVendor\Doctrine\ORM\Query $query) { $this->query = $query; $this->em = $query->getEntityManager(); $this->lexer = new \MailPoetVendor\Doctrine\ORM\Query\Lexer($query->getDql()); $this->parserResult = new \MailPoetVendor\Doctrine\ORM\Query\ParserResult(); } public function setCustomOutputTreeWalker($className) { $this->customOutputWalker = $className; } public function addCustomTreeWalker($className) { $this->customTreeWalkers[] = $className; } public function getLexer() { return $this->lexer; } public function getParserResult() { return $this->parserResult; } public function getEntityManager() { return $this->em; } public function getAST() { $AST = $this->QueryLanguage(); $this->processDeferredIdentificationVariables(); if ($this->deferredPartialObjectExpressions) { $this->processDeferredPartialObjectExpressions(); } if ($this->deferredPathExpressions) { $this->processDeferredPathExpressions($AST); } if ($this->deferredResultVariables) { $this->processDeferredResultVariables(); } if ($this->deferredNewObjectExpressions) { $this->processDeferredNewObjectExpressions($AST); } $this->processRootEntityAliasSelected(); $this->fixIdentificationVariableOrder($AST); return $AST; } public function match($token) { $lookaheadType = $this->lexer->lookahead['type']; if ($lookaheadType !== $token && $token !== \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_IDENTIFIER && $lookaheadType <= \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_IDENTIFIER) { $this->syntaxError($this->lexer->getLiteral($token)); } $this->lexer->moveNext(); } public function free($deep = \false, $position = 0) { $this->lexer->resetPosition($position); if ($deep) { $this->lexer->resetPeek(); } $this->lexer->token = null; $this->lexer->lookahead = null; } public function parse() { $AST = $this->getAST(); if (($customWalkers = $this->query->getHint(\MailPoetVendor\Doctrine\ORM\Query::HINT_CUSTOM_TREE_WALKERS)) !== \false) { $this->customTreeWalkers = $customWalkers; } if (($customOutputWalker = $this->query->getHint(\MailPoetVendor\Doctrine\ORM\Query::HINT_CUSTOM_OUTPUT_WALKER)) !== \false) { $this->customOutputWalker = $customOutputWalker; } if ($this->customTreeWalkers) { $treeWalkerChain = new \MailPoetVendor\Doctrine\ORM\Query\TreeWalkerChain($this->query, $this->parserResult, $this->queryComponents); foreach ($this->customTreeWalkers as $walker) { $treeWalkerChain->addTreeWalker($walker); } switch (\true) { case $AST instanceof \MailPoetVendor\Doctrine\ORM\Query\AST\UpdateStatement: $treeWalkerChain->walkUpdateStatement($AST); break; case $AST instanceof \MailPoetVendor\Doctrine\ORM\Query\AST\DeleteStatement: $treeWalkerChain->walkDeleteStatement($AST); break; case $AST instanceof \MailPoetVendor\Doctrine\ORM\Query\AST\SelectStatement: default: $treeWalkerChain->walkSelectStatement($AST); } $this->queryComponents = $treeWalkerChain->getQueryComponents(); } $outputWalkerClass = $this->customOutputWalker ?: __NAMESPACE__ . '\\SqlWalker'; $outputWalker = new $outputWalkerClass($this->query, $this->parserResult, $this->queryComponents); $this->parserResult->setSqlExecutor($outputWalker->getExecutor($AST)); return $this->parserResult; } private function fixIdentificationVariableOrder($AST) { if (\count($this->identVariableExpressions) <= 1) { return; } foreach ($this->queryComponents as $dqlAlias => $qComp) { if (!isset($this->identVariableExpressions[$dqlAlias])) { continue; } $expr = $this->identVariableExpressions[$dqlAlias]; $key = \array_search($expr, $AST->selectClause->selectExpressions); unset($AST->selectClause->selectExpressions[$key]); $AST->selectClause->selectExpressions[] = $expr; } } public function syntaxError($expected = '', $token = null) { if ($token === null) { $token = $this->lexer->lookahead; } $tokenPos = isset($token['position']) ? $token['position'] : '-1'; $message = "line 0, col {$tokenPos}: Error: "; $message .= $expected !== '' ? "Expected {$expected}, got " : 'Unexpected '; $message .= $this->lexer->lookahead === null ? 'end of string.' : "'{$token['value']}'"; throw \MailPoetVendor\Doctrine\ORM\Query\QueryException::syntaxError($message, \MailPoetVendor\Doctrine\ORM\Query\QueryException::dqlError($this->query->getDQL())); } public function semanticalError($message = '', $token = null) { if ($token === null) { $token = $this->lexer->lookahead ?? ['position' => null]; } $distance = 12; $dql = $this->query->getDql(); $length = \strlen($dql); $pos = $token['position'] + $distance; $pos = \strpos($dql, ' ', $length > $pos ? $pos : $length); $length = $pos !== \false ? $pos - $token['position'] : $distance; $tokenPos = isset($token['position']) && $token['position'] > 0 ? $token['position'] : '-1'; $tokenStr = \substr($dql, $token['position'], $length); $message = 'line 0, col ' . $tokenPos . " near '" . $tokenStr . "': Error: " . $message; throw \MailPoetVendor\Doctrine\ORM\Query\QueryException::semanticalError($message, \MailPoetVendor\Doctrine\ORM\Query\QueryException::dqlError($this->query->getDQL())); } private function peekBeyondClosingParenthesis($resetPeek = \true) { $token = $this->lexer->peek(); $numUnmatched = 1; while ($numUnmatched > 0 && $token !== null) { switch ($token['type']) { case \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_OPEN_PARENTHESIS: ++$numUnmatched; break; case \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_CLOSE_PARENTHESIS: --$numUnmatched; break; default: } $token = $this->lexer->peek(); } if ($resetPeek) { $this->lexer->resetPeek(); } return $token; } private function isMathOperator($token) { return $token !== null && \in_array($token['type'], array(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_PLUS, \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_MINUS, \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_DIVIDE, \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_MULTIPLY)); } private function isFunction() { $lookaheadType = $this->lexer->lookahead['type']; $peek = $this->lexer->peek(); $this->lexer->resetPeek(); return $lookaheadType >= \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_IDENTIFIER && $peek !== null && $peek['type'] === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_OPEN_PARENTHESIS; } private function isAggregateFunction($tokenType) { return \in_array($tokenType, array(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_AVG, \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_MIN, \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_MAX, \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_SUM, \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_COUNT)); } private function isNextAllAnySome() { return \in_array($this->lexer->lookahead['type'], array(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_ALL, \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_ANY, \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_SOME)); } private function processDeferredIdentificationVariables() { foreach ($this->deferredIdentificationVariables as $deferredItem) { $identVariable = $deferredItem['expression']; if (!isset($this->queryComponents[$identVariable])) { $this->semanticalError("'{$identVariable}' is not defined.", $deferredItem['token']); } $qComp = $this->queryComponents[$identVariable]; if (!isset($qComp['metadata'])) { $this->semanticalError("'{$identVariable}' does not point to a Class.", $deferredItem['token']); } if ($qComp['nestingLevel'] > $deferredItem['nestingLevel']) { $this->semanticalError("'{$identVariable}' is used outside the scope of its declaration.", $deferredItem['token']); } } } private function processDeferredNewObjectExpressions($AST) { foreach ($this->deferredNewObjectExpressions as $deferredItem) { $expression = $deferredItem['expression']; $token = $deferredItem['token']; $className = $expression->className; $args = $expression->args; $fromClassName = isset($AST->fromClause->identificationVariableDeclarations[0]->rangeVariableDeclaration->abstractSchemaName) ? $AST->fromClause->identificationVariableDeclarations[0]->rangeVariableDeclaration->abstractSchemaName : null; if (\strpos($className, '\\') === \false && !\class_exists($className) && \strpos($fromClassName, '\\') !== \false) { $namespace = \substr($fromClassName, 0, \strrpos($fromClassName, '\\')); $fqcn = $namespace . '\\' . $className; if (\class_exists($fqcn)) { $expression->className = $fqcn; $className = $fqcn; } } if (!\class_exists($className)) { $this->semanticalError(\sprintf('Class "%s" is not defined.', $className), $token); } $class = new \ReflectionClass($className); if (!$class->isInstantiable()) { $this->semanticalError(\sprintf('Class "%s" can not be instantiated.', $className), $token); } if ($class->getConstructor() === null) { $this->semanticalError(\sprintf('Class "%s" has not a valid constructor.', $className), $token); } if ($class->getConstructor()->getNumberOfRequiredParameters() > \count($args)) { $this->semanticalError(\sprintf('Number of arguments does not match with "%s" constructor declaration.', $className), $token); } } } private function processDeferredPartialObjectExpressions() { foreach ($this->deferredPartialObjectExpressions as $deferredItem) { $expr = $deferredItem['expression']; $class = $this->queryComponents[$expr->identificationVariable]['metadata']; foreach ($expr->partialFieldSet as $field) { if (isset($class->fieldMappings[$field])) { continue; } if (isset($class->associationMappings[$field]) && $class->associationMappings[$field]['isOwningSide'] && $class->associationMappings[$field]['type'] & \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata::TO_ONE) { continue; } $this->semanticalError("There is no mapped field named '{$field}' on class " . $class->name . ".", $deferredItem['token']); } if (\array_intersect($class->identifier, $expr->partialFieldSet) != $class->identifier) { $this->semanticalError("The partial field selection of class " . $class->name . " must contain the identifier.", $deferredItem['token']); } } } private function processDeferredResultVariables() { foreach ($this->deferredResultVariables as $deferredItem) { $resultVariable = $deferredItem['expression']; if (!isset($this->queryComponents[$resultVariable])) { $this->semanticalError("'{$resultVariable}' is not defined.", $deferredItem['token']); } $qComp = $this->queryComponents[$resultVariable]; if (!isset($qComp['resultVariable'])) { $this->semanticalError("'{$resultVariable}' does not point to a ResultVariable.", $deferredItem['token']); } if ($qComp['nestingLevel'] > $deferredItem['nestingLevel']) { $this->semanticalError("'{$resultVariable}' is used outside the scope of its declaration.", $deferredItem['token']); } } } private function processDeferredPathExpressions($AST) { foreach ($this->deferredPathExpressions as $deferredItem) { $pathExpression = $deferredItem['expression']; $qComp = $this->queryComponents[$pathExpression->identificationVariable]; $class = $qComp['metadata']; if (($field = $pathExpression->field) === null) { $field = $pathExpression->field = $class->identifier[0]; } if (!isset($class->associationMappings[$field]) && !isset($class->fieldMappings[$field])) { $this->semanticalError('Class ' . $class->name . ' has no field or association named ' . $field, $deferredItem['token']); } $fieldType = \MailPoetVendor\Doctrine\ORM\Query\AST\PathExpression::TYPE_STATE_FIELD; if (isset($class->associationMappings[$field])) { $assoc = $class->associationMappings[$field]; $fieldType = $assoc['type'] & \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata::TO_ONE ? \MailPoetVendor\Doctrine\ORM\Query\AST\PathExpression::TYPE_SINGLE_VALUED_ASSOCIATION : \MailPoetVendor\Doctrine\ORM\Query\AST\PathExpression::TYPE_COLLECTION_VALUED_ASSOCIATION; } $expectedType = $pathExpression->expectedType; if (!($expectedType & $fieldType)) { $expectedStringTypes = array(); if ($expectedType & \MailPoetVendor\Doctrine\ORM\Query\AST\PathExpression::TYPE_STATE_FIELD) { $expectedStringTypes[] = 'StateFieldPathExpression'; } if ($expectedType & \MailPoetVendor\Doctrine\ORM\Query\AST\PathExpression::TYPE_SINGLE_VALUED_ASSOCIATION) { $expectedStringTypes[] = 'SingleValuedAssociationField'; } if ($expectedType & \MailPoetVendor\Doctrine\ORM\Query\AST\PathExpression::TYPE_COLLECTION_VALUED_ASSOCIATION) { $expectedStringTypes[] = 'CollectionValuedAssociationField'; } $semanticalError = 'Invalid PathExpression. '; $semanticalError .= \count($expectedStringTypes) == 1 ? 'Must be a ' . $expectedStringTypes[0] . '.' : \implode(' or ', $expectedStringTypes) . ' expected.'; $this->semanticalError($semanticalError, $deferredItem['token']); } $pathExpression->type = $fieldType; } } private function processRootEntityAliasSelected() { if (!\count($this->identVariableExpressions)) { return; } $foundRootEntity = \false; foreach ($this->identVariableExpressions as $dqlAlias => $expr) { if (isset($this->queryComponents[$dqlAlias]) && $this->queryComponents[$dqlAlias]['parent'] === null) { $foundRootEntity = \true; } } if (!$foundRootEntity) { $this->semanticalError('Cannot select entity through identification variables without choosing at least one root entity alias.'); } } public function QueryLanguage() { $this->lexer->moveNext(); switch ($this->lexer->lookahead['type'] ?? null) { case \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_SELECT: $statement = $this->SelectStatement(); break; case \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_UPDATE: $statement = $this->UpdateStatement(); break; case \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_DELETE: $statement = $this->DeleteStatement(); break; default: $this->syntaxError('SELECT, UPDATE or DELETE'); break; } if ($this->lexer->lookahead !== null) { $this->syntaxError('end of string'); } return $statement; } public function SelectStatement() { $selectStatement = new \MailPoetVendor\Doctrine\ORM\Query\AST\SelectStatement($this->SelectClause(), $this->FromClause()); $selectStatement->whereClause = $this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_WHERE) ? $this->WhereClause() : null; $selectStatement->groupByClause = $this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_GROUP) ? $this->GroupByClause() : null; $selectStatement->havingClause = $this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_HAVING) ? $this->HavingClause() : null; $selectStatement->orderByClause = $this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_ORDER) ? $this->OrderByClause() : null; return $selectStatement; } public function UpdateStatement() { $updateStatement = new \MailPoetVendor\Doctrine\ORM\Query\AST\UpdateStatement($this->UpdateClause()); $updateStatement->whereClause = $this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_WHERE) ? $this->WhereClause() : null; return $updateStatement; } public function DeleteStatement() { $deleteStatement = new \MailPoetVendor\Doctrine\ORM\Query\AST\DeleteStatement($this->DeleteClause()); $deleteStatement->whereClause = $this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_WHERE) ? $this->WhereClause() : null; return $deleteStatement; } public function IdentificationVariable() { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_IDENTIFIER); $identVariable = $this->lexer->token['value']; $this->deferredIdentificationVariables[] = array('expression' => $identVariable, 'nestingLevel' => $this->nestingLevel, 'token' => $this->lexer->token); return $identVariable; } public function AliasIdentificationVariable() { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_IDENTIFIER); $aliasIdentVariable = $this->lexer->token['value']; $exists = isset($this->queryComponents[$aliasIdentVariable]); if ($exists) { $this->semanticalError("'{$aliasIdentVariable}' is already defined.", $this->lexer->token); } return $aliasIdentVariable; } public function AbstractSchemaName() { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_IDENTIFIER); $schemaName = \ltrim($this->lexer->token['value'], '\\'); if (\strrpos($schemaName, ':') !== \false) { list($namespaceAlias, $simpleClassName) = \explode(':', $schemaName); $schemaName = $this->em->getConfiguration()->getEntityNamespace($namespaceAlias) . '\\' . $simpleClassName; } $exists = \class_exists($schemaName, \true) || \interface_exists($schemaName, \true); if (!$exists) { $this->semanticalError("Class '{$schemaName}' is not defined.", $this->lexer->token); } return $schemaName; } public function AliasResultVariable() { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_IDENTIFIER); $resultVariable = $this->lexer->token['value']; $exists = isset($this->queryComponents[$resultVariable]); if ($exists) { $this->semanticalError("'{$resultVariable}' is already defined.", $this->lexer->token); } return $resultVariable; } public function ResultVariable() { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_IDENTIFIER); $resultVariable = $this->lexer->token['value']; $this->deferredResultVariables[] = array('expression' => $resultVariable, 'nestingLevel' => $this->nestingLevel, 'token' => $this->lexer->token); return $resultVariable; } public function JoinAssociationPathExpression() { $identVariable = $this->IdentificationVariable(); if (!isset($this->queryComponents[$identVariable])) { $this->semanticalError('Identification Variable ' . $identVariable . ' used in join path expression but was not defined before.'); } $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_DOT); $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_IDENTIFIER); $field = $this->lexer->token['value']; $qComp = $this->queryComponents[$identVariable]; $class = $qComp['metadata']; if (!$class->hasAssociation($field)) { $this->semanticalError('Class ' . $class->name . ' has no association named ' . $field); } return new \MailPoetVendor\Doctrine\ORM\Query\AST\JoinAssociationPathExpression($identVariable, $field); } public function PathExpression($expectedTypes) { $identVariable = $this->IdentificationVariable(); $field = null; if ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_DOT)) { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_DOT); $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_IDENTIFIER); $field = $this->lexer->token['value']; while ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_DOT)) { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_DOT); $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_IDENTIFIER); $field .= '.' . $this->lexer->token['value']; } } $pathExpr = new \MailPoetVendor\Doctrine\ORM\Query\AST\PathExpression($expectedTypes, $identVariable, $field); $this->deferredPathExpressions[] = array('expression' => $pathExpr, 'nestingLevel' => $this->nestingLevel, 'token' => $this->lexer->token); return $pathExpr; } public function AssociationPathExpression() { return $this->PathExpression(\MailPoetVendor\Doctrine\ORM\Query\AST\PathExpression::TYPE_SINGLE_VALUED_ASSOCIATION | \MailPoetVendor\Doctrine\ORM\Query\AST\PathExpression::TYPE_COLLECTION_VALUED_ASSOCIATION); } public function SingleValuedPathExpression() { return $this->PathExpression(\MailPoetVendor\Doctrine\ORM\Query\AST\PathExpression::TYPE_STATE_FIELD | \MailPoetVendor\Doctrine\ORM\Query\AST\PathExpression::TYPE_SINGLE_VALUED_ASSOCIATION); } public function StateFieldPathExpression() { return $this->PathExpression(\MailPoetVendor\Doctrine\ORM\Query\AST\PathExpression::TYPE_STATE_FIELD); } public function SingleValuedAssociationPathExpression() { return $this->PathExpression(\MailPoetVendor\Doctrine\ORM\Query\AST\PathExpression::TYPE_SINGLE_VALUED_ASSOCIATION); } public function CollectionValuedPathExpression() { return $this->PathExpression(\MailPoetVendor\Doctrine\ORM\Query\AST\PathExpression::TYPE_COLLECTION_VALUED_ASSOCIATION); } public function SelectClause() { $isDistinct = \false; $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_SELECT); if ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_DISTINCT)) { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_DISTINCT); $isDistinct = \true; } $selectExpressions = array(); $selectExpressions[] = $this->SelectExpression(); while ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_COMMA)) { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_COMMA); $selectExpressions[] = $this->SelectExpression(); } return new \MailPoetVendor\Doctrine\ORM\Query\AST\SelectClause($selectExpressions, $isDistinct); } public function SimpleSelectClause() { $isDistinct = \false; $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_SELECT); if ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_DISTINCT)) { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_DISTINCT); $isDistinct = \true; } return new \MailPoetVendor\Doctrine\ORM\Query\AST\SimpleSelectClause($this->SimpleSelectExpression(), $isDistinct); } public function UpdateClause() { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_UPDATE); $token = $this->lexer->lookahead; $abstractSchemaName = $this->AbstractSchemaName(); if ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_AS)) { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_AS); } $aliasIdentificationVariable = $this->AliasIdentificationVariable(); $class = $this->em->getClassMetadata($abstractSchemaName); $queryComponent = array('metadata' => $class, 'parent' => null, 'relation' => null, 'map' => null, 'nestingLevel' => $this->nestingLevel, 'token' => $token); $this->queryComponents[$aliasIdentificationVariable] = $queryComponent; $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_SET); $updateItems = array(); $updateItems[] = $this->UpdateItem(); while ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_COMMA)) { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_COMMA); $updateItems[] = $this->UpdateItem(); } $updateClause = new \MailPoetVendor\Doctrine\ORM\Query\AST\UpdateClause($abstractSchemaName, $updateItems); $updateClause->aliasIdentificationVariable = $aliasIdentificationVariable; return $updateClause; } public function DeleteClause() { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_DELETE); if ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_FROM)) { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_FROM); } $token = $this->lexer->lookahead; $deleteClause = new \MailPoetVendor\Doctrine\ORM\Query\AST\DeleteClause($this->AbstractSchemaName()); if ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_AS)) { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_AS); } $aliasIdentificationVariable = $this->AliasIdentificationVariable(); $deleteClause->aliasIdentificationVariable = $aliasIdentificationVariable; $class = $this->em->getClassMetadata($deleteClause->abstractSchemaName); $queryComponent = array('metadata' => $class, 'parent' => null, 'relation' => null, 'map' => null, 'nestingLevel' => $this->nestingLevel, 'token' => $token); $this->queryComponents[$aliasIdentificationVariable] = $queryComponent; return $deleteClause; } public function FromClause() { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_FROM); $identificationVariableDeclarations = array(); $identificationVariableDeclarations[] = $this->IdentificationVariableDeclaration(); while ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_COMMA)) { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_COMMA); $identificationVariableDeclarations[] = $this->IdentificationVariableDeclaration(); } return new \MailPoetVendor\Doctrine\ORM\Query\AST\FromClause($identificationVariableDeclarations); } public function SubselectFromClause() { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_FROM); $identificationVariables = array(); $identificationVariables[] = $this->SubselectIdentificationVariableDeclaration(); while ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_COMMA)) { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_COMMA); $identificationVariables[] = $this->SubselectIdentificationVariableDeclaration(); } return new \MailPoetVendor\Doctrine\ORM\Query\AST\SubselectFromClause($identificationVariables); } public function WhereClause() { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_WHERE); return new \MailPoetVendor\Doctrine\ORM\Query\AST\WhereClause($this->ConditionalExpression()); } public function HavingClause() { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_HAVING); return new \MailPoetVendor\Doctrine\ORM\Query\AST\HavingClause($this->ConditionalExpression()); } public function GroupByClause() { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_GROUP); $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_BY); $groupByItems = array($this->GroupByItem()); while ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_COMMA)) { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_COMMA); $groupByItems[] = $this->GroupByItem(); } return new \MailPoetVendor\Doctrine\ORM\Query\AST\GroupByClause($groupByItems); } public function OrderByClause() { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_ORDER); $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_BY); $orderByItems = array(); $orderByItems[] = $this->OrderByItem(); while ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_COMMA)) { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_COMMA); $orderByItems[] = $this->OrderByItem(); } return new \MailPoetVendor\Doctrine\ORM\Query\AST\OrderByClause($orderByItems); } public function Subselect() { $this->nestingLevel++; $subselect = new \MailPoetVendor\Doctrine\ORM\Query\AST\Subselect($this->SimpleSelectClause(), $this->SubselectFromClause()); $subselect->whereClause = $this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_WHERE) ? $this->WhereClause() : null; $subselect->groupByClause = $this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_GROUP) ? $this->GroupByClause() : null; $subselect->havingClause = $this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_HAVING) ? $this->HavingClause() : null; $subselect->orderByClause = $this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_ORDER) ? $this->OrderByClause() : null; $this->nestingLevel--; return $subselect; } public function UpdateItem() { $pathExpr = $this->SingleValuedPathExpression(); $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_EQUALS); $updateItem = new \MailPoetVendor\Doctrine\ORM\Query\AST\UpdateItem($pathExpr, $this->NewValue()); return $updateItem; } public function GroupByItem() { $glimpse = $this->lexer->glimpse(); if ($glimpse !== null && $glimpse['type'] === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_DOT) { return $this->SingleValuedPathExpression(); } $lookaheadValue = $this->lexer->lookahead['value']; if (!isset($this->queryComponents[$lookaheadValue])) { $this->semanticalError('Cannot group by undefined identification or result variable.'); } return isset($this->queryComponents[$lookaheadValue]['metadata']) ? $this->IdentificationVariable() : $this->ResultVariable(); } public function OrderByItem() { $this->lexer->peek(); $this->lexer->peek(); $peek = $this->lexer->peek(); $this->lexer->resetPeek(); $glimpse = $this->lexer->glimpse(); switch (\true) { case $this->isFunction($peek): $expr = $this->FunctionDeclaration(); break; case $this->isMathOperator($peek): $expr = $this->SimpleArithmeticExpression(); break; case $glimpse !== null && $glimpse['type'] === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_DOT: $expr = $this->SingleValuedPathExpression(); break; case $this->lexer->peek() && $this->isMathOperator($this->peekBeyondClosingParenthesis()): $expr = $this->ScalarExpression(); break; default: $expr = $this->ResultVariable(); break; } $type = 'ASC'; $item = new \MailPoetVendor\Doctrine\ORM\Query\AST\OrderByItem($expr); switch (\true) { case $this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_DESC): $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_DESC); $type = 'DESC'; break; case $this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_ASC): $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_ASC); break; default: } $item->type = $type; return $item; } public function NewValue() { if ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_NULL)) { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_NULL); return null; } if ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_INPUT_PARAMETER)) { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_INPUT_PARAMETER); return new \MailPoetVendor\Doctrine\ORM\Query\AST\InputParameter($this->lexer->token['value']); } return $this->ArithmeticExpression(); } public function IdentificationVariableDeclaration() { $joins = array(); $rangeVariableDeclaration = $this->RangeVariableDeclaration(); $indexBy = $this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_INDEX) ? $this->IndexBy() : null; $rangeVariableDeclaration->isRoot = \true; while ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_LEFT) || $this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_INNER) || $this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_JOIN)) { $joins[] = $this->Join(); } return new \MailPoetVendor\Doctrine\ORM\Query\AST\IdentificationVariableDeclaration($rangeVariableDeclaration, $indexBy, $joins); } public function SubselectIdentificationVariableDeclaration() { return $this->IdentificationVariableDeclaration(); } public function Join() { $joinType = \MailPoetVendor\Doctrine\ORM\Query\AST\Join::JOIN_TYPE_INNER; switch (\true) { case $this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_LEFT): $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_LEFT); $joinType = \MailPoetVendor\Doctrine\ORM\Query\AST\Join::JOIN_TYPE_LEFT; if ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_OUTER)) { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_OUTER); $joinType = \MailPoetVendor\Doctrine\ORM\Query\AST\Join::JOIN_TYPE_LEFTOUTER; } break; case $this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_INNER): $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_INNER); break; default: } $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_JOIN); $next = $this->lexer->glimpse(); $joinDeclaration = $next['type'] === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_DOT ? $this->JoinAssociationDeclaration() : $this->RangeVariableDeclaration(); $adhocConditions = $this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_WITH); $join = new \MailPoetVendor\Doctrine\ORM\Query\AST\Join($joinType, $joinDeclaration); if ($joinDeclaration instanceof \MailPoetVendor\Doctrine\ORM\Query\AST\RangeVariableDeclaration) { $joinDeclaration->isRoot = \false; $adhocConditions = \true; } if ($adhocConditions) { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_WITH); $join->conditionalExpression = $this->ConditionalExpression(); } return $join; } public function RangeVariableDeclaration() { $abstractSchemaName = $this->AbstractSchemaName(); if ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_AS)) { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_AS); } $token = $this->lexer->lookahead; $aliasIdentificationVariable = $this->AliasIdentificationVariable(); $classMetadata = $this->em->getClassMetadata($abstractSchemaName); $queryComponent = array('metadata' => $classMetadata, 'parent' => null, 'relation' => null, 'map' => null, 'nestingLevel' => $this->nestingLevel, 'token' => $token); $this->queryComponents[$aliasIdentificationVariable] = $queryComponent; return new \MailPoetVendor\Doctrine\ORM\Query\AST\RangeVariableDeclaration($abstractSchemaName, $aliasIdentificationVariable); } public function JoinAssociationDeclaration() { $joinAssociationPathExpression = $this->JoinAssociationPathExpression(); if ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_AS)) { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_AS); } $aliasIdentificationVariable = $this->AliasIdentificationVariable(); $indexBy = $this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_INDEX) ? $this->IndexBy() : null; $identificationVariable = $joinAssociationPathExpression->identificationVariable; $field = $joinAssociationPathExpression->associationField; $class = $this->queryComponents[$identificationVariable]['metadata']; $targetClass = $this->em->getClassMetadata($class->associationMappings[$field]['targetEntity']); $joinQueryComponent = array('metadata' => $targetClass, 'parent' => $joinAssociationPathExpression->identificationVariable, 'relation' => $class->getAssociationMapping($field), 'map' => null, 'nestingLevel' => $this->nestingLevel, 'token' => $this->lexer->lookahead); $this->queryComponents[$aliasIdentificationVariable] = $joinQueryComponent; return new \MailPoetVendor\Doctrine\ORM\Query\AST\JoinAssociationDeclaration($joinAssociationPathExpression, $aliasIdentificationVariable, $indexBy); } public function PartialObjectExpression() { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_PARTIAL); $partialFieldSet = array(); $identificationVariable = $this->IdentificationVariable(); $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_DOT); $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_OPEN_CURLY_BRACE); $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_IDENTIFIER); $partialFieldSet[] = $this->lexer->token['value']; while ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_COMMA)) { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_COMMA); $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_IDENTIFIER); $field = $this->lexer->token['value']; while ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_DOT)) { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_DOT); $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_IDENTIFIER); $field .= '.' . $this->lexer->token['value']; } $partialFieldSet[] = $field; } $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_CLOSE_CURLY_BRACE); $partialObjectExpression = new \MailPoetVendor\Doctrine\ORM\Query\AST\PartialObjectExpression($identificationVariable, $partialFieldSet); $this->deferredPartialObjectExpressions[] = array('expression' => $partialObjectExpression, 'nestingLevel' => $this->nestingLevel, 'token' => $this->lexer->token); return $partialObjectExpression; } public function NewObjectExpression() { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_NEW); $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_IDENTIFIER); $token = $this->lexer->token; $className = $token['value']; if (\strrpos($className, ':') !== \false) { list($namespaceAlias, $simpleClassName) = \explode(':', $className); $className = $this->em->getConfiguration()->getEntityNamespace($namespaceAlias) . '\\' . $simpleClassName; } $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_OPEN_PARENTHESIS); $args[] = $this->NewObjectArg(); while ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_COMMA)) { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_COMMA); $args[] = $this->NewObjectArg(); } $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_CLOSE_PARENTHESIS); $expression = new \MailPoetVendor\Doctrine\ORM\Query\AST\NewObjectExpression($className, $args); $this->deferredNewObjectExpressions[] = array('token' => $token, 'expression' => $expression, 'nestingLevel' => $this->nestingLevel); return $expression; } public function NewObjectArg() { $token = $this->lexer->lookahead; $peek = $this->lexer->glimpse(); if ($token['type'] === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_OPEN_PARENTHESIS && $peek['type'] === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_SELECT) { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_OPEN_PARENTHESIS); $expression = $this->Subselect(); $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_CLOSE_PARENTHESIS); return $expression; } return $this->ScalarExpression(); } public function IndexBy() { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_INDEX); $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_BY); $pathExpr = $this->StateFieldPathExpression(); $this->queryComponents[$pathExpr->identificationVariable]['map'] = $pathExpr->field; return new \MailPoetVendor\Doctrine\ORM\Query\AST\IndexBy($pathExpr); } public function ScalarExpression() { $lookahead = $this->lexer->lookahead['type']; $peek = $this->lexer->glimpse(); switch (\true) { case $lookahead === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_INTEGER: case $lookahead === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_FLOAT: case $lookahead === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_MINUS: case $lookahead === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_PLUS: return $this->SimpleArithmeticExpression(); case $lookahead === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_STRING: return $this->StringPrimary(); case $lookahead === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_TRUE: case $lookahead === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_FALSE: $this->match($lookahead); return new \MailPoetVendor\Doctrine\ORM\Query\AST\Literal(\MailPoetVendor\Doctrine\ORM\Query\AST\Literal::BOOLEAN, $this->lexer->token['value']); case $lookahead === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_INPUT_PARAMETER: switch (\true) { case $this->isMathOperator($peek): return $this->SimpleArithmeticExpression(); default: return $this->InputParameter(); } case $lookahead === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_CASE: case $lookahead === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_COALESCE: case $lookahead === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_NULLIF: return $this->CaseExpression(); case $lookahead === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_OPEN_PARENTHESIS: return $this->SimpleArithmeticExpression(); case $this->isFunction(): $this->lexer->peek(); switch (\true) { case $this->isMathOperator($this->peekBeyondClosingParenthesis()): return $this->SimpleArithmeticExpression(); case $this->isAggregateFunction($this->lexer->lookahead['type']): return $this->AggregateExpression(); default: return $this->FunctionDeclaration(); } break; case $lookahead === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_IDENTIFIER: $this->lexer->peek(); $this->lexer->peek(); $peek = $this->lexer->peek(); $this->lexer->resetPeek(); if ($this->isMathOperator($peek)) { return $this->SimpleArithmeticExpression(); } return $this->StateFieldPathExpression(); default: $this->syntaxError(); } } public function CaseExpression() { $lookahead = $this->lexer->lookahead['type']; switch ($lookahead) { case \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_NULLIF: return $this->NullIfExpression(); case \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_COALESCE: return $this->CoalesceExpression(); case \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_CASE: $this->lexer->resetPeek(); $peek = $this->lexer->peek(); if ($peek['type'] === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_WHEN) { return $this->GeneralCaseExpression(); } return $this->SimpleCaseExpression(); default: break; } $this->syntaxError(); } public function CoalesceExpression() { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_COALESCE); $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_OPEN_PARENTHESIS); $scalarExpressions = array(); $scalarExpressions[] = $this->ScalarExpression(); while ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_COMMA)) { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_COMMA); $scalarExpressions[] = $this->ScalarExpression(); } $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_CLOSE_PARENTHESIS); return new \MailPoetVendor\Doctrine\ORM\Query\AST\CoalesceExpression($scalarExpressions); } public function NullIfExpression() { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_NULLIF); $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_OPEN_PARENTHESIS); $firstExpression = $this->ScalarExpression(); $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_COMMA); $secondExpression = $this->ScalarExpression(); $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_CLOSE_PARENTHESIS); return new \MailPoetVendor\Doctrine\ORM\Query\AST\NullIfExpression($firstExpression, $secondExpression); } public function GeneralCaseExpression() { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_CASE); $whenClauses = array(); do { $whenClauses[] = $this->WhenClause(); } while ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_WHEN)); $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_ELSE); $scalarExpression = $this->ScalarExpression(); $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_END); return new \MailPoetVendor\Doctrine\ORM\Query\AST\GeneralCaseExpression($whenClauses, $scalarExpression); } public function SimpleCaseExpression() { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_CASE); $caseOperand = $this->StateFieldPathExpression(); $simpleWhenClauses = array(); do { $simpleWhenClauses[] = $this->SimpleWhenClause(); } while ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_WHEN)); $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_ELSE); $scalarExpression = $this->ScalarExpression(); $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_END); return new \MailPoetVendor\Doctrine\ORM\Query\AST\SimpleCaseExpression($caseOperand, $simpleWhenClauses, $scalarExpression); } public function WhenClause() { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_WHEN); $conditionalExpression = $this->ConditionalExpression(); $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_THEN); return new \MailPoetVendor\Doctrine\ORM\Query\AST\WhenClause($conditionalExpression, $this->ScalarExpression()); } public function SimpleWhenClause() { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_WHEN); $conditionalExpression = $this->ScalarExpression(); $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_THEN); return new \MailPoetVendor\Doctrine\ORM\Query\AST\SimpleWhenClause($conditionalExpression, $this->ScalarExpression()); } public function SelectExpression() { $expression = null; $identVariable = null; $peek = $this->lexer->glimpse(); $lookaheadType = $this->lexer->lookahead['type']; switch (\true) { case $lookaheadType === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_IDENTIFIER && $peek['type'] === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_DOT: $expression = $this->ScalarExpression(); break; case $lookaheadType === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_IDENTIFIER && $peek['type'] !== \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_OPEN_PARENTHESIS: $expression = $identVariable = $this->IdentificationVariable(); break; case $lookaheadType === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_CASE: case $lookaheadType === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_COALESCE: case $lookaheadType === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_NULLIF: $expression = $this->CaseExpression(); break; case $this->isFunction(): $this->lexer->peek(); switch (\true) { case $this->isMathOperator($this->peekBeyondClosingParenthesis()): $expression = $this->ScalarExpression(); break; case $this->isAggregateFunction($lookaheadType): $expression = $this->AggregateExpression(); break; default: $expression = $this->FunctionDeclaration(); break; } break; case $lookaheadType === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_PARTIAL: $expression = $this->PartialObjectExpression(); $identVariable = $expression->identificationVariable; break; case $lookaheadType === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_OPEN_PARENTHESIS && $peek['type'] === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_SELECT: $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_OPEN_PARENTHESIS); $expression = $this->Subselect(); $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_CLOSE_PARENTHESIS); break; case $lookaheadType === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_OPEN_PARENTHESIS: case $lookaheadType === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_INTEGER: case $lookaheadType === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_STRING: case $lookaheadType === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_FLOAT: case $lookaheadType === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_MINUS: case $lookaheadType === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_PLUS: $expression = $this->SimpleArithmeticExpression(); break; case $lookaheadType === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_NEW: $expression = $this->NewObjectExpression(); break; default: $this->syntaxError('IdentificationVariable | ScalarExpression | AggregateExpression | FunctionDeclaration | PartialObjectExpression | "(" Subselect ")" | CaseExpression', $this->lexer->lookahead); } if ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_AS)) { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_AS); } $hiddenAliasResultVariable = \false; if ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_HIDDEN)) { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_HIDDEN); $hiddenAliasResultVariable = \true; } $aliasResultVariable = null; if ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_IDENTIFIER)) { $token = $this->lexer->lookahead; $aliasResultVariable = $this->AliasResultVariable(); $this->queryComponents[$aliasResultVariable] = array('resultVariable' => $expression, 'nestingLevel' => $this->nestingLevel, 'token' => $token); } $expr = new \MailPoetVendor\Doctrine\ORM\Query\AST\SelectExpression($expression, $aliasResultVariable, $hiddenAliasResultVariable); if ($identVariable) { $this->identVariableExpressions[$identVariable] = $expr; } return $expr; } public function SimpleSelectExpression() { $peek = $this->lexer->glimpse(); switch ($this->lexer->lookahead['type']) { case \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_IDENTIFIER: switch (\true) { case $peek['type'] === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_DOT: $expression = $this->StateFieldPathExpression(); return new \MailPoetVendor\Doctrine\ORM\Query\AST\SimpleSelectExpression($expression); case $peek['type'] !== \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_OPEN_PARENTHESIS: $expression = $this->IdentificationVariable(); return new \MailPoetVendor\Doctrine\ORM\Query\AST\SimpleSelectExpression($expression); case $this->isFunction(): if ($this->isMathOperator($this->peekBeyondClosingParenthesis())) { return new \MailPoetVendor\Doctrine\ORM\Query\AST\SimpleSelectExpression($this->ScalarExpression()); } if ($this->isAggregateFunction($this->lexer->lookahead['type'])) { return new \MailPoetVendor\Doctrine\ORM\Query\AST\SimpleSelectExpression($this->AggregateExpression()); } return new \MailPoetVendor\Doctrine\ORM\Query\AST\SimpleSelectExpression($this->FunctionDeclaration()); default: } break; case \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_OPEN_PARENTHESIS: if ($peek['type'] !== \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_SELECT) { $expression = $this->SimpleArithmeticExpression(); return new \MailPoetVendor\Doctrine\ORM\Query\AST\SimpleSelectExpression($expression); } $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_OPEN_PARENTHESIS); $expression = $this->Subselect(); $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_CLOSE_PARENTHESIS); return new \MailPoetVendor\Doctrine\ORM\Query\AST\SimpleSelectExpression($expression); default: } $this->lexer->peek(); $expression = $this->ScalarExpression(); $expr = new \MailPoetVendor\Doctrine\ORM\Query\AST\SimpleSelectExpression($expression); if ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_AS)) { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_AS); } if ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_IDENTIFIER)) { $token = $this->lexer->lookahead; $resultVariable = $this->AliasResultVariable(); $expr->fieldIdentificationVariable = $resultVariable; $this->queryComponents[$resultVariable] = array('resultvariable' => $expr, 'nestingLevel' => $this->nestingLevel, 'token' => $token); } return $expr; } public function ConditionalExpression() { $conditionalTerms = array(); $conditionalTerms[] = $this->ConditionalTerm(); while ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_OR)) { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_OR); $conditionalTerms[] = $this->ConditionalTerm(); } if (\count($conditionalTerms) == 1) { return $conditionalTerms[0]; } return new \MailPoetVendor\Doctrine\ORM\Query\AST\ConditionalExpression($conditionalTerms); } public function ConditionalTerm() { $conditionalFactors = array(); $conditionalFactors[] = $this->ConditionalFactor(); while ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_AND)) { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_AND); $conditionalFactors[] = $this->ConditionalFactor(); } if (\count($conditionalFactors) == 1) { return $conditionalFactors[0]; } return new \MailPoetVendor\Doctrine\ORM\Query\AST\ConditionalTerm($conditionalFactors); } public function ConditionalFactor() { $not = \false; if ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_NOT)) { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_NOT); $not = \true; } $conditionalPrimary = $this->ConditionalPrimary(); if (!$not) { return $conditionalPrimary; } $conditionalFactor = new \MailPoetVendor\Doctrine\ORM\Query\AST\ConditionalFactor($conditionalPrimary); $conditionalFactor->not = $not; return $conditionalFactor; } public function ConditionalPrimary() { $condPrimary = new \MailPoetVendor\Doctrine\ORM\Query\AST\ConditionalPrimary(); if (!$this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_OPEN_PARENTHESIS)) { $condPrimary->simpleConditionalExpression = $this->SimpleConditionalExpression(); return $condPrimary; } $peek = $this->peekBeyondClosingParenthesis(); if ($peek !== null && ( \in_array($peek['value'], array("=", "<", "<=", "<>", ">", ">=", "!=")) || \in_array($peek['type'], array(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_NOT, \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_BETWEEN, \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_LIKE, \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_IN, \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_IS, \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_EXISTS)) || $this->isMathOperator($peek))) { $condPrimary->simpleConditionalExpression = $this->SimpleConditionalExpression(); return $condPrimary; } $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_OPEN_PARENTHESIS); $condPrimary->conditionalExpression = $this->ConditionalExpression(); $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_CLOSE_PARENTHESIS); return $condPrimary; } public function SimpleConditionalExpression() { if ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_EXISTS)) { return $this->ExistsExpression(); } $token = $this->lexer->lookahead; $peek = $this->lexer->glimpse(); $lookahead = $token; if ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_NOT)) { $token = $this->lexer->glimpse(); } if ($token['type'] === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_IDENTIFIER || $token['type'] === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_INPUT_PARAMETER || $this->isFunction()) { $beyond = $this->lexer->peek(); switch ($peek['value']) { case '(': $token = $this->peekBeyondClosingParenthesis(\false); if ($token['type'] === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_NOT) { $token = $this->lexer->peek(); } if ($token['type'] === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_IS) { $lookahead = $this->lexer->peek(); } break; default: $token = $beyond; while ($token['value'] === '.') { $this->lexer->peek(); $token = $this->lexer->peek(); } if ($token['type'] === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_NOT) { $token = $this->lexer->peek(); } $lookahead = $this->lexer->peek(); } if ($lookahead['type'] === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_NOT) { $lookahead = $this->lexer->peek(); } $this->lexer->resetPeek(); } if ($token['type'] === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_BETWEEN) { return $this->BetweenExpression(); } if ($token['type'] === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_LIKE) { return $this->LikeExpression(); } if ($token['type'] === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_IN) { return $this->InExpression(); } if ($token['type'] === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_INSTANCE) { return $this->InstanceOfExpression(); } if ($token['type'] === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_MEMBER) { return $this->CollectionMemberExpression(); } if ($token['type'] === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_IS && $lookahead['type'] === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_NULL) { return $this->NullComparisonExpression(); } if ($token['type'] === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_IS && $lookahead['type'] === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_EMPTY) { return $this->EmptyCollectionComparisonExpression(); } return $this->ComparisonExpression(); } public function EmptyCollectionComparisonExpression() { $emptyCollectionCompExpr = new \MailPoetVendor\Doctrine\ORM\Query\AST\EmptyCollectionComparisonExpression($this->CollectionValuedPathExpression()); $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_IS); if ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_NOT)) { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_NOT); $emptyCollectionCompExpr->not = \true; } $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_EMPTY); return $emptyCollectionCompExpr; } public function CollectionMemberExpression() { $not = \false; $entityExpr = $this->EntityExpression(); if ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_NOT)) { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_NOT); $not = \true; } $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_MEMBER); if ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_OF)) { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_OF); } $collMemberExpr = new \MailPoetVendor\Doctrine\ORM\Query\AST\CollectionMemberExpression($entityExpr, $this->CollectionValuedPathExpression()); $collMemberExpr->not = $not; return $collMemberExpr; } public function Literal() { switch ($this->lexer->lookahead['type']) { case \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_STRING: $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_STRING); return new \MailPoetVendor\Doctrine\ORM\Query\AST\Literal(\MailPoetVendor\Doctrine\ORM\Query\AST\Literal::STRING, $this->lexer->token['value']); case \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_INTEGER: case \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_FLOAT: $this->match($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_INTEGER) ? \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_INTEGER : \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_FLOAT); return new \MailPoetVendor\Doctrine\ORM\Query\AST\Literal(\MailPoetVendor\Doctrine\ORM\Query\AST\Literal::NUMERIC, $this->lexer->token['value']); case \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_TRUE: case \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_FALSE: $this->match($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_TRUE) ? \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_TRUE : \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_FALSE); return new \MailPoetVendor\Doctrine\ORM\Query\AST\Literal(\MailPoetVendor\Doctrine\ORM\Query\AST\Literal::BOOLEAN, $this->lexer->token['value']); default: $this->syntaxError('Literal'); } } public function InParameter() { if ($this->lexer->lookahead['type'] == \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_INPUT_PARAMETER) { return $this->InputParameter(); } return $this->Literal(); } public function InputParameter() { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_INPUT_PARAMETER); return new \MailPoetVendor\Doctrine\ORM\Query\AST\InputParameter($this->lexer->token['value']); } public function ArithmeticExpression() { $expr = new \MailPoetVendor\Doctrine\ORM\Query\AST\ArithmeticExpression(); if ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_OPEN_PARENTHESIS)) { $peek = $this->lexer->glimpse(); if ($peek['type'] === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_SELECT) { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_OPEN_PARENTHESIS); $expr->subselect = $this->Subselect(); $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_CLOSE_PARENTHESIS); return $expr; } } $expr->simpleArithmeticExpression = $this->SimpleArithmeticExpression(); return $expr; } public function SimpleArithmeticExpression() { $terms = array(); $terms[] = $this->ArithmeticTerm(); while (($isPlus = $this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_PLUS)) || $this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_MINUS)) { $this->match($isPlus ? \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_PLUS : \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_MINUS); $terms[] = $this->lexer->token['value']; $terms[] = $this->ArithmeticTerm(); } if (\count($terms) == 1) { return $terms[0]; } return new \MailPoetVendor\Doctrine\ORM\Query\AST\SimpleArithmeticExpression($terms); } public function ArithmeticTerm() { $factors = array(); $factors[] = $this->ArithmeticFactor(); while (($isMult = $this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_MULTIPLY)) || $this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_DIVIDE)) { $this->match($isMult ? \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_MULTIPLY : \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_DIVIDE); $factors[] = $this->lexer->token['value']; $factors[] = $this->ArithmeticFactor(); } if (\count($factors) == 1) { return $factors[0]; } return new \MailPoetVendor\Doctrine\ORM\Query\AST\ArithmeticTerm($factors); } public function ArithmeticFactor() { $sign = null; if (($isPlus = $this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_PLUS)) || $this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_MINUS)) { $this->match($isPlus ? \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_PLUS : \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_MINUS); $sign = $isPlus; } $primary = $this->ArithmeticPrimary(); if ($sign === null) { return $primary; } return new \MailPoetVendor\Doctrine\ORM\Query\AST\ArithmeticFactor($primary, $sign); } public function ArithmeticPrimary() { if ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_OPEN_PARENTHESIS)) { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_OPEN_PARENTHESIS); $expr = $this->SimpleArithmeticExpression(); $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_CLOSE_PARENTHESIS); return new \MailPoetVendor\Doctrine\ORM\Query\AST\ParenthesisExpression($expr); } switch ($this->lexer->lookahead['type']) { case \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_COALESCE: case \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_NULLIF: case \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_CASE: return $this->CaseExpression(); case \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_IDENTIFIER: $peek = $this->lexer->glimpse(); if ($peek !== null && $peek['value'] == '(') { return $this->FunctionDeclaration(); } if ($peek !== null && $peek['value'] == '.') { return $this->SingleValuedPathExpression(); } if (isset($this->queryComponents[$this->lexer->lookahead['value']]['resultVariable'])) { return $this->ResultVariable(); } return $this->StateFieldPathExpression(); case \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_INPUT_PARAMETER: return $this->InputParameter(); default: $peek = $this->lexer->glimpse(); if ($peek !== null && $peek['value'] == '(') { if ($this->isAggregateFunction($this->lexer->lookahead['type'])) { return $this->AggregateExpression(); } return $this->FunctionDeclaration(); } return $this->Literal(); } } public function StringExpression() { $peek = $this->lexer->glimpse(); if ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_OPEN_PARENTHESIS) && $peek['type'] === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_SELECT) { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_OPEN_PARENTHESIS); $expr = $this->Subselect(); $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_CLOSE_PARENTHESIS); return $expr; } if ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_IDENTIFIER) && isset($this->queryComponents[$this->lexer->lookahead['value']]['resultVariable'])) { return $this->ResultVariable(); } return $this->StringPrimary(); } public function StringPrimary() { $lookaheadType = $this->lexer->lookahead['type']; switch ($lookaheadType) { case \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_IDENTIFIER: $peek = $this->lexer->glimpse(); if ($peek['value'] == '.') { return $this->StateFieldPathExpression(); } if ($peek['value'] == '(') { return $this->FunctionDeclaration(); } $this->syntaxError("'.' or '('"); break; case \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_STRING: $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_STRING); return new \MailPoetVendor\Doctrine\ORM\Query\AST\Literal(\MailPoetVendor\Doctrine\ORM\Query\AST\Literal::STRING, $this->lexer->token['value']); case \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_INPUT_PARAMETER: return $this->InputParameter(); case \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_CASE: case \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_COALESCE: case \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_NULLIF: return $this->CaseExpression(); default: if ($this->isAggregateFunction($lookaheadType)) { return $this->AggregateExpression(); } } $this->syntaxError('StateFieldPathExpression | string | InputParameter | FunctionsReturningStrings | AggregateExpression'); } public function EntityExpression() { $glimpse = $this->lexer->glimpse(); if ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_IDENTIFIER) && $glimpse['value'] === '.') { return $this->SingleValuedAssociationPathExpression(); } return $this->SimpleEntityExpression(); } public function SimpleEntityExpression() { if ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_INPUT_PARAMETER)) { return $this->InputParameter(); } return $this->StateFieldPathExpression(); } public function AggregateExpression() { $lookaheadType = $this->lexer->lookahead['type']; $isDistinct = \false; if (!\in_array($lookaheadType, array(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_COUNT, \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_AVG, \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_MAX, \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_MIN, \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_SUM))) { $this->syntaxError('One of: MAX, MIN, AVG, SUM, COUNT'); } $this->match($lookaheadType); $functionName = $this->lexer->token['value']; $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_OPEN_PARENTHESIS); if ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_DISTINCT)) { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_DISTINCT); $isDistinct = \true; } $pathExp = $this->SimpleArithmeticExpression(); $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_CLOSE_PARENTHESIS); return new \MailPoetVendor\Doctrine\ORM\Query\AST\AggregateExpression($functionName, $pathExp, $isDistinct); } public function QuantifiedExpression() { $lookaheadType = $this->lexer->lookahead['type']; $value = $this->lexer->lookahead['value']; if (!\in_array($lookaheadType, array(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_ALL, \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_ANY, \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_SOME))) { $this->syntaxError('ALL, ANY or SOME'); } $this->match($lookaheadType); $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_OPEN_PARENTHESIS); $qExpr = new \MailPoetVendor\Doctrine\ORM\Query\AST\QuantifiedExpression($this->Subselect()); $qExpr->type = $value; $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_CLOSE_PARENTHESIS); return $qExpr; } public function BetweenExpression() { $not = \false; $arithExpr1 = $this->ArithmeticExpression(); if ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_NOT)) { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_NOT); $not = \true; } $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_BETWEEN); $arithExpr2 = $this->ArithmeticExpression(); $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_AND); $arithExpr3 = $this->ArithmeticExpression(); $betweenExpr = new \MailPoetVendor\Doctrine\ORM\Query\AST\BetweenExpression($arithExpr1, $arithExpr2, $arithExpr3); $betweenExpr->not = $not; return $betweenExpr; } public function ComparisonExpression() { $this->lexer->glimpse(); $leftExpr = $this->ArithmeticExpression(); $operator = $this->ComparisonOperator(); $rightExpr = $this->isNextAllAnySome() ? $this->QuantifiedExpression() : $this->ArithmeticExpression(); return new \MailPoetVendor\Doctrine\ORM\Query\AST\ComparisonExpression($leftExpr, $operator, $rightExpr); } public function InExpression() { $inExpression = new \MailPoetVendor\Doctrine\ORM\Query\AST\InExpression($this->ArithmeticExpression()); if ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_NOT)) { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_NOT); $inExpression->not = \true; } $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_IN); $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_OPEN_PARENTHESIS); if ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_SELECT)) { $inExpression->subselect = $this->Subselect(); } else { $literals = array(); $literals[] = $this->InParameter(); while ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_COMMA)) { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_COMMA); $literals[] = $this->InParameter(); } $inExpression->literals = $literals; } $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_CLOSE_PARENTHESIS); return $inExpression; } public function InstanceOfExpression() { $instanceOfExpression = new \MailPoetVendor\Doctrine\ORM\Query\AST\InstanceOfExpression($this->IdentificationVariable()); if ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_NOT)) { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_NOT); $instanceOfExpression->not = \true; } $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_INSTANCE); $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_OF); $exprValues = array(); if ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_OPEN_PARENTHESIS)) { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_OPEN_PARENTHESIS); $exprValues[] = $this->InstanceOfParameter(); while ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_COMMA)) { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_COMMA); $exprValues[] = $this->InstanceOfParameter(); } $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_CLOSE_PARENTHESIS); $instanceOfExpression->value = $exprValues; return $instanceOfExpression; } $exprValues[] = $this->InstanceOfParameter(); $instanceOfExpression->value = $exprValues; return $instanceOfExpression; } public function InstanceOfParameter() { if ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_INPUT_PARAMETER)) { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_INPUT_PARAMETER); return new \MailPoetVendor\Doctrine\ORM\Query\AST\InputParameter($this->lexer->token['value']); } return $this->AliasIdentificationVariable(); } public function LikeExpression() { $stringExpr = $this->StringExpression(); $not = \false; if ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_NOT)) { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_NOT); $not = \true; } $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_LIKE); if ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_INPUT_PARAMETER)) { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_INPUT_PARAMETER); $stringPattern = new \MailPoetVendor\Doctrine\ORM\Query\AST\InputParameter($this->lexer->token['value']); } else { $stringPattern = $this->StringPrimary(); } $escapeChar = null; if ($this->lexer->lookahead !== null && $this->lexer->lookahead['type'] === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_ESCAPE) { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_ESCAPE); $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_STRING); $escapeChar = new \MailPoetVendor\Doctrine\ORM\Query\AST\Literal(\MailPoetVendor\Doctrine\ORM\Query\AST\Literal::STRING, $this->lexer->token['value']); } $likeExpr = new \MailPoetVendor\Doctrine\ORM\Query\AST\LikeExpression($stringExpr, $stringPattern, $escapeChar); $likeExpr->not = $not; return $likeExpr; } public function NullComparisonExpression() { switch (\true) { case $this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_INPUT_PARAMETER): $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_INPUT_PARAMETER); $expr = new \MailPoetVendor\Doctrine\ORM\Query\AST\InputParameter($this->lexer->token['value']); break; case $this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_NULLIF): $expr = $this->NullIfExpression(); break; case $this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_COALESCE): $expr = $this->CoalesceExpression(); break; case $this->isAggregateFunction($this->lexer->lookahead['type']): $expr = $this->AggregateExpression(); break; case $this->isFunction(): $expr = $this->FunctionDeclaration(); break; default: $glimpse = $this->lexer->glimpse(); if ($glimpse['type'] === \MailPoetVendor\Doctrine\ORM\Query\Lexer::T_DOT) { $expr = $this->SingleValuedPathExpression(); break; } $lookaheadValue = $this->lexer->lookahead['value']; if (!isset($this->queryComponents[$lookaheadValue])) { $this->semanticalError('Cannot add having condition on undefined result variable.'); } if (!isset($this->queryComponents[$lookaheadValue]['resultVariable'])) { $this->semanticalError('Cannot add having condition on a non result variable.'); } $expr = $this->ResultVariable(); break; } $nullCompExpr = new \MailPoetVendor\Doctrine\ORM\Query\AST\NullComparisonExpression($expr); $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_IS); if ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_NOT)) { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_NOT); $nullCompExpr->not = \true; } $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_NULL); return $nullCompExpr; } public function ExistsExpression() { $not = \false; if ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_NOT)) { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_NOT); $not = \true; } $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_EXISTS); $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_OPEN_PARENTHESIS); $existsExpression = new \MailPoetVendor\Doctrine\ORM\Query\AST\ExistsExpression($this->Subselect()); $existsExpression->not = $not; $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_CLOSE_PARENTHESIS); return $existsExpression; } public function ComparisonOperator() { switch ($this->lexer->lookahead['value']) { case '=': $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_EQUALS); return '='; case '<': $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_LOWER_THAN); $operator = '<'; if ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_EQUALS)) { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_EQUALS); $operator .= '='; } else { if ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_GREATER_THAN)) { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_GREATER_THAN); $operator .= '>'; } } return $operator; case '>': $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_GREATER_THAN); $operator = '>'; if ($this->lexer->isNextToken(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_EQUALS)) { $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_EQUALS); $operator .= '='; } return $operator; case '!': $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_NEGATE); $this->match(\MailPoetVendor\Doctrine\ORM\Query\Lexer::T_EQUALS); return '<>'; default: $this->syntaxError('=, <, <=, <>, >, >=, !='); } } public function FunctionDeclaration() { $token = $this->lexer->lookahead; $funcName = \strtolower($token['value']); switch (\true) { case isset(self::$_STRING_FUNCTIONS[$funcName]): return $this->FunctionsReturningStrings(); case isset(self::$_NUMERIC_FUNCTIONS[$funcName]): return $this->FunctionsReturningNumerics(); case isset(self::$_DATETIME_FUNCTIONS[$funcName]): return $this->FunctionsReturningDatetime(); default: return $this->CustomFunctionDeclaration(); } } private function CustomFunctionDeclaration() { $token = $this->lexer->lookahead; $funcName = \strtolower($token['value']); $config = $this->em->getConfiguration(); switch (\true) { case $config->getCustomStringFunction($funcName) !== null: return $this->CustomFunctionsReturningStrings(); case $config->getCustomNumericFunction($funcName) !== null: return $this->CustomFunctionsReturningNumerics(); case $config->getCustomDatetimeFunction($funcName) !== null: return $this->CustomFunctionsReturningDatetime(); default: $this->syntaxError('known function', $token); } } public function FunctionsReturningNumerics() { $funcNameLower = \strtolower($this->lexer->lookahead['value']); $funcClass = self::$_NUMERIC_FUNCTIONS[$funcNameLower]; $function = new $funcClass($funcNameLower); $function->parse($this); return $function; } public function CustomFunctionsReturningNumerics() { $functionName = \strtolower($this->lexer->lookahead['value']); $functionClass = $this->em->getConfiguration()->getCustomNumericFunction($functionName); $function = \is_string($functionClass) ? new $functionClass($functionName) : \call_user_func($functionClass, $functionName); $function->parse($this); return $function; } public function FunctionsReturningDatetime() { $funcNameLower = \strtolower($this->lexer->lookahead['value']); $funcClass = self::$_DATETIME_FUNCTIONS[$funcNameLower]; $function = new $funcClass($funcNameLower); $function->parse($this); return $function; } public function CustomFunctionsReturningDatetime() { $functionName = $this->lexer->lookahead['value']; $functionClass = $this->em->getConfiguration()->getCustomDatetimeFunction($functionName); $function = \is_string($functionClass) ? new $functionClass($functionName) : \call_user_func($functionClass, $functionName); $function->parse($this); return $function; } public function FunctionsReturningStrings() { $funcNameLower = \strtolower($this->lexer->lookahead['value']); $funcClass = self::$_STRING_FUNCTIONS[$funcNameLower]; $function = new $funcClass($funcNameLower); $function->parse($this); return $function; } public function CustomFunctionsReturningStrings() { $functionName = $this->lexer->lookahead['value']; $functionClass = $this->em->getConfiguration()->getCustomStringFunction($functionName); $function = \is_string($functionClass) ? new $functionClass($functionName) : \call_user_func($functionClass, $functionName); $function->parse($this); return $function; } } 