<?php
 namespace MailPoetVendor\Doctrine\ORM\Query; if (!defined('ABSPATH')) exit; use MailPoetVendor\Doctrine\ORM\EntityManagerInterface; use MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadataInfo; class ResultSetMappingBuilder extends \MailPoetVendor\Doctrine\ORM\Query\ResultSetMapping { const COLUMN_RENAMING_NONE = 1; const COLUMN_RENAMING_CUSTOM = 2; const COLUMN_RENAMING_INCREMENT = 3; private $sqlCounter = 0; private $em; private $defaultRenameMode; public function __construct(\MailPoetVendor\Doctrine\ORM\EntityManagerInterface $em, $defaultRenameMode = self::COLUMN_RENAMING_NONE) { $this->em = $em; $this->defaultRenameMode = $defaultRenameMode; } public function addRootEntityFromClassMetadata($class, $alias, $renamedColumns = array(), $renameMode = null) { $renameMode = $renameMode ?: $this->defaultRenameMode; $columnAliasMap = $this->getColumnAliasMap($class, $renameMode, $renamedColumns); $this->addEntityResult($class, $alias); $this->addAllClassFields($class, $alias, $columnAliasMap); } public function addJoinedEntityFromClassMetadata($class, $alias, $parentAlias, $relation, $renamedColumns = array(), $renameMode = null) { $renameMode = $renameMode ?: $this->defaultRenameMode; $columnAliasMap = $this->getColumnAliasMap($class, $renameMode, $renamedColumns); $this->addJoinedEntityResult($class, $alias, $parentAlias, $relation); $this->addAllClassFields($class, $alias, $columnAliasMap); } protected function addAllClassFields($class, $alias, $columnAliasMap = array()) { $classMetadata = $this->em->getClassMetadata($class); $platform = $this->em->getConnection()->getDatabasePlatform(); if (!$this->isInheritanceSupported($classMetadata)) { throw new \InvalidArgumentException('ResultSetMapping builder does not currently support your inheritance scheme.'); } foreach ($classMetadata->getColumnNames() as $columnName) { $propertyName = $classMetadata->getFieldName($columnName); $columnAlias = $platform->getSQLResultCasing($columnAliasMap[$columnName]); if (isset($this->fieldMappings[$columnAlias])) { throw new \InvalidArgumentException("The column '{$columnName}' conflicts with another column in the mapper."); } $this->addFieldResult($alias, $columnAlias, $propertyName); } foreach ($classMetadata->associationMappings as $associationMapping) { if ($associationMapping['isOwningSide'] && $associationMapping['type'] & \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadataInfo::TO_ONE) { foreach ($associationMapping['joinColumns'] as $joinColumn) { $columnName = $joinColumn['name']; $columnAlias = $platform->getSQLResultCasing($columnAliasMap[$columnName]); if (isset($this->metaMappings[$columnAlias])) { throw new \InvalidArgumentException("The column '{$columnAlias}' conflicts with another column in the mapper."); } $this->addMetaResult($alias, $columnAlias, $columnName, isset($associationMapping['id']) && $associationMapping['id'] === \true); } } } } private function isInheritanceSupported(\MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadataInfo $classMetadata) { if ($classMetadata->isInheritanceTypeSingleTable() && \in_array($classMetadata->name, $classMetadata->discriminatorMap, \true)) { return \true; } return !($classMetadata->isInheritanceTypeSingleTable() || $classMetadata->isInheritanceTypeJoined()); } private function getColumnAlias($columnName, $mode, array $customRenameColumns) { switch ($mode) { case self::COLUMN_RENAMING_INCREMENT: return $columnName . $this->sqlCounter++; case self::COLUMN_RENAMING_CUSTOM: return isset($customRenameColumns[$columnName]) ? $customRenameColumns[$columnName] : $columnName; case self::COLUMN_RENAMING_NONE: return $columnName; } } private function getColumnAliasMap($className, $mode, array $customRenameColumns) { if ($customRenameColumns) { $mode = self::COLUMN_RENAMING_CUSTOM; } $columnAlias = array(); $class = $this->em->getClassMetadata($className); foreach ($class->getColumnNames() as $columnName) { $columnAlias[$columnName] = $this->getColumnAlias($columnName, $mode, $customRenameColumns); } foreach ($class->associationMappings as $associationMapping) { if ($associationMapping['isOwningSide'] && $associationMapping['type'] & \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadataInfo::TO_ONE) { foreach ($associationMapping['joinColumns'] as $joinColumn) { $columnName = $joinColumn['name']; $columnAlias[$columnName] = $this->getColumnAlias($columnName, $mode, $customRenameColumns); } } } return $columnAlias; } public function addNamedNativeQueryMapping(\MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadataInfo $class, array $queryMapping) { if (isset($queryMapping['resultClass'])) { return $this->addNamedNativeQueryResultClassMapping($class, $queryMapping['resultClass']); } return $this->addNamedNativeQueryResultSetMapping($class, $queryMapping['resultSetMapping']); } public function addNamedNativeQueryResultClassMapping(\MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadataInfo $class, $resultClassName) { $classMetadata = $this->em->getClassMetadata($resultClassName); $shortName = $classMetadata->reflClass->getShortName(); $alias = \strtolower($shortName[0]) . '0'; $this->addEntityResult($class->name, $alias); if ($classMetadata->discriminatorColumn) { $discriminatorColumn = $classMetadata->discriminatorColumn; $this->setDiscriminatorColumn($alias, $discriminatorColumn['name']); $this->addMetaResult($alias, $discriminatorColumn['name'], $discriminatorColumn['fieldName']); } foreach ($classMetadata->getColumnNames() as $key => $columnName) { $propertyName = $classMetadata->getFieldName($columnName); $this->addFieldResult($alias, $columnName, $propertyName); } foreach ($classMetadata->associationMappings as $associationMapping) { if ($associationMapping['isOwningSide'] && $associationMapping['type'] & \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadataInfo::TO_ONE) { foreach ($associationMapping['joinColumns'] as $joinColumn) { $columnName = $joinColumn['name']; $this->addMetaResult($alias, $columnName, $columnName, $classMetadata->isIdentifier($columnName)); } } } return $this; } public function addNamedNativeQueryResultSetMapping(\MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadataInfo $class, $resultSetMappingName) { $counter = 0; $resultMapping = $class->getSqlResultSetMapping($resultSetMappingName); $rooShortName = $class->reflClass->getShortName(); $rootAlias = \strtolower($rooShortName[0]) . $counter; if (isset($resultMapping['entities'])) { foreach ($resultMapping['entities'] as $key => $entityMapping) { $classMetadata = $this->em->getClassMetadata($entityMapping['entityClass']); if ($class->reflClass->name == $classMetadata->reflClass->name) { $this->addEntityResult($classMetadata->name, $rootAlias); $this->addNamedNativeQueryEntityResultMapping($classMetadata, $entityMapping, $rootAlias); } else { $shortName = $classMetadata->reflClass->getShortName(); $joinAlias = \strtolower($shortName[0]) . ++$counter; $associations = $class->getAssociationsByTargetClass($classMetadata->name); foreach ($associations as $relation => $mapping) { $this->addJoinedEntityResult($mapping['targetEntity'], $joinAlias, $rootAlias, $relation); $this->addNamedNativeQueryEntityResultMapping($classMetadata, $entityMapping, $joinAlias); } } } } if (isset($resultMapping['columns'])) { foreach ($resultMapping['columns'] as $entityMapping) { $this->addScalarResult($entityMapping['name'], $entityMapping['name']); } } return $this; } public function addNamedNativeQueryEntityResultMapping(\MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadataInfo $classMetadata, array $entityMapping, $alias) { if (isset($entityMapping['discriminatorColumn']) && $entityMapping['discriminatorColumn']) { $discriminatorColumn = $entityMapping['discriminatorColumn']; $this->setDiscriminatorColumn($alias, $discriminatorColumn); $this->addMetaResult($alias, $discriminatorColumn, $discriminatorColumn); } if (isset($entityMapping['fields']) && !empty($entityMapping['fields'])) { foreach ($entityMapping['fields'] as $field) { $fieldName = $field['name']; $relation = null; if (\strpos($fieldName, '.')) { list($relation, $fieldName) = \explode('.', $fieldName); } if (isset($classMetadata->associationMappings[$relation])) { if ($relation) { $associationMapping = $classMetadata->associationMappings[$relation]; $joinAlias = $alias . $relation; $parentAlias = $alias; $this->addJoinedEntityResult($associationMapping['targetEntity'], $joinAlias, $parentAlias, $relation); $this->addFieldResult($joinAlias, $field['column'], $fieldName); } else { $this->addFieldResult($alias, $field['column'], $fieldName, $classMetadata->name); } } else { if (!isset($classMetadata->fieldMappings[$fieldName])) { throw new \InvalidArgumentException("Entity '" . $classMetadata->name . "' has no field '" . $fieldName . "'. "); } $this->addFieldResult($alias, $field['column'], $fieldName, $classMetadata->name); } } } else { foreach ($classMetadata->getColumnNames() as $columnName) { $propertyName = $classMetadata->getFieldName($columnName); $this->addFieldResult($alias, $columnName, $propertyName); } } return $this; } public function generateSelectClause($tableAliases = array()) { $sql = ""; foreach ($this->columnOwnerMap as $columnName => $dqlAlias) { $tableAlias = isset($tableAliases[$dqlAlias]) ? $tableAliases[$dqlAlias] : $dqlAlias; if ($sql) { $sql .= ", "; } $sql .= $tableAlias . "."; if (isset($this->fieldMappings[$columnName])) { $class = $this->em->getClassMetadata($this->declaringClasses[$columnName]); $sql .= $class->fieldMappings[$this->fieldMappings[$columnName]]['columnName']; } else { if (isset($this->metaMappings[$columnName])) { $sql .= $this->metaMappings[$columnName]; } else { if (isset($this->discriminatorColumns[$dqlAlias])) { $sql .= $this->discriminatorColumns[$dqlAlias]; } } } $sql .= " AS " . $columnName; } return $sql; } public function __toString() { return $this->generateSelectClause(array()); } } 