<?php
 namespace MailPoetVendor\Doctrine\ORM; if (!defined('ABSPATH')) exit; use MailPoetVendor\Doctrine\Common\Collections\ArrayCollection; use MailPoetVendor\Doctrine\Common\Collections\Criteria; use MailPoetVendor\Doctrine\ORM\Query\Expr; use MailPoetVendor\Doctrine\ORM\Query\QueryExpressionVisitor; class QueryBuilder { const SELECT = 0; const DELETE = 1; const UPDATE = 2; const STATE_DIRTY = 0; const STATE_CLEAN = 1; private $_em; private $_dqlParts = array('distinct' => \false, 'select' => array(), 'from' => array(), 'join' => array(), 'set' => array(), 'where' => null, 'groupBy' => array(), 'having' => null, 'orderBy' => array()); private $_type = self::SELECT; private $_state = self::STATE_CLEAN; private $_dql; private $parameters; private $_firstResult = null; private $_maxResults = null; private $joinRootAliases = array(); protected $cacheable = \false; protected $cacheRegion; protected $cacheMode; protected $lifetime = 0; public function __construct(\MailPoetVendor\Doctrine\ORM\EntityManagerInterface $em) { $this->_em = $em; $this->parameters = new \MailPoetVendor\Doctrine\Common\Collections\ArrayCollection(); } public function expr() { return $this->_em->getExpressionBuilder(); } public function setCacheable($cacheable) { $this->cacheable = (bool) $cacheable; return $this; } public function isCacheable() { return $this->cacheable; } public function setCacheRegion($cacheRegion) { $this->cacheRegion = (string) $cacheRegion; return $this; } public function getCacheRegion() { return $this->cacheRegion; } public function getLifetime() { return $this->lifetime; } public function setLifetime($lifetime) { $this->lifetime = (int) $lifetime; return $this; } public function getCacheMode() { return $this->cacheMode; } public function setCacheMode($cacheMode) { $this->cacheMode = (int) $cacheMode; return $this; } public function getType() { return $this->_type; } public function getEntityManager() { return $this->_em; } public function getState() { return $this->_state; } public function getDQL() { if ($this->_dql !== null && $this->_state === self::STATE_CLEAN) { return $this->_dql; } switch ($this->_type) { case self::DELETE: $dql = $this->_getDQLForDelete(); break; case self::UPDATE: $dql = $this->_getDQLForUpdate(); break; case self::SELECT: default: $dql = $this->_getDQLForSelect(); break; } $this->_state = self::STATE_CLEAN; $this->_dql = $dql; return $dql; } public function getQuery() { $parameters = clone $this->parameters; $query = $this->_em->createQuery($this->getDQL())->setParameters($parameters)->setFirstResult($this->_firstResult)->setMaxResults($this->_maxResults); if ($this->lifetime) { $query->setLifetime($this->lifetime); } if ($this->cacheMode) { $query->setCacheMode($this->cacheMode); } if ($this->cacheable) { $query->setCacheable($this->cacheable); } if ($this->cacheRegion) { $query->setCacheRegion($this->cacheRegion); } return $query; } private function findRootAlias($alias, $parentAlias) { $rootAlias = null; if (\in_array($parentAlias, $this->getRootAliases())) { $rootAlias = $parentAlias; } elseif (isset($this->joinRootAliases[$parentAlias])) { $rootAlias = $this->joinRootAliases[$parentAlias]; } else { $rootAlias = $this->getRootAlias(); } $this->joinRootAliases[$alias] = $rootAlias; return $rootAlias; } public function getRootAlias() { $aliases = $this->getRootAliases(); if (!isset($aliases[0])) { throw new \RuntimeException('No alias was set before invoking getRootAlias().'); } return $aliases[0]; } public function getRootAliases() { $aliases = array(); foreach ($this->_dqlParts['from'] as &$fromClause) { if (\is_string($fromClause)) { $spacePos = \strrpos($fromClause, ' '); $from = \substr($fromClause, 0, $spacePos); $alias = \substr($fromClause, $spacePos + 1); $fromClause = new \MailPoetVendor\Doctrine\ORM\Query\Expr\From($from, $alias); } $aliases[] = $fromClause->getAlias(); } return $aliases; } public function getAllAliases() { return \array_merge($this->getRootAliases(), \array_keys($this->joinRootAliases)); } public function getRootEntities() { $entities = array(); foreach ($this->_dqlParts['from'] as &$fromClause) { if (\is_string($fromClause)) { $spacePos = \strrpos($fromClause, ' '); $from = \substr($fromClause, 0, $spacePos); $alias = \substr($fromClause, $spacePos + 1); $fromClause = new \MailPoetVendor\Doctrine\ORM\Query\Expr\From($from, $alias); } $entities[] = $fromClause->getFrom(); } return $entities; } public function setParameter($key, $value, $type = null) { $existingParameter = $this->getParameter($key); if ($existingParameter !== null) { $existingParameter->setValue($value, $type); return $this; } $this->parameters->add(new \MailPoetVendor\Doctrine\ORM\Query\Parameter($key, $value, $type)); return $this; } public function setParameters($parameters) { if (\is_array($parameters)) { $parameterCollection = new \MailPoetVendor\Doctrine\Common\Collections\ArrayCollection(); foreach ($parameters as $key => $value) { $parameter = new \MailPoetVendor\Doctrine\ORM\Query\Parameter($key, $value); $parameterCollection->add($parameter); } $parameters = $parameterCollection; } $this->parameters = $parameters; return $this; } public function getParameters() { return $this->parameters; } public function getParameter($key) { $filteredParameters = $this->parameters->filter(function (\MailPoetVendor\Doctrine\ORM\Query\Parameter $parameter) use($key) { $parameterName = $parameter->getName(); return $key === $parameterName || (string) $key === (string) $parameterName; }); return !$filteredParameters->isEmpty() ? $filteredParameters->first() : null; } public function setFirstResult($firstResult) { $this->_firstResult = $firstResult; return $this; } public function getFirstResult() { return $this->_firstResult; } public function setMaxResults($maxResults) { $this->_maxResults = $maxResults; return $this; } public function getMaxResults() { return $this->_maxResults; } public function add($dqlPartName, $dqlPart, $append = \false) { if ($append && ($dqlPartName === "where" || $dqlPartName === "having")) { throw new \InvalidArgumentException("Using \$append = true does not have an effect with 'where' or 'having' " . "parts. See QueryBuilder#andWhere() for an example for correct usage."); } $isMultiple = \is_array($this->_dqlParts[$dqlPartName]) && !($dqlPartName == 'join' && !$append); if (\is_array($dqlPart) && $dqlPartName != 'join') { $dqlPart = \reset($dqlPart); } if ($dqlPartName == 'join') { $newDqlPart = array(); foreach ($dqlPart as $k => $v) { $k = \is_numeric($k) ? $this->getRootAlias() : $k; $newDqlPart[$k] = $v; } $dqlPart = $newDqlPart; } if ($append && $isMultiple) { if (\is_array($dqlPart)) { $key = \key($dqlPart); $this->_dqlParts[$dqlPartName][$key][] = $dqlPart[$key]; } else { $this->_dqlParts[$dqlPartName][] = $dqlPart; } } else { $this->_dqlParts[$dqlPartName] = $isMultiple ? array($dqlPart) : $dqlPart; } $this->_state = self::STATE_DIRTY; return $this; } public function select($select = null) { $this->_type = self::SELECT; if (empty($select)) { return $this; } $selects = \is_array($select) ? $select : \func_get_args(); return $this->add('select', new \MailPoetVendor\Doctrine\ORM\Query\Expr\Select($selects), \false); } public function distinct($flag = \true) { $this->_dqlParts['distinct'] = (bool) $flag; return $this; } public function addSelect($select = null) { $this->_type = self::SELECT; if (empty($select)) { return $this; } $selects = \is_array($select) ? $select : \func_get_args(); return $this->add('select', new \MailPoetVendor\Doctrine\ORM\Query\Expr\Select($selects), \true); } public function delete($delete = null, $alias = null) { $this->_type = self::DELETE; if (!$delete) { return $this; } return $this->add('from', new \MailPoetVendor\Doctrine\ORM\Query\Expr\From($delete, $alias)); } public function update($update = null, $alias = null) { $this->_type = self::UPDATE; if (!$update) { return $this; } return $this->add('from', new \MailPoetVendor\Doctrine\ORM\Query\Expr\From($update, $alias)); } public function from($from, $alias, $indexBy = null) { return $this->add('from', new \MailPoetVendor\Doctrine\ORM\Query\Expr\From($from, $alias, $indexBy), \true); } public function indexBy($alias, $indexBy) { $rootAliases = $this->getRootAliases(); if (!\in_array($alias, $rootAliases)) { throw new \MailPoetVendor\Doctrine\ORM\Query\QueryException(\sprintf('Specified root alias %s must be set before invoking indexBy().', $alias)); } foreach ($this->_dqlParts['from'] as &$fromClause) { if ($fromClause->getAlias() !== $alias) { continue; } $fromClause = new \MailPoetVendor\Doctrine\ORM\Query\Expr\From($fromClause->getFrom(), $fromClause->getAlias(), $indexBy); } return $this; } public function join($join, $alias, $conditionType = null, $condition = null, $indexBy = null) { return $this->innerJoin($join, $alias, $conditionType, $condition, $indexBy); } public function innerJoin($join, $alias, $conditionType = null, $condition = null, $indexBy = null) { $parentAlias = \substr($join, 0, \strpos($join, '.')); $rootAlias = $this->findRootAlias($alias, $parentAlias); $join = new \MailPoetVendor\Doctrine\ORM\Query\Expr\Join(\MailPoetVendor\Doctrine\ORM\Query\Expr\Join::INNER_JOIN, $join, $alias, $conditionType, $condition, $indexBy); return $this->add('join', array($rootAlias => $join), \true); } public function leftJoin($join, $alias, $conditionType = null, $condition = null, $indexBy = null) { $parentAlias = \substr($join, 0, \strpos($join, '.')); $rootAlias = $this->findRootAlias($alias, $parentAlias); $join = new \MailPoetVendor\Doctrine\ORM\Query\Expr\Join(\MailPoetVendor\Doctrine\ORM\Query\Expr\Join::LEFT_JOIN, $join, $alias, $conditionType, $condition, $indexBy); return $this->add('join', array($rootAlias => $join), \true); } public function set($key, $value) { return $this->add('set', new \MailPoetVendor\Doctrine\ORM\Query\Expr\Comparison($key, \MailPoetVendor\Doctrine\ORM\Query\Expr\Comparison::EQ, $value), \true); } public function where($predicates) { if (!(\func_num_args() == 1 && $predicates instanceof \MailPoetVendor\Doctrine\ORM\Query\Expr\Composite)) { $predicates = new \MailPoetVendor\Doctrine\ORM\Query\Expr\Andx(\func_get_args()); } return $this->add('where', $predicates); } public function andWhere() { $args = \func_get_args(); $where = $this->getDQLPart('where'); if ($where instanceof \MailPoetVendor\Doctrine\ORM\Query\Expr\Andx) { $where->addMultiple($args); } else { \array_unshift($args, $where); $where = new \MailPoetVendor\Doctrine\ORM\Query\Expr\Andx($args); } return $this->add('where', $where); } public function orWhere() { $args = \func_get_args(); $where = $this->getDqlPart('where'); if ($where instanceof \MailPoetVendor\Doctrine\ORM\Query\Expr\Orx) { $where->addMultiple($args); } else { \array_unshift($args, $where); $where = new \MailPoetVendor\Doctrine\ORM\Query\Expr\Orx($args); } return $this->add('where', $where); } public function groupBy($groupBy) { return $this->add('groupBy', new \MailPoetVendor\Doctrine\ORM\Query\Expr\GroupBy(\func_get_args())); } public function addGroupBy($groupBy) { return $this->add('groupBy', new \MailPoetVendor\Doctrine\ORM\Query\Expr\GroupBy(\func_get_args()), \true); } public function having($having) { if (!(\func_num_args() == 1 && ($having instanceof \MailPoetVendor\Doctrine\ORM\Query\Expr\Andx || $having instanceof \MailPoetVendor\Doctrine\ORM\Query\Expr\Orx))) { $having = new \MailPoetVendor\Doctrine\ORM\Query\Expr\Andx(\func_get_args()); } return $this->add('having', $having); } public function andHaving($having) { $args = \func_get_args(); $having = $this->getDqlPart('having'); if ($having instanceof \MailPoetVendor\Doctrine\ORM\Query\Expr\Andx) { $having->addMultiple($args); } else { \array_unshift($args, $having); $having = new \MailPoetVendor\Doctrine\ORM\Query\Expr\Andx($args); } return $this->add('having', $having); } public function orHaving($having) { $args = \func_get_args(); $having = $this->getDqlPart('having'); if ($having instanceof \MailPoetVendor\Doctrine\ORM\Query\Expr\Orx) { $having->addMultiple($args); } else { \array_unshift($args, $having); $having = new \MailPoetVendor\Doctrine\ORM\Query\Expr\Orx($args); } return $this->add('having', $having); } public function orderBy($sort, $order = null) { $orderBy = $sort instanceof \MailPoetVendor\Doctrine\ORM\Query\Expr\OrderBy ? $sort : new \MailPoetVendor\Doctrine\ORM\Query\Expr\OrderBy($sort, $order); return $this->add('orderBy', $orderBy); } public function addOrderBy($sort, $order = null) { $orderBy = $sort instanceof \MailPoetVendor\Doctrine\ORM\Query\Expr\OrderBy ? $sort : new \MailPoetVendor\Doctrine\ORM\Query\Expr\OrderBy($sort, $order); return $this->add('orderBy', $orderBy, \true); } public function addCriteria(\MailPoetVendor\Doctrine\Common\Collections\Criteria $criteria) { $allAliases = $this->getAllAliases(); if (!isset($allAliases[0])) { throw new \MailPoetVendor\Doctrine\ORM\Query\QueryException('No aliases are set before invoking addCriteria().'); } $visitor = new \MailPoetVendor\Doctrine\ORM\Query\QueryExpressionVisitor($this->getAllAliases()); if ($whereExpression = $criteria->getWhereExpression()) { $this->andWhere($visitor->dispatch($whereExpression)); foreach ($visitor->getParameters() as $parameter) { $this->parameters->add($parameter); } } if ($criteria->getOrderings()) { foreach ($criteria->getOrderings() as $sort => $order) { $hasValidAlias = \false; foreach ($allAliases as $alias) { if (\strpos($sort . '.', $alias . '.') === 0) { $hasValidAlias = \true; break; } } if (!$hasValidAlias) { $sort = $allAliases[0] . '.' . $sort; } $this->addOrderBy($sort, $order); } } if (($firstResult = $criteria->getFirstResult()) !== null) { $this->setFirstResult($firstResult); } if (($maxResults = $criteria->getMaxResults()) !== null) { $this->setMaxResults($maxResults); } return $this; } public function getDQLPart($queryPartName) { return $this->_dqlParts[$queryPartName]; } public function getDQLParts() { return $this->_dqlParts; } private function _getDQLForDelete() { return 'DELETE' . $this->_getReducedDQLQueryPart('from', array('pre' => ' ', 'separator' => ', ')) . $this->_getReducedDQLQueryPart('where', array('pre' => ' WHERE ')) . $this->_getReducedDQLQueryPart('orderBy', array('pre' => ' ORDER BY ', 'separator' => ', ')); } private function _getDQLForUpdate() { return 'UPDATE' . $this->_getReducedDQLQueryPart('from', array('pre' => ' ', 'separator' => ', ')) . $this->_getReducedDQLQueryPart('set', array('pre' => ' SET ', 'separator' => ', ')) . $this->_getReducedDQLQueryPart('where', array('pre' => ' WHERE ')) . $this->_getReducedDQLQueryPart('orderBy', array('pre' => ' ORDER BY ', 'separator' => ', ')); } private function _getDQLForSelect() { $dql = 'SELECT' . ($this->_dqlParts['distinct'] === \true ? ' DISTINCT' : '') . $this->_getReducedDQLQueryPart('select', array('pre' => ' ', 'separator' => ', ')); $fromParts = $this->getDQLPart('from'); $joinParts = $this->getDQLPart('join'); $fromClauses = array(); if (!empty($fromParts)) { $dql .= ' FROM '; foreach ($fromParts as $from) { $fromClause = (string) $from; if ($from instanceof \MailPoetVendor\Doctrine\ORM\Query\Expr\From && isset($joinParts[$from->getAlias()])) { foreach ($joinParts[$from->getAlias()] as $join) { $fromClause .= ' ' . (string) $join; } } $fromClauses[] = $fromClause; } } $dql .= \implode(', ', $fromClauses) . $this->_getReducedDQLQueryPart('where', array('pre' => ' WHERE ')) . $this->_getReducedDQLQueryPart('groupBy', array('pre' => ' GROUP BY ', 'separator' => ', ')) . $this->_getReducedDQLQueryPart('having', array('pre' => ' HAVING ')) . $this->_getReducedDQLQueryPart('orderBy', array('pre' => ' ORDER BY ', 'separator' => ', ')); return $dql; } private function _getReducedDQLQueryPart($queryPartName, $options = array()) { $queryPart = $this->getDQLPart($queryPartName); if (empty($queryPart)) { return isset($options['empty']) ? $options['empty'] : ''; } return (isset($options['pre']) ? $options['pre'] : '') . (\is_array($queryPart) ? \implode($options['separator'], $queryPart) : $queryPart) . (isset($options['post']) ? $options['post'] : ''); } public function resetDQLParts($parts = null) { if (\is_null($parts)) { $parts = \array_keys($this->_dqlParts); } foreach ($parts as $part) { $this->resetDQLPart($part); } return $this; } public function resetDQLPart($part) { $this->_dqlParts[$part] = \is_array($this->_dqlParts[$part]) ? array() : null; $this->_state = self::STATE_DIRTY; return $this; } public function __toString() { return $this->getDQL(); } public function __clone() { foreach ($this->_dqlParts as $part => $elements) { if (\is_array($this->_dqlParts[$part])) { foreach ($this->_dqlParts[$part] as $idx => $element) { if (\is_object($element)) { $this->_dqlParts[$part][$idx] = clone $element; } } } else { if (\is_object($elements)) { $this->_dqlParts[$part] = clone $elements; } } } $parameters = array(); foreach ($this->parameters as $parameter) { $parameters[] = clone $parameter; } $this->parameters = new \MailPoetVendor\Doctrine\Common\Collections\ArrayCollection($parameters); } } 