<?php
 namespace MailPoetVendor\Doctrine\ORM; if (!defined('ABSPATH')) exit; use MailPoetVendor\Doctrine\Common\Persistence\Mapping\RuntimeReflectionService; use MailPoetVendor\Doctrine\DBAL\LockMode; use MailPoetVendor\Doctrine\ORM\Internal\HydrationCompleteHandler; use MailPoetVendor\Doctrine\ORM\Mapping\Reflection\ReflectionPropertiesGetter; use Exception; use InvalidArgumentException; use UnexpectedValueException; use MailPoetVendor\Doctrine\Common\Collections\ArrayCollection; use MailPoetVendor\Doctrine\Common\Collections\Collection; use MailPoetVendor\Doctrine\Common\NotifyPropertyChanged; use MailPoetVendor\Doctrine\Common\PropertyChangedListener; use MailPoetVendor\Doctrine\Common\Persistence\ObjectManagerAware; use MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata; use MailPoetVendor\Doctrine\ORM\Proxy\Proxy; use MailPoetVendor\Doctrine\ORM\Event\LifecycleEventArgs; use MailPoetVendor\Doctrine\ORM\Event\PreUpdateEventArgs; use MailPoetVendor\Doctrine\ORM\Event\PreFlushEventArgs; use MailPoetVendor\Doctrine\ORM\Event\OnFlushEventArgs; use MailPoetVendor\Doctrine\ORM\Event\PostFlushEventArgs; use MailPoetVendor\Doctrine\ORM\Event\ListenersInvoker; use MailPoetVendor\Doctrine\ORM\Cache\Persister\CachedPersister; use MailPoetVendor\Doctrine\ORM\Persisters\Entity\BasicEntityPersister; use MailPoetVendor\Doctrine\ORM\Persisters\Entity\SingleTablePersister; use MailPoetVendor\Doctrine\ORM\Persisters\Entity\JoinedSubclassPersister; use MailPoetVendor\Doctrine\ORM\Persisters\Collection\OneToManyPersister; use MailPoetVendor\Doctrine\ORM\Persisters\Collection\ManyToManyPersister; use MailPoetVendor\Doctrine\ORM\Utility\IdentifierFlattener; use MailPoetVendor\Doctrine\ORM\Cache\AssociationCacheEntry; class UnitOfWork implements \MailPoetVendor\Doctrine\Common\PropertyChangedListener { const STATE_MANAGED = 1; const STATE_NEW = 2; const STATE_DETACHED = 3; const STATE_REMOVED = 4; const HINT_DEFEREAGERLOAD = 'deferEagerLoad'; private $identityMap = array(); private $entityIdentifiers = array(); private $originalEntityData = array(); private $entityChangeSets = array(); private $entityStates = array(); private $scheduledForSynchronization = array(); private $entityInsertions = array(); private $entityUpdates = array(); private $extraUpdates = array(); private $entityDeletions = array(); private $collectionDeletions = array(); private $collectionUpdates = array(); private $visitedCollections = array(); private $em; private $commitOrderCalculator; private $persisters = array(); private $collectionPersisters = array(); private $evm; private $listenersInvoker; private $identifierFlattener; private $orphanRemovals = array(); private $readOnlyObjects = array(); private $eagerLoadingEntities = array(); protected $hasCache = \false; private $hydrationCompleteHandler; private $reflectionPropertiesGetter; public function __construct(\MailPoetVendor\Doctrine\ORM\EntityManagerInterface $em) { $this->em = $em; $this->evm = $em->getEventManager(); $this->listenersInvoker = new \MailPoetVendor\Doctrine\ORM\Event\ListenersInvoker($em); $this->hasCache = $em->getConfiguration()->isSecondLevelCacheEnabled(); $this->identifierFlattener = new \MailPoetVendor\Doctrine\ORM\Utility\IdentifierFlattener($this, $em->getMetadataFactory()); $this->hydrationCompleteHandler = new \MailPoetVendor\Doctrine\ORM\Internal\HydrationCompleteHandler($this->listenersInvoker, $em); $this->reflectionPropertiesGetter = new \MailPoetVendor\Doctrine\ORM\Mapping\Reflection\ReflectionPropertiesGetter(new \MailPoetVendor\Doctrine\Common\Persistence\Mapping\RuntimeReflectionService()); } public function commit($entity = null) { if ($this->evm->hasListeners(\MailPoetVendor\Doctrine\ORM\Events::preFlush)) { $this->evm->dispatchEvent(\MailPoetVendor\Doctrine\ORM\Events::preFlush, new \MailPoetVendor\Doctrine\ORM\Event\PreFlushEventArgs($this->em)); } if ($entity === null) { $this->computeChangeSets(); } elseif (\is_object($entity)) { $this->computeSingleEntityChangeSet($entity); } elseif (\is_array($entity)) { foreach ($entity as $object) { $this->computeSingleEntityChangeSet($object); } } if (!($this->entityInsertions || $this->entityDeletions || $this->entityUpdates || $this->collectionUpdates || $this->collectionDeletions || $this->orphanRemovals)) { $this->dispatchOnFlushEvent(); $this->dispatchPostFlushEvent(); return; } if ($this->orphanRemovals) { foreach ($this->orphanRemovals as $orphan) { $this->remove($orphan); } } $this->dispatchOnFlushEvent(); $commitOrder = $this->getCommitOrder(); $conn = $this->em->getConnection(); $conn->beginTransaction(); try { if ($this->entityInsertions) { foreach ($commitOrder as $class) { $this->executeInserts($class); } } if ($this->entityUpdates) { foreach ($commitOrder as $class) { $this->executeUpdates($class); } } if ($this->extraUpdates) { $this->executeExtraUpdates(); } foreach ($this->collectionDeletions as $collectionToDelete) { $this->getCollectionPersister($collectionToDelete->getMapping())->delete($collectionToDelete); } foreach ($this->collectionUpdates as $collectionToUpdate) { $this->getCollectionPersister($collectionToUpdate->getMapping())->update($collectionToUpdate); } if ($this->entityDeletions) { for ($count = \count($commitOrder), $i = $count - 1; $i >= 0 && $this->entityDeletions; --$i) { $this->executeDeletions($commitOrder[$i]); } } $conn->commit(); } catch (\Exception $e) { $this->em->close(); $conn->rollback(); $this->afterTransactionRolledBack(); throw $e; } $this->afterTransactionComplete(); foreach ($this->visitedCollections as $coll) { $coll->takeSnapshot(); } $this->dispatchPostFlushEvent(); $this->entityInsertions = $this->entityUpdates = $this->entityDeletions = $this->extraUpdates = $this->entityChangeSets = $this->collectionUpdates = $this->collectionDeletions = $this->visitedCollections = $this->scheduledForSynchronization = $this->orphanRemovals = array(); } private function computeScheduleInsertsChangeSets() { foreach ($this->entityInsertions as $entity) { $class = $this->em->getClassMetadata(\get_class($entity)); $this->computeChangeSet($class, $entity); } } private function computeSingleEntityChangeSet($entity) { $state = $this->getEntityState($entity); if ($state !== self::STATE_MANAGED && $state !== self::STATE_REMOVED) { throw new \InvalidArgumentException("Entity has to be managed or scheduled for removal for single computation " . self::objToStr($entity)); } $class = $this->em->getClassMetadata(\get_class($entity)); if ($state === self::STATE_MANAGED && $class->isChangeTrackingDeferredImplicit()) { $this->persist($entity); } $this->computeScheduleInsertsChangeSets(); if ($class->isReadOnly) { return; } if ($entity instanceof \MailPoetVendor\Doctrine\ORM\Proxy\Proxy && !$entity->__isInitialized__) { return; } $oid = \spl_object_hash($entity); if (!isset($this->entityInsertions[$oid]) && !isset($this->entityDeletions[$oid]) && isset($this->entityStates[$oid])) { $this->computeChangeSet($class, $entity); } } private function executeExtraUpdates() { foreach ($this->extraUpdates as $oid => $update) { list($entity, $changeset) = $update; $this->entityChangeSets[$oid] = $changeset; $this->getEntityPersister(\get_class($entity))->update($entity); } $this->extraUpdates = array(); } public function getEntityChangeSet($entity) { $oid = \spl_object_hash($entity); if (isset($this->entityChangeSets[$oid])) { return $this->entityChangeSets[$oid]; } return array(); } public function computeChangeSet(\MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata $class, $entity) { $oid = \spl_object_hash($entity); if (isset($this->readOnlyObjects[$oid])) { return; } if (!$class->isInheritanceTypeNone()) { $class = $this->em->getClassMetadata(\get_class($entity)); } $invoke = $this->listenersInvoker->getSubscribedSystems($class, \MailPoetVendor\Doctrine\ORM\Events::preFlush) & ~\MailPoetVendor\Doctrine\ORM\Event\ListenersInvoker::INVOKE_MANAGER; if ($invoke !== \MailPoetVendor\Doctrine\ORM\Event\ListenersInvoker::INVOKE_NONE) { $this->listenersInvoker->invoke($class, \MailPoetVendor\Doctrine\ORM\Events::preFlush, $entity, new \MailPoetVendor\Doctrine\ORM\Event\PreFlushEventArgs($this->em), $invoke); } $actualData = array(); foreach ($class->reflFields as $name => $refProp) { $value = $refProp->getValue($entity); if ($class->isCollectionValuedAssociation($name) && $value !== null) { if ($value instanceof \MailPoetVendor\Doctrine\ORM\PersistentCollection) { if ($value->getOwner() === $entity) { continue; } $value = new \MailPoetVendor\Doctrine\Common\Collections\ArrayCollection($value->getValues()); } if (!$value instanceof \MailPoetVendor\Doctrine\Common\Collections\Collection) { $value = new \MailPoetVendor\Doctrine\Common\Collections\ArrayCollection($value); } $assoc = $class->associationMappings[$name]; $value = new \MailPoetVendor\Doctrine\ORM\PersistentCollection($this->em, $this->em->getClassMetadata($assoc['targetEntity']), $value); $value->setOwner($entity, $assoc); $value->setDirty(!$value->isEmpty()); $class->reflFields[$name]->setValue($entity, $value); $actualData[$name] = $value; continue; } if ((!$class->isIdentifier($name) || !$class->isIdGeneratorIdentity()) && $name !== $class->versionField) { $actualData[$name] = $value; } } if (!isset($this->originalEntityData[$oid])) { $this->originalEntityData[$oid] = $actualData; $changeSet = array(); foreach ($actualData as $propName => $actualValue) { if (!isset($class->associationMappings[$propName])) { $changeSet[$propName] = array(null, $actualValue); continue; } $assoc = $class->associationMappings[$propName]; if ($assoc['isOwningSide'] && $assoc['type'] & \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata::TO_ONE) { $changeSet[$propName] = array(null, $actualValue); } } $this->entityChangeSets[$oid] = $changeSet; } else { $originalData = $this->originalEntityData[$oid]; $isChangeTrackingNotify = $class->isChangeTrackingNotify(); $changeSet = $isChangeTrackingNotify && isset($this->entityChangeSets[$oid]) ? $this->entityChangeSets[$oid] : array(); foreach ($actualData as $propName => $actualValue) { if (!(isset($originalData[$propName]) || \array_key_exists($propName, $originalData))) { continue; } $orgValue = $originalData[$propName]; if ($orgValue === $actualValue) { continue; } if (!isset($class->associationMappings[$propName])) { if ($isChangeTrackingNotify) { continue; } $changeSet[$propName] = array($orgValue, $actualValue); continue; } $assoc = $class->associationMappings[$propName]; if ($actualValue instanceof \MailPoetVendor\Doctrine\ORM\PersistentCollection) { $owner = $actualValue->getOwner(); if ($owner === null) { $actualValue->setOwner($entity, $assoc); } else { if ($owner !== $entity) { if (!$actualValue->isInitialized()) { $actualValue->initialize(); } $newValue = clone $actualValue; $newValue->setOwner($entity, $assoc); $class->reflFields[$propName]->setValue($entity, $newValue); } } } if ($orgValue instanceof \MailPoetVendor\Doctrine\ORM\PersistentCollection) { $coid = \spl_object_hash($orgValue); if (isset($this->collectionDeletions[$coid])) { continue; } $this->collectionDeletions[$coid] = $orgValue; $changeSet[$propName] = $orgValue; continue; } if ($assoc['type'] & \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata::TO_ONE) { if ($assoc['isOwningSide']) { $changeSet[$propName] = array($orgValue, $actualValue); } if ($orgValue !== null && $assoc['orphanRemoval']) { $this->scheduleOrphanRemoval($orgValue); } } } if ($changeSet) { $this->entityChangeSets[$oid] = $changeSet; $this->originalEntityData[$oid] = $actualData; $this->entityUpdates[$oid] = $entity; } } foreach ($class->associationMappings as $field => $assoc) { if (($val = $class->reflFields[$field]->getValue($entity)) === null) { continue; } $this->computeAssociationChanges($assoc, $val); if (!isset($this->entityChangeSets[$oid]) && $assoc['isOwningSide'] && $assoc['type'] == \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata::MANY_TO_MANY && $val instanceof \MailPoetVendor\Doctrine\ORM\PersistentCollection && $val->isDirty()) { $this->entityChangeSets[$oid] = array(); $this->originalEntityData[$oid] = $actualData; $this->entityUpdates[$oid] = $entity; } } } public function computeChangeSets() { $this->computeScheduleInsertsChangeSets(); foreach ($this->identityMap as $className => $entities) { $class = $this->em->getClassMetadata($className); if ($class->isReadOnly) { continue; } switch (\true) { case $class->isChangeTrackingDeferredImplicit(): $entitiesToProcess = $entities; break; case isset($this->scheduledForSynchronization[$className]): $entitiesToProcess = $this->scheduledForSynchronization[$className]; break; default: $entitiesToProcess = array(); } foreach ($entitiesToProcess as $entity) { if ($entity instanceof \MailPoetVendor\Doctrine\ORM\Proxy\Proxy && !$entity->__isInitialized__) { continue; } $oid = \spl_object_hash($entity); if (!isset($this->entityInsertions[$oid]) && !isset($this->entityDeletions[$oid]) && isset($this->entityStates[$oid])) { $this->computeChangeSet($class, $entity); } } } } private function computeAssociationChanges($assoc, $value) { if ($value instanceof \MailPoetVendor\Doctrine\ORM\Proxy\Proxy && !$value->__isInitialized__) { return; } if ($value instanceof \MailPoetVendor\Doctrine\ORM\PersistentCollection && $value->isDirty()) { $coid = \spl_object_hash($value); $this->collectionUpdates[$coid] = $value; $this->visitedCollections[$coid] = $value; } $unwrappedValue = $assoc['type'] & \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata::TO_ONE ? array($value) : $value->unwrap(); $targetClass = $this->em->getClassMetadata($assoc['targetEntity']); foreach ($unwrappedValue as $key => $entry) { if (!$entry instanceof $targetClass->name) { throw \MailPoetVendor\Doctrine\ORM\ORMInvalidArgumentException::invalidAssociation($targetClass, $assoc, $entry); } $state = $this->getEntityState($entry, self::STATE_NEW); if (!$entry instanceof $assoc['targetEntity']) { throw \MailPoetVendor\Doctrine\ORM\ORMException::unexpectedAssociationValue($assoc['sourceEntity'], $assoc['fieldName'], \get_class($entry), $assoc['targetEntity']); } switch ($state) { case self::STATE_NEW: if (!$assoc['isCascadePersist']) { throw \MailPoetVendor\Doctrine\ORM\ORMInvalidArgumentException::newEntityFoundThroughRelationship($assoc, $entry); } $this->persistNew($targetClass, $entry); $this->computeChangeSet($targetClass, $entry); break; case self::STATE_REMOVED: if ($assoc['type'] & \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata::TO_MANY) { unset($value[$key]); } break; case self::STATE_DETACHED: throw \MailPoetVendor\Doctrine\ORM\ORMInvalidArgumentException::detachedEntityFoundThroughRelationship($assoc, $entry); break; default: } } } private function persistNew($class, $entity) { $oid = \spl_object_hash($entity); $invoke = $this->listenersInvoker->getSubscribedSystems($class, \MailPoetVendor\Doctrine\ORM\Events::prePersist); if ($invoke !== \MailPoetVendor\Doctrine\ORM\Event\ListenersInvoker::INVOKE_NONE) { $this->listenersInvoker->invoke($class, \MailPoetVendor\Doctrine\ORM\Events::prePersist, $entity, new \MailPoetVendor\Doctrine\ORM\Event\LifecycleEventArgs($entity, $this->em), $invoke); } $idGen = $class->idGenerator; if (!$idGen->isPostInsertGenerator()) { $idValue = $idGen->generate($this->em, $entity); if (!$idGen instanceof \MailPoetVendor\Doctrine\ORM\Id\AssignedGenerator) { $idValue = array($class->identifier[0] => $idValue); $class->setIdentifierValues($entity, $idValue); } $this->entityIdentifiers[$oid] = $idValue; } $this->entityStates[$oid] = self::STATE_MANAGED; $this->scheduleForInsert($entity); } public function recomputeSingleEntityChangeSet(\MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata $class, $entity) { $oid = \spl_object_hash($entity); if (!isset($this->entityStates[$oid]) || $this->entityStates[$oid] != self::STATE_MANAGED) { throw \MailPoetVendor\Doctrine\ORM\ORMInvalidArgumentException::entityNotManaged($entity); } if ($class->isChangeTrackingNotify()) { return; } if (!$class->isInheritanceTypeNone()) { $class = $this->em->getClassMetadata(\get_class($entity)); } $actualData = array(); foreach ($class->reflFields as $name => $refProp) { if ((!$class->isIdentifier($name) || !$class->isIdGeneratorIdentity()) && $name !== $class->versionField && !$class->isCollectionValuedAssociation($name)) { $actualData[$name] = $refProp->getValue($entity); } } if (!isset($this->originalEntityData[$oid])) { throw new \RuntimeException('Cannot call recomputeSingleEntityChangeSet before computeChangeSet on an entity.'); } $originalData = $this->originalEntityData[$oid]; $changeSet = array(); foreach ($actualData as $propName => $actualValue) { $orgValue = isset($originalData[$propName]) ? $originalData[$propName] : null; if ($orgValue !== $actualValue) { $changeSet[$propName] = array($orgValue, $actualValue); } } if ($changeSet) { if (isset($this->entityChangeSets[$oid])) { $this->entityChangeSets[$oid] = \array_merge($this->entityChangeSets[$oid], $changeSet); } else { if (!isset($this->entityInsertions[$oid])) { $this->entityChangeSets[$oid] = $changeSet; $this->entityUpdates[$oid] = $entity; } } $this->originalEntityData[$oid] = $actualData; } } private function executeInserts($class) { $entities = array(); $className = $class->name; $persister = $this->getEntityPersister($className); $invoke = $this->listenersInvoker->getSubscribedSystems($class, \MailPoetVendor\Doctrine\ORM\Events::postPersist); foreach ($this->entityInsertions as $oid => $entity) { if ($this->em->getClassMetadata(\get_class($entity))->name !== $className) { continue; } $persister->addInsert($entity); unset($this->entityInsertions[$oid]); if ($invoke !== \MailPoetVendor\Doctrine\ORM\Event\ListenersInvoker::INVOKE_NONE) { $entities[] = $entity; } } $postInsertIds = $persister->executeInserts(); if ($postInsertIds) { foreach ($postInsertIds as $postInsertId) { $id = $postInsertId['generatedId']; $entity = $postInsertId['entity']; $oid = \spl_object_hash($entity); $idField = $class->identifier[0]; $class->reflFields[$idField]->setValue($entity, $id); $this->entityIdentifiers[$oid] = array($idField => $id); $this->entityStates[$oid] = self::STATE_MANAGED; $this->originalEntityData[$oid][$idField] = $id; $this->addToIdentityMap($entity); } } foreach ($entities as $entity) { $this->listenersInvoker->invoke($class, \MailPoetVendor\Doctrine\ORM\Events::postPersist, $entity, new \MailPoetVendor\Doctrine\ORM\Event\LifecycleEventArgs($entity, $this->em), $invoke); } } private function executeUpdates($class) { $className = $class->name; $persister = $this->getEntityPersister($className); $preUpdateInvoke = $this->listenersInvoker->getSubscribedSystems($class, \MailPoetVendor\Doctrine\ORM\Events::preUpdate); $postUpdateInvoke = $this->listenersInvoker->getSubscribedSystems($class, \MailPoetVendor\Doctrine\ORM\Events::postUpdate); foreach ($this->entityUpdates as $oid => $entity) { if ($this->em->getClassMetadata(\get_class($entity))->name !== $className) { continue; } if ($preUpdateInvoke != \MailPoetVendor\Doctrine\ORM\Event\ListenersInvoker::INVOKE_NONE) { $this->listenersInvoker->invoke($class, \MailPoetVendor\Doctrine\ORM\Events::preUpdate, $entity, new \MailPoetVendor\Doctrine\ORM\Event\PreUpdateEventArgs($entity, $this->em, $this->entityChangeSets[$oid]), $preUpdateInvoke); $this->recomputeSingleEntityChangeSet($class, $entity); } if (!empty($this->entityChangeSets[$oid])) { $persister->update($entity); } unset($this->entityUpdates[$oid]); if ($postUpdateInvoke != \MailPoetVendor\Doctrine\ORM\Event\ListenersInvoker::INVOKE_NONE) { $this->listenersInvoker->invoke($class, \MailPoetVendor\Doctrine\ORM\Events::postUpdate, $entity, new \MailPoetVendor\Doctrine\ORM\Event\LifecycleEventArgs($entity, $this->em), $postUpdateInvoke); } } } private function executeDeletions($class) { $className = $class->name; $persister = $this->getEntityPersister($className); $invoke = $this->listenersInvoker->getSubscribedSystems($class, \MailPoetVendor\Doctrine\ORM\Events::postRemove); foreach ($this->entityDeletions as $oid => $entity) { if ($this->em->getClassMetadata(\get_class($entity))->name !== $className) { continue; } $persister->delete($entity); unset($this->entityDeletions[$oid], $this->entityIdentifiers[$oid], $this->originalEntityData[$oid], $this->entityStates[$oid]); if (!$class->isIdentifierNatural()) { $class->reflFields[$class->identifier[0]]->setValue($entity, null); } if ($invoke !== \MailPoetVendor\Doctrine\ORM\Event\ListenersInvoker::INVOKE_NONE) { $this->listenersInvoker->invoke($class, \MailPoetVendor\Doctrine\ORM\Events::postRemove, $entity, new \MailPoetVendor\Doctrine\ORM\Event\LifecycleEventArgs($entity, $this->em), $invoke); } } } private function getCommitOrder(array $entityChangeSet = null) { if ($entityChangeSet === null) { $entityChangeSet = \array_merge($this->entityInsertions, $this->entityUpdates, $this->entityDeletions); } $calc = $this->getCommitOrderCalculator(); $newNodes = array(); foreach ($entityChangeSet as $entity) { $class = $this->em->getClassMetadata(\get_class($entity)); if ($calc->hasClass($class->name)) { continue; } $calc->addClass($class); $newNodes[] = $class; } while ($class = \array_pop($newNodes)) { foreach ($class->associationMappings as $assoc) { if (!($assoc['isOwningSide'] && $assoc['type'] & \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata::TO_ONE)) { continue; } $targetClass = $this->em->getClassMetadata($assoc['targetEntity']); if (!$calc->hasClass($targetClass->name)) { $calc->addClass($targetClass); $newNodes[] = $targetClass; } $calc->addDependency($targetClass, $class); if (!$targetClass->subClasses) { continue; } foreach ($targetClass->subClasses as $subClassName) { $targetSubClass = $this->em->getClassMetadata($subClassName); if (!$calc->hasClass($subClassName)) { $calc->addClass($targetSubClass); $newNodes[] = $targetSubClass; } $calc->addDependency($targetSubClass, $class); } } } return $calc->getCommitOrder(); } public function scheduleForInsert($entity) { $oid = \spl_object_hash($entity); if (isset($this->entityUpdates[$oid])) { throw new \InvalidArgumentException("Dirty entity can not be scheduled for insertion."); } if (isset($this->entityDeletions[$oid])) { throw \MailPoetVendor\Doctrine\ORM\ORMInvalidArgumentException::scheduleInsertForRemovedEntity($entity); } if (isset($this->originalEntityData[$oid]) && !isset($this->entityInsertions[$oid])) { throw \MailPoetVendor\Doctrine\ORM\ORMInvalidArgumentException::scheduleInsertForManagedEntity($entity); } if (isset($this->entityInsertions[$oid])) { throw \MailPoetVendor\Doctrine\ORM\ORMInvalidArgumentException::scheduleInsertTwice($entity); } $this->entityInsertions[$oid] = $entity; if (isset($this->entityIdentifiers[$oid])) { $this->addToIdentityMap($entity); } if ($entity instanceof \MailPoetVendor\Doctrine\Common\NotifyPropertyChanged) { $entity->addPropertyChangedListener($this); } } public function isScheduledForInsert($entity) { return isset($this->entityInsertions[\spl_object_hash($entity)]); } public function scheduleForUpdate($entity) { $oid = \spl_object_hash($entity); if (!isset($this->entityIdentifiers[$oid])) { throw \MailPoetVendor\Doctrine\ORM\ORMInvalidArgumentException::entityHasNoIdentity($entity, "scheduling for update"); } if (isset($this->entityDeletions[$oid])) { throw \MailPoetVendor\Doctrine\ORM\ORMInvalidArgumentException::entityIsRemoved($entity, "schedule for update"); } if (!isset($this->entityUpdates[$oid]) && !isset($this->entityInsertions[$oid])) { $this->entityUpdates[$oid] = $entity; } } public function scheduleExtraUpdate($entity, array $changeset) { $oid = \spl_object_hash($entity); $extraUpdate = array($entity, $changeset); if (isset($this->extraUpdates[$oid])) { list($ignored, $changeset2) = $this->extraUpdates[$oid]; $extraUpdate = array($entity, $changeset + $changeset2); } $this->extraUpdates[$oid] = $extraUpdate; } public function isScheduledForUpdate($entity) { return isset($this->entityUpdates[\spl_object_hash($entity)]); } public function isScheduledForDirtyCheck($entity) { $rootEntityName = $this->em->getClassMetadata(\get_class($entity))->rootEntityName; return isset($this->scheduledForSynchronization[$rootEntityName][\spl_object_hash($entity)]); } public function scheduleForDelete($entity) { $oid = \spl_object_hash($entity); if (isset($this->entityInsertions[$oid])) { if ($this->isInIdentityMap($entity)) { $this->removeFromIdentityMap($entity); } unset($this->entityInsertions[$oid], $this->entityStates[$oid]); return; } if (!$this->isInIdentityMap($entity)) { return; } $this->removeFromIdentityMap($entity); if (isset($this->entityUpdates[$oid])) { unset($this->entityUpdates[$oid]); } if (!isset($this->entityDeletions[$oid])) { $this->entityDeletions[$oid] = $entity; $this->entityStates[$oid] = self::STATE_REMOVED; } } public function isScheduledForDelete($entity) { return isset($this->entityDeletions[\spl_object_hash($entity)]); } public function isEntityScheduled($entity) { $oid = \spl_object_hash($entity); return isset($this->entityInsertions[$oid]) || isset($this->entityUpdates[$oid]) || isset($this->entityDeletions[$oid]); } public function addToIdentityMap($entity) { $classMetadata = $this->em->getClassMetadata(\get_class($entity)); $idHash = \implode(' ', $this->entityIdentifiers[\spl_object_hash($entity)]); if ($idHash === '') { throw \MailPoetVendor\Doctrine\ORM\ORMInvalidArgumentException::entityWithoutIdentity($classMetadata->name, $entity); } $className = $classMetadata->rootEntityName; if (isset($this->identityMap[$className][$idHash])) { return \false; } $this->identityMap[$className][$idHash] = $entity; return \true; } public function getEntityState($entity, $assume = null) { $oid = \spl_object_hash($entity); if (isset($this->entityStates[$oid])) { return $this->entityStates[$oid]; } if ($assume !== null) { return $assume; } $class = $this->em->getClassMetadata(\get_class($entity)); $id = $class->getIdentifierValues($entity); if (!$id) { return self::STATE_NEW; } if ($class->containsForeignIdentifier) { $id = $this->identifierFlattener->flattenIdentifier($class, $id); } switch (\true) { case $class->isIdentifierNatural(): if ($class->isVersioned) { return $class->getFieldValue($entity, $class->versionField) ? self::STATE_DETACHED : self::STATE_NEW; } if ($this->tryGetById($id, $class->rootEntityName)) { return self::STATE_DETACHED; } if ($this->getEntityPersister($class->name)->exists($entity)) { return self::STATE_DETACHED; } return self::STATE_NEW; case !$class->idGenerator->isPostInsertGenerator(): if ($this->tryGetById($id, $class->rootEntityName)) { return self::STATE_DETACHED; } if ($this->getEntityPersister($class->name)->exists($entity)) { return self::STATE_DETACHED; } return self::STATE_NEW; default: return self::STATE_DETACHED; } } public function removeFromIdentityMap($entity) { $oid = \spl_object_hash($entity); $classMetadata = $this->em->getClassMetadata(\get_class($entity)); $idHash = \implode(' ', $this->entityIdentifiers[$oid]); if ($idHash === '') { throw \MailPoetVendor\Doctrine\ORM\ORMInvalidArgumentException::entityHasNoIdentity($entity, "remove from identity map"); } $className = $classMetadata->rootEntityName; if (isset($this->identityMap[$className][$idHash])) { unset($this->identityMap[$className][$idHash]); unset($this->readOnlyObjects[$oid]); return \true; } return \false; } public function getByIdHash($idHash, $rootClassName) { return $this->identityMap[$rootClassName][$idHash]; } public function tryGetByIdHash($idHash, $rootClassName) { $stringIdHash = (string) $idHash; if (isset($this->identityMap[$rootClassName][$stringIdHash])) { return $this->identityMap[$rootClassName][$stringIdHash]; } return \false; } public function isInIdentityMap($entity) { $oid = \spl_object_hash($entity); if (!isset($this->entityIdentifiers[$oid])) { return \false; } $classMetadata = $this->em->getClassMetadata(\get_class($entity)); $idHash = \implode(' ', $this->entityIdentifiers[$oid]); if ($idHash === '') { return \false; } return isset($this->identityMap[$classMetadata->rootEntityName][$idHash]); } public function containsIdHash($idHash, $rootClassName) { return isset($this->identityMap[$rootClassName][$idHash]); } public function persist($entity) { $visited = array(); $this->doPersist($entity, $visited); } private function doPersist($entity, array &$visited) { $oid = \spl_object_hash($entity); if (isset($visited[$oid])) { return; } $visited[$oid] = $entity; $class = $this->em->getClassMetadata(\get_class($entity)); $entityState = $this->getEntityState($entity, self::STATE_NEW); switch ($entityState) { case self::STATE_MANAGED: if ($class->isChangeTrackingDeferredExplicit()) { $this->scheduleForDirtyCheck($entity); } break; case self::STATE_NEW: $this->persistNew($class, $entity); break; case self::STATE_REMOVED: unset($this->entityDeletions[$oid]); $this->addToIdentityMap($entity); $this->entityStates[$oid] = self::STATE_MANAGED; break; case self::STATE_DETACHED: throw \MailPoetVendor\Doctrine\ORM\ORMInvalidArgumentException::detachedEntityCannot($entity, "persisted"); default: throw new \UnexpectedValueException("Unexpected entity state: {$entityState}." . self::objToStr($entity)); } $this->cascadePersist($entity, $visited); } public function remove($entity) { $visited = array(); $this->doRemove($entity, $visited); } private function doRemove($entity, array &$visited) { $oid = \spl_object_hash($entity); if (isset($visited[$oid])) { return; } $visited[$oid] = $entity; $this->cascadeRemove($entity, $visited); $class = $this->em->getClassMetadata(\get_class($entity)); $entityState = $this->getEntityState($entity); switch ($entityState) { case self::STATE_NEW: case self::STATE_REMOVED: break; case self::STATE_MANAGED: $invoke = $this->listenersInvoker->getSubscribedSystems($class, \MailPoetVendor\Doctrine\ORM\Events::preRemove); if ($invoke !== \MailPoetVendor\Doctrine\ORM\Event\ListenersInvoker::INVOKE_NONE) { $this->listenersInvoker->invoke($class, \MailPoetVendor\Doctrine\ORM\Events::preRemove, $entity, new \MailPoetVendor\Doctrine\ORM\Event\LifecycleEventArgs($entity, $this->em), $invoke); } $this->scheduleForDelete($entity); break; case self::STATE_DETACHED: throw \MailPoetVendor\Doctrine\ORM\ORMInvalidArgumentException::detachedEntityCannot($entity, "removed"); default: throw new \UnexpectedValueException("Unexpected entity state: {$entityState}." . self::objToStr($entity)); } } public function merge($entity) { $visited = array(); return $this->doMerge($entity, $visited); } private function doMerge($entity, array &$visited, $prevManagedCopy = null, $assoc = null) { $oid = \spl_object_hash($entity); if (isset($visited[$oid])) { $managedCopy = $visited[$oid]; if ($prevManagedCopy !== null) { $this->updateAssociationWithMergedEntity($entity, $assoc, $prevManagedCopy, $managedCopy); } return $managedCopy; } $class = $this->em->getClassMetadata(\get_class($entity)); $managedCopy = $entity; if ($this->getEntityState($entity, self::STATE_DETACHED) !== self::STATE_MANAGED) { $id = $class->getIdentifierValues($entity); if (!$id) { $managedCopy = $this->newInstance($class); $this->mergeEntityStateIntoManagedCopy($entity, $managedCopy); $this->persistNew($class, $managedCopy); } else { $flatId = $class->containsForeignIdentifier ? $this->identifierFlattener->flattenIdentifier($class, $id) : $id; $managedCopy = $this->tryGetById($flatId, $class->rootEntityName); if ($managedCopy) { if ($this->getEntityState($managedCopy) == self::STATE_REMOVED) { throw \MailPoetVendor\Doctrine\ORM\ORMInvalidArgumentException::entityIsRemoved($managedCopy, "merge"); } } else { $managedCopy = $this->em->find($class->name, $flatId); } if ($managedCopy === null) { if (!$class->isIdentifierNatural()) { throw \MailPoetVendor\Doctrine\ORM\EntityNotFoundException::fromClassNameAndIdentifier($class->getName(), $this->identifierFlattener->flattenIdentifier($class, $id)); } $managedCopy = $this->newInstance($class); $class->setIdentifierValues($managedCopy, $id); $this->mergeEntityStateIntoManagedCopy($entity, $managedCopy); $this->persistNew($class, $managedCopy); } else { $this->ensureVersionMatch($class, $entity, $managedCopy); $this->mergeEntityStateIntoManagedCopy($entity, $managedCopy); } } $visited[$oid] = $managedCopy; if ($class->isChangeTrackingDeferredExplicit()) { $this->scheduleForDirtyCheck($entity); } } if ($prevManagedCopy !== null) { $this->updateAssociationWithMergedEntity($entity, $assoc, $prevManagedCopy, $managedCopy); } $visited[\spl_object_hash($managedCopy)] = $managedCopy; $this->cascadeMerge($entity, $managedCopy, $visited); return $managedCopy; } private function ensureVersionMatch(\MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata $class, $entity, $managedCopy) { if (!($class->isVersioned && $this->isLoaded($managedCopy) && $this->isLoaded($entity))) { return; } $reflField = $class->reflFields[$class->versionField]; $managedCopyVersion = $reflField->getValue($managedCopy); $entityVersion = $reflField->getValue($entity); if ($managedCopyVersion == $entityVersion) { return; } throw \MailPoetVendor\Doctrine\ORM\OptimisticLockException::lockFailedVersionMismatch($entity, $entityVersion, $managedCopyVersion); } private function isLoaded($entity) { return !$entity instanceof \MailPoetVendor\Doctrine\ORM\Proxy\Proxy || $entity->__isInitialized(); } private function updateAssociationWithMergedEntity($entity, array $association, $previousManagedCopy, $managedCopy) { $assocField = $association['fieldName']; $prevClass = $this->em->getClassMetadata(\get_class($previousManagedCopy)); if ($association['type'] & \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata::TO_ONE) { $prevClass->reflFields[$assocField]->setValue($previousManagedCopy, $managedCopy); return; } $value = $prevClass->reflFields[$assocField]->getValue($previousManagedCopy); $value[] = $managedCopy; if ($association['type'] == \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata::ONE_TO_MANY) { $class = $this->em->getClassMetadata(\get_class($entity)); $class->reflFields[$association['mappedBy']]->setValue($managedCopy, $previousManagedCopy); } } public function detach($entity) { $visited = array(); $this->doDetach($entity, $visited); } private function doDetach($entity, array &$visited, $noCascade = \false) { $oid = \spl_object_hash($entity); if (isset($visited[$oid])) { return; } $visited[$oid] = $entity; switch ($this->getEntityState($entity, self::STATE_DETACHED)) { case self::STATE_MANAGED: if ($this->isInIdentityMap($entity)) { $this->removeFromIdentityMap($entity); } unset($this->entityInsertions[$oid], $this->entityUpdates[$oid], $this->entityDeletions[$oid], $this->entityIdentifiers[$oid], $this->entityStates[$oid], $this->originalEntityData[$oid]); break; case self::STATE_NEW: case self::STATE_DETACHED: return; } if (!$noCascade) { $this->cascadeDetach($entity, $visited); } } public function refresh($entity) { $visited = array(); $this->doRefresh($entity, $visited); } private function doRefresh($entity, array &$visited) { $oid = \spl_object_hash($entity); if (isset($visited[$oid])) { return; } $visited[$oid] = $entity; $class = $this->em->getClassMetadata(\get_class($entity)); if ($this->getEntityState($entity) !== self::STATE_MANAGED) { throw \MailPoetVendor\Doctrine\ORM\ORMInvalidArgumentException::entityNotManaged($entity); } $this->getEntityPersister($class->name)->refresh(\array_combine($class->getIdentifierFieldNames(), $this->entityIdentifiers[$oid]), $entity); $this->cascadeRefresh($entity, $visited); } private function cascadeRefresh($entity, array &$visited) { $class = $this->em->getClassMetadata(\get_class($entity)); $associationMappings = \array_filter($class->associationMappings, function ($assoc) { return $assoc['isCascadeRefresh']; }); foreach ($associationMappings as $assoc) { $relatedEntities = $class->reflFields[$assoc['fieldName']]->getValue($entity); switch (\true) { case $relatedEntities instanceof \MailPoetVendor\Doctrine\ORM\PersistentCollection: $relatedEntities = $relatedEntities->unwrap(); case $relatedEntities instanceof \MailPoetVendor\Doctrine\Common\Collections\Collection: case \is_array($relatedEntities): foreach ($relatedEntities as $relatedEntity) { $this->doRefresh($relatedEntity, $visited); } break; case $relatedEntities !== null: $this->doRefresh($relatedEntities, $visited); break; default: } } } private function cascadeDetach($entity, array &$visited) { $class = $this->em->getClassMetadata(\get_class($entity)); $associationMappings = \array_filter($class->associationMappings, function ($assoc) { return $assoc['isCascadeDetach']; }); foreach ($associationMappings as $assoc) { $relatedEntities = $class->reflFields[$assoc['fieldName']]->getValue($entity); switch (\true) { case $relatedEntities instanceof \MailPoetVendor\Doctrine\ORM\PersistentCollection: $relatedEntities = $relatedEntities->unwrap(); case $relatedEntities instanceof \MailPoetVendor\Doctrine\Common\Collections\Collection: case \is_array($relatedEntities): foreach ($relatedEntities as $relatedEntity) { $this->doDetach($relatedEntity, $visited); } break; case $relatedEntities !== null: $this->doDetach($relatedEntities, $visited); break; default: } } } private function cascadeMerge($entity, $managedCopy, array &$visited) { $class = $this->em->getClassMetadata(\get_class($entity)); $associationMappings = \array_filter($class->associationMappings, function ($assoc) { return $assoc['isCascadeMerge']; }); foreach ($associationMappings as $assoc) { $relatedEntities = $class->reflFields[$assoc['fieldName']]->getValue($entity); if ($relatedEntities instanceof \MailPoetVendor\Doctrine\Common\Collections\Collection) { if ($relatedEntities === $class->reflFields[$assoc['fieldName']]->getValue($managedCopy)) { continue; } if ($relatedEntities instanceof \MailPoetVendor\Doctrine\ORM\PersistentCollection) { $relatedEntities = $relatedEntities->unwrap(); } foreach ($relatedEntities as $relatedEntity) { $this->doMerge($relatedEntity, $visited, $managedCopy, $assoc); } } else { if ($relatedEntities !== null) { $this->doMerge($relatedEntities, $visited, $managedCopy, $assoc); } } } } private function cascadePersist($entity, array &$visited) { $class = $this->em->getClassMetadata(\get_class($entity)); $associationMappings = \array_filter($class->associationMappings, function ($assoc) { return $assoc['isCascadePersist']; }); foreach ($associationMappings as $assoc) { $relatedEntities = $class->reflFields[$assoc['fieldName']]->getValue($entity); switch (\true) { case $relatedEntities instanceof \MailPoetVendor\Doctrine\ORM\PersistentCollection: $relatedEntities = $relatedEntities->unwrap(); case $relatedEntities instanceof \MailPoetVendor\Doctrine\Common\Collections\Collection: case \is_array($relatedEntities): if (($assoc['type'] & \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata::TO_MANY) <= 0) { throw \MailPoetVendor\Doctrine\ORM\ORMInvalidArgumentException::invalidAssociation($this->em->getClassMetadata($assoc['targetEntity']), $assoc, $relatedEntities); } foreach ($relatedEntities as $relatedEntity) { $this->doPersist($relatedEntity, $visited); } break; case $relatedEntities !== null: if (!$relatedEntities instanceof $assoc['targetEntity']) { throw \MailPoetVendor\Doctrine\ORM\ORMInvalidArgumentException::invalidAssociation($this->em->getClassMetadata($assoc['targetEntity']), $assoc, $relatedEntities); } $this->doPersist($relatedEntities, $visited); break; default: } } } private function cascadeRemove($entity, array &$visited) { $class = $this->em->getClassMetadata(\get_class($entity)); $associationMappings = \array_filter($class->associationMappings, function ($assoc) { return $assoc['isCascadeRemove']; }); $entitiesToCascade = array(); foreach ($associationMappings as $assoc) { if ($entity instanceof \MailPoetVendor\Doctrine\ORM\Proxy\Proxy && !$entity->__isInitialized__) { $entity->__load(); } $relatedEntities = $class->reflFields[$assoc['fieldName']]->getValue($entity); switch (\true) { case $relatedEntities instanceof \MailPoetVendor\Doctrine\Common\Collections\Collection: case \is_array($relatedEntities): foreach ($relatedEntities as $relatedEntity) { $entitiesToCascade[] = $relatedEntity; } break; case $relatedEntities !== null: $entitiesToCascade[] = $relatedEntities; break; default: } } foreach ($entitiesToCascade as $relatedEntity) { $this->doRemove($relatedEntity, $visited); } } public function lock($entity, $lockMode, $lockVersion = null) { if ($entity === null) { throw new \InvalidArgumentException("No entity passed to UnitOfWork#lock()."); } if ($this->getEntityState($entity, self::STATE_DETACHED) != self::STATE_MANAGED) { throw \MailPoetVendor\Doctrine\ORM\ORMInvalidArgumentException::entityNotManaged($entity); } $class = $this->em->getClassMetadata(\get_class($entity)); switch (\true) { case \MailPoetVendor\Doctrine\DBAL\LockMode::OPTIMISTIC === $lockMode: if (!$class->isVersioned) { throw \MailPoetVendor\Doctrine\ORM\OptimisticLockException::notVersioned($class->name); } if ($lockVersion === null) { return; } if ($entity instanceof \MailPoetVendor\Doctrine\ORM\Proxy\Proxy && !$entity->__isInitialized__) { $entity->__load(); } $entityVersion = $class->reflFields[$class->versionField]->getValue($entity); if ($entityVersion != $lockVersion) { throw \MailPoetVendor\Doctrine\ORM\OptimisticLockException::lockFailedVersionMismatch($entity, $lockVersion, $entityVersion); } break; case \MailPoetVendor\Doctrine\DBAL\LockMode::NONE === $lockMode: case \MailPoetVendor\Doctrine\DBAL\LockMode::PESSIMISTIC_READ === $lockMode: case \MailPoetVendor\Doctrine\DBAL\LockMode::PESSIMISTIC_WRITE === $lockMode: if (!$this->em->getConnection()->isTransactionActive()) { throw \MailPoetVendor\Doctrine\ORM\TransactionRequiredException::transactionRequired(); } $oid = \spl_object_hash($entity); $this->getEntityPersister($class->name)->lock(\array_combine($class->getIdentifierFieldNames(), $this->entityIdentifiers[$oid]), $lockMode); break; default: } } public function getCommitOrderCalculator() { if ($this->commitOrderCalculator === null) { $this->commitOrderCalculator = new \MailPoetVendor\Doctrine\ORM\Internal\CommitOrderCalculator(); } return $this->commitOrderCalculator; } public function clear($entityName = null) { if ($entityName === null) { $this->identityMap = $this->entityIdentifiers = $this->originalEntityData = $this->entityChangeSets = $this->entityStates = $this->scheduledForSynchronization = $this->entityInsertions = $this->entityUpdates = $this->entityDeletions = $this->collectionDeletions = $this->collectionUpdates = $this->extraUpdates = $this->readOnlyObjects = $this->visitedCollections = $this->orphanRemovals = array(); if ($this->commitOrderCalculator !== null) { $this->commitOrderCalculator->clear(); } } else { $this->clearIdentityMapForEntityName($entityName); $this->clearEntityInsertionsForEntityName($entityName); } if ($this->evm->hasListeners(\MailPoetVendor\Doctrine\ORM\Events::onClear)) { $this->evm->dispatchEvent(\MailPoetVendor\Doctrine\ORM\Events::onClear, new \MailPoetVendor\Doctrine\ORM\Event\OnClearEventArgs($this->em, $entityName)); } } public function scheduleOrphanRemoval($entity) { $this->orphanRemovals[\spl_object_hash($entity)] = $entity; } public function scheduleCollectionDeletion(\MailPoetVendor\Doctrine\ORM\PersistentCollection $coll) { $coid = \spl_object_hash($coll); if (isset($this->collectionUpdates[$coid])) { unset($this->collectionUpdates[$coid]); } $this->collectionDeletions[$coid] = $coll; } public function isCollectionScheduledForDeletion(\MailPoetVendor\Doctrine\ORM\PersistentCollection $coll) { return isset($this->collectionDeletions[\spl_object_hash($coll)]); } private function newInstance($class) { $entity = $class->newInstance(); if ($entity instanceof \MailPoetVendor\Doctrine\Common\Persistence\ObjectManagerAware) { $entity->injectObjectManager($this->em, $class); } return $entity; } public function createEntity($className, array $data, &$hints = array()) { $class = $this->em->getClassMetadata($className); $id = $this->identifierFlattener->flattenIdentifier($class, $data); $idHash = \implode(' ', $id); if (isset($this->identityMap[$class->rootEntityName][$idHash])) { $entity = $this->identityMap[$class->rootEntityName][$idHash]; $oid = \spl_object_hash($entity); if (isset($hints[\MailPoetVendor\Doctrine\ORM\Query::HINT_REFRESH]) && isset($hints[\MailPoetVendor\Doctrine\ORM\Query::HINT_REFRESH_ENTITY]) && ($unmanagedProxy = $hints[\MailPoetVendor\Doctrine\ORM\Query::HINT_REFRESH_ENTITY]) !== $entity && $unmanagedProxy instanceof \MailPoetVendor\Doctrine\ORM\Proxy\Proxy && $this->isIdentifierEquals($unmanagedProxy, $entity)) { foreach ($class->identifier as $fieldName) { $class->reflFields[$fieldName]->setValue($unmanagedProxy, null); } return $unmanagedProxy; } if ($entity instanceof \MailPoetVendor\Doctrine\ORM\Proxy\Proxy && !$entity->__isInitialized()) { $entity->__setInitialized(\true); $overrideLocalValues = \true; if ($entity instanceof \MailPoetVendor\Doctrine\Common\NotifyPropertyChanged) { $entity->addPropertyChangedListener($this); } } else { $overrideLocalValues = isset($hints[\MailPoetVendor\Doctrine\ORM\Query::HINT_REFRESH]); if (isset($hints[\MailPoetVendor\Doctrine\ORM\Query::HINT_REFRESH_ENTITY])) { $overrideLocalValues = $hints[\MailPoetVendor\Doctrine\ORM\Query::HINT_REFRESH_ENTITY] === $entity; } } if ($overrideLocalValues) { if ($entity instanceof \MailPoetVendor\Doctrine\Common\Persistence\ObjectManagerAware) { $entity->injectObjectManager($this->em, $class); } $this->originalEntityData[$oid] = $data; } } else { $entity = $this->newInstance($class); $oid = \spl_object_hash($entity); $this->entityIdentifiers[$oid] = $id; $this->entityStates[$oid] = self::STATE_MANAGED; $this->originalEntityData[$oid] = $data; $this->identityMap[$class->rootEntityName][$idHash] = $entity; if ($entity instanceof \MailPoetVendor\Doctrine\Common\NotifyPropertyChanged) { $entity->addPropertyChangedListener($this); } $overrideLocalValues = \true; } if (!$overrideLocalValues) { return $entity; } foreach ($data as $field => $value) { if (isset($class->fieldMappings[$field])) { $class->reflFields[$field]->setValue($entity, $value); } } unset($this->eagerLoadingEntities[$class->rootEntityName][$idHash]); if (isset($this->eagerLoadingEntities[$class->rootEntityName]) && !$this->eagerLoadingEntities[$class->rootEntityName]) { unset($this->eagerLoadingEntities[$class->rootEntityName]); } if (isset($hints[\MailPoetVendor\Doctrine\ORM\Query::HINT_FORCE_PARTIAL_LOAD])) { return $entity; } foreach ($class->associationMappings as $field => $assoc) { if (isset($hints['fetchAlias']) && isset($hints['fetched'][$hints['fetchAlias']][$field])) { continue; } $targetClass = $this->em->getClassMetadata($assoc['targetEntity']); switch (\true) { case $assoc['type'] & \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata::TO_ONE: if (!$assoc['isOwningSide']) { if (isset($data[$field]) && \is_object($data[$field]) && isset($this->entityStates[\spl_object_hash($data[$field])])) { $this->originalEntityData[$oid][$field] = $data[$field]; $class->reflFields[$field]->setValue($entity, $data[$field]); $targetClass->reflFields[$assoc['mappedBy']]->setValue($data[$field], $entity); continue 2; } $class->reflFields[$field]->setValue($entity, $this->getEntityPersister($assoc['targetEntity'])->loadOneToOneEntity($assoc, $entity)); continue 2; } if (isset($data[$field]) && \is_object($data[$field]) && isset($this->entityStates[\spl_object_hash($data[$field])])) { $class->reflFields[$field]->setValue($entity, $data[$field]); $this->originalEntityData[$oid][$field] = $data[$field]; break; } $associatedId = array(); foreach ($assoc['targetToSourceKeyColumns'] as $targetColumn => $srcColumn) { $joinColumnValue = isset($data[$srcColumn]) ? $data[$srcColumn] : null; if ($joinColumnValue !== null) { if ($targetClass->containsForeignIdentifier) { $associatedId[$targetClass->getFieldForColumn($targetColumn)] = $joinColumnValue; } else { $associatedId[$targetClass->fieldNames[$targetColumn]] = $joinColumnValue; } } elseif ($targetClass->containsForeignIdentifier && \in_array($targetClass->getFieldForColumn($targetColumn), $targetClass->identifier, \true)) { $associatedId = array(); break; } } if (!$associatedId) { $class->reflFields[$field]->setValue($entity, null); $this->originalEntityData[$oid][$field] = null; break; } if (!isset($hints['fetchMode'][$class->name][$field])) { $hints['fetchMode'][$class->name][$field] = $assoc['fetch']; } $relatedIdHash = \implode(' ', $associatedId); switch (\true) { case isset($this->identityMap[$targetClass->rootEntityName][$relatedIdHash]): $newValue = $this->identityMap[$targetClass->rootEntityName][$relatedIdHash]; if ($hints['fetchMode'][$class->name][$field] == \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata::FETCH_EAGER && isset($hints[self::HINT_DEFEREAGERLOAD]) && !$targetClass->isIdentifierComposite && $newValue instanceof \MailPoetVendor\Doctrine\ORM\Proxy\Proxy && $newValue->__isInitialized__ === \false) { $this->eagerLoadingEntities[$targetClass->rootEntityName][$relatedIdHash] = \current($associatedId); } break; case $targetClass->subClasses: $newValue = $this->getEntityPersister($assoc['targetEntity'])->loadOneToOneEntity($assoc, $entity, $associatedId); break; default: switch (\true) { case $hints['fetchMode'][$class->name][$field] !== \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata::FETCH_EAGER: $newValue = $this->em->getProxyFactory()->getProxy($assoc['targetEntity'], $associatedId); break; case isset($hints[self::HINT_DEFEREAGERLOAD]) && !$targetClass->isIdentifierComposite: $this->eagerLoadingEntities[$targetClass->rootEntityName][$relatedIdHash] = \current($associatedId); $newValue = $this->em->getProxyFactory()->getProxy($assoc['targetEntity'], $associatedId); break; default: $newValue = $this->em->find($assoc['targetEntity'], $associatedId); break; } $newValueOid = \spl_object_hash($newValue); $this->entityIdentifiers[$newValueOid] = $associatedId; $this->identityMap[$targetClass->rootEntityName][$relatedIdHash] = $newValue; if ($newValue instanceof \MailPoetVendor\Doctrine\Common\NotifyPropertyChanged && (!$newValue instanceof \MailPoetVendor\Doctrine\ORM\Proxy\Proxy || $newValue->__isInitialized())) { $newValue->addPropertyChangedListener($this); } $this->entityStates[$newValueOid] = self::STATE_MANAGED; break; } $this->originalEntityData[$oid][$field] = $newValue; $class->reflFields[$field]->setValue($entity, $newValue); if ($assoc['inversedBy'] && $assoc['type'] & \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata::ONE_TO_ONE) { $inverseAssoc = $targetClass->associationMappings[$assoc['inversedBy']]; $targetClass->reflFields[$inverseAssoc['fieldName']]->setValue($newValue, $entity); } break; default: if (isset($hints[\MailPoetVendor\Doctrine\ORM\Query::HINT_CACHE_ENABLED]) && $class->getFieldValue($entity, $field) instanceof \MailPoetVendor\Doctrine\ORM\PersistentCollection) { break; } if (isset($data[$field]) && $data[$field] instanceof \MailPoetVendor\Doctrine\ORM\PersistentCollection) { $data[$field]->setOwner($entity, $assoc); $class->reflFields[$field]->setValue($entity, $data[$field]); $this->originalEntityData[$oid][$field] = $data[$field]; break; } $pColl = new \MailPoetVendor\Doctrine\ORM\PersistentCollection($this->em, $targetClass, new \MailPoetVendor\Doctrine\Common\Collections\ArrayCollection()); $pColl->setOwner($entity, $assoc); $pColl->setInitialized(\false); $reflField = $class->reflFields[$field]; $reflField->setValue($entity, $pColl); if ($assoc['fetch'] == \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata::FETCH_EAGER) { $this->loadCollection($pColl); $pColl->takeSnapshot(); } $this->originalEntityData[$oid][$field] = $pColl; break; } } if ($overrideLocalValues) { $this->hydrationCompleteHandler->deferPostLoadInvoking($class, $entity); } return $entity; } public function triggerEagerLoads() { if (!$this->eagerLoadingEntities) { return; } $eagerLoadingEntities = $this->eagerLoadingEntities; $this->eagerLoadingEntities = array(); foreach ($eagerLoadingEntities as $entityName => $ids) { if (!$ids) { continue; } $class = $this->em->getClassMetadata($entityName); $this->getEntityPersister($entityName)->loadAll(\array_combine($class->identifier, array(\array_values($ids)))); } } public function loadCollection(\MailPoetVendor\Doctrine\ORM\PersistentCollection $collection) { $assoc = $collection->getMapping(); $persister = $this->getEntityPersister($assoc['targetEntity']); switch ($assoc['type']) { case \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata::ONE_TO_MANY: $persister->loadOneToManyCollection($assoc, $collection->getOwner(), $collection); break; case \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata::MANY_TO_MANY: $persister->loadManyToManyCollection($assoc, $collection->getOwner(), $collection); break; } $collection->setInitialized(\true); } public function getIdentityMap() { return $this->identityMap; } public function getOriginalEntityData($entity) { $oid = \spl_object_hash($entity); if (isset($this->originalEntityData[$oid])) { return $this->originalEntityData[$oid]; } return array(); } public function setOriginalEntityData($entity, array $data) { $this->originalEntityData[\spl_object_hash($entity)] = $data; } public function setOriginalEntityProperty($oid, $property, $value) { $this->originalEntityData[$oid][$property] = $value; } public function getEntityIdentifier($entity) { return $this->entityIdentifiers[\spl_object_hash($entity)]; } public function getSingleIdentifierValue($entity) { $class = $this->em->getClassMetadata(\get_class($entity)); if ($class->isIdentifierComposite) { throw \MailPoetVendor\Doctrine\ORM\ORMInvalidArgumentException::invalidCompositeIdentifier(); } $values = $this->isInIdentityMap($entity) ? $this->getEntityIdentifier($entity) : $class->getIdentifierValues($entity); return isset($values[$class->identifier[0]]) ? $values[$class->identifier[0]] : null; } public function tryGetById($id, $rootClassName) { $idHash = \implode(' ', (array) $id); if (isset($this->identityMap[$rootClassName][$idHash])) { return $this->identityMap[$rootClassName][$idHash]; } return \false; } public function scheduleForDirtyCheck($entity) { $rootClassName = $this->em->getClassMetadata(\get_class($entity))->rootEntityName; $this->scheduledForSynchronization[$rootClassName][\spl_object_hash($entity)] = $entity; } public function hasPendingInsertions() { return !empty($this->entityInsertions); } public function size() { $countArray = \array_map(function ($item) { return \count($item); }, $this->identityMap); return \array_sum($countArray); } public function getEntityPersister($entityName) { if (isset($this->persisters[$entityName])) { return $this->persisters[$entityName]; } $class = $this->em->getClassMetadata($entityName); switch (\true) { case $class->isInheritanceTypeNone(): $persister = new \MailPoetVendor\Doctrine\ORM\Persisters\Entity\BasicEntityPersister($this->em, $class); break; case $class->isInheritanceTypeSingleTable(): $persister = new \MailPoetVendor\Doctrine\ORM\Persisters\Entity\SingleTablePersister($this->em, $class); break; case $class->isInheritanceTypeJoined(): $persister = new \MailPoetVendor\Doctrine\ORM\Persisters\Entity\JoinedSubclassPersister($this->em, $class); break; default: throw new \RuntimeException('No persister found for entity.'); } if ($this->hasCache && $class->cache !== null) { $persister = $this->em->getConfiguration()->getSecondLevelCacheConfiguration()->getCacheFactory()->buildCachedEntityPersister($this->em, $persister, $class); } $this->persisters[$entityName] = $persister; return $this->persisters[$entityName]; } public function getCollectionPersister(array $association) { $role = isset($association['cache']) ? $association['sourceEntity'] . '::' . $association['fieldName'] : $association['type']; if (isset($this->collectionPersisters[$role])) { return $this->collectionPersisters[$role]; } $persister = \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata::ONE_TO_MANY === $association['type'] ? new \MailPoetVendor\Doctrine\ORM\Persisters\Collection\OneToManyPersister($this->em) : new \MailPoetVendor\Doctrine\ORM\Persisters\Collection\ManyToManyPersister($this->em); if ($this->hasCache && isset($association['cache'])) { $persister = $this->em->getConfiguration()->getSecondLevelCacheConfiguration()->getCacheFactory()->buildCachedCollectionPersister($this->em, $persister, $association); } $this->collectionPersisters[$role] = $persister; return $this->collectionPersisters[$role]; } public function registerManaged($entity, array $id, array $data) { $oid = \spl_object_hash($entity); $this->entityIdentifiers[$oid] = $id; $this->entityStates[$oid] = self::STATE_MANAGED; $this->originalEntityData[$oid] = $data; $this->addToIdentityMap($entity); if ($entity instanceof \MailPoetVendor\Doctrine\Common\NotifyPropertyChanged && (!$entity instanceof \MailPoetVendor\Doctrine\ORM\Proxy\Proxy || $entity->__isInitialized())) { $entity->addPropertyChangedListener($this); } } public function clearEntityChangeSet($oid) { $this->entityChangeSets[$oid] = array(); } public function propertyChanged($entity, $propertyName, $oldValue, $newValue) { $oid = \spl_object_hash($entity); $class = $this->em->getClassMetadata(\get_class($entity)); $isAssocField = isset($class->associationMappings[$propertyName]); if (!$isAssocField && !isset($class->fieldMappings[$propertyName])) { return; } $this->entityChangeSets[$oid][$propertyName] = array($oldValue, $newValue); if (!isset($this->scheduledForSynchronization[$class->rootEntityName][$oid])) { $this->scheduleForDirtyCheck($entity); } } public function getScheduledEntityInsertions() { return $this->entityInsertions; } public function getScheduledEntityUpdates() { return $this->entityUpdates; } public function getScheduledEntityDeletions() { return $this->entityDeletions; } public function getScheduledCollectionDeletions() { return $this->collectionDeletions; } public function getScheduledCollectionUpdates() { return $this->collectionUpdates; } public function initializeObject($obj) { if ($obj instanceof \MailPoetVendor\Doctrine\ORM\Proxy\Proxy) { $obj->__load(); return; } if ($obj instanceof \MailPoetVendor\Doctrine\ORM\PersistentCollection) { $obj->initialize(); } } private static function objToStr($obj) { return \method_exists($obj, '__toString') ? (string) $obj : \get_class($obj) . '@' . \spl_object_hash($obj); } public function markReadOnly($object) { if (!\is_object($object) || !$this->isInIdentityMap($object)) { throw \MailPoetVendor\Doctrine\ORM\ORMInvalidArgumentException::readOnlyRequiresManagedEntity($object); } $this->readOnlyObjects[\spl_object_hash($object)] = \true; } public function isReadOnly($object) { if (!\is_object($object)) { throw \MailPoetVendor\Doctrine\ORM\ORMInvalidArgumentException::readOnlyRequiresManagedEntity($object); } return isset($this->readOnlyObjects[\spl_object_hash($object)]); } private function afterTransactionComplete() { if (!$this->hasCache) { return; } foreach ($this->persisters as $persister) { if ($persister instanceof \MailPoetVendor\Doctrine\ORM\Cache\Persister\CachedPersister) { $persister->afterTransactionComplete(); } } foreach ($this->collectionPersisters as $persister) { if ($persister instanceof \MailPoetVendor\Doctrine\ORM\Cache\Persister\CachedPersister) { $persister->afterTransactionComplete(); } } } private function afterTransactionRolledBack() { if (!$this->hasCache) { return; } foreach ($this->persisters as $persister) { if ($persister instanceof \MailPoetVendor\Doctrine\ORM\Cache\Persister\CachedPersister) { $persister->afterTransactionRolledBack(); } } foreach ($this->collectionPersisters as $persister) { if ($persister instanceof \MailPoetVendor\Doctrine\ORM\Cache\Persister\CachedPersister) { $persister->afterTransactionRolledBack(); } } } private function dispatchOnFlushEvent() { if ($this->evm->hasListeners(\MailPoetVendor\Doctrine\ORM\Events::onFlush)) { $this->evm->dispatchEvent(\MailPoetVendor\Doctrine\ORM\Events::onFlush, new \MailPoetVendor\Doctrine\ORM\Event\OnFlushEventArgs($this->em)); } } private function dispatchPostFlushEvent() { if ($this->evm->hasListeners(\MailPoetVendor\Doctrine\ORM\Events::postFlush)) { $this->evm->dispatchEvent(\MailPoetVendor\Doctrine\ORM\Events::postFlush, new \MailPoetVendor\Doctrine\ORM\Event\PostFlushEventArgs($this->em)); } } private function isIdentifierEquals($entity1, $entity2) { if ($entity1 === $entity2) { return \true; } $class = $this->em->getClassMetadata(\get_class($entity1)); if ($class !== $this->em->getClassMetadata(\get_class($entity2))) { return \false; } $oid1 = \spl_object_hash($entity1); $oid2 = \spl_object_hash($entity2); $id1 = isset($this->entityIdentifiers[$oid1]) ? $this->entityIdentifiers[$oid1] : $this->identifierFlattener->flattenIdentifier($class, $class->getIdentifierValues($entity1)); $id2 = isset($this->entityIdentifiers[$oid2]) ? $this->entityIdentifiers[$oid2] : $this->identifierFlattener->flattenIdentifier($class, $class->getIdentifierValues($entity2)); return $id1 === $id2 || \implode(' ', $id1) === \implode(' ', $id2); } private function mergeEntityStateIntoManagedCopy($entity, $managedCopy) { if (!$this->isLoaded($entity)) { return; } if (!$this->isLoaded($managedCopy)) { $managedCopy->__load(); } $class = $this->em->getClassMetadata(\get_class($entity)); foreach ($this->reflectionPropertiesGetter->getProperties($class->name) as $prop) { $name = $prop->name; $prop->setAccessible(\true); if (!isset($class->associationMappings[$name])) { if (!$class->isIdentifier($name)) { $prop->setValue($managedCopy, $prop->getValue($entity)); } } else { $assoc2 = $class->associationMappings[$name]; if ($assoc2['type'] & \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata::TO_ONE) { $other = $prop->getValue($entity); if ($other === null) { $prop->setValue($managedCopy, null); } else { if ($other instanceof \MailPoetVendor\Doctrine\ORM\Proxy\Proxy && !$other->__isInitialized()) { continue; } if (!$assoc2['isCascadeMerge']) { if ($this->getEntityState($other) === self::STATE_DETACHED) { $targetClass = $this->em->getClassMetadata($assoc2['targetEntity']); $relatedId = $targetClass->getIdentifierValues($other); if ($targetClass->subClasses) { $other = $this->em->find($targetClass->name, $relatedId); } else { $other = $this->em->getProxyFactory()->getProxy($assoc2['targetEntity'], $relatedId); $this->registerManaged($other, $relatedId, array()); } } $prop->setValue($managedCopy, $other); } } } else { $mergeCol = $prop->getValue($entity); if ($mergeCol instanceof \MailPoetVendor\Doctrine\ORM\PersistentCollection && !$mergeCol->isInitialized()) { continue; } $managedCol = $prop->getValue($managedCopy); if (!$managedCol) { $managedCol = new \MailPoetVendor\Doctrine\ORM\PersistentCollection($this->em, $this->em->getClassMetadata($assoc2['targetEntity']), new \MailPoetVendor\Doctrine\Common\Collections\ArrayCollection()); $managedCol->setOwner($managedCopy, $assoc2); $prop->setValue($managedCopy, $managedCol); } if ($assoc2['isCascadeMerge']) { $managedCol->initialize(); if (!$managedCol->isEmpty() && $managedCol !== $mergeCol) { $managedCol->unwrap()->clear(); $managedCol->setDirty(\true); if ($assoc2['isOwningSide'] && $assoc2['type'] == \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata::MANY_TO_MANY && $class->isChangeTrackingNotify()) { $this->scheduleForDirtyCheck($managedCopy); } } } } } if ($class->isChangeTrackingNotify()) { $this->propertyChanged($managedCopy, $name, null, $prop->getValue($managedCopy)); } } } public function hydrationComplete() { $this->hydrationCompleteHandler->hydrationComplete(); } private function clearIdentityMapForEntityName($entityName) { if (!isset($this->identityMap[$entityName])) { return; } $visited = []; foreach ($this->identityMap[$entityName] as $entity) { $this->doDetach($entity, $visited, \false); } } private function clearEntityInsertionsForEntityName($entityName) { foreach ($this->entityInsertions as $hash => $entity) { if (\get_class($entity) === $entityName) { unset($this->entityInsertions[$hash]); } } } } 