<?php
 namespace MailPoetVendor\Symfony\Component\Finder; if (!defined('ABSPATH')) exit; use MailPoetVendor\Symfony\Component\Finder\Comparator\DateComparator; use MailPoetVendor\Symfony\Component\Finder\Comparator\NumberComparator; use MailPoetVendor\Symfony\Component\Finder\Iterator\CustomFilterIterator; use MailPoetVendor\Symfony\Component\Finder\Iterator\DateRangeFilterIterator; use MailPoetVendor\Symfony\Component\Finder\Iterator\DepthRangeFilterIterator; use MailPoetVendor\Symfony\Component\Finder\Iterator\ExcludeDirectoryFilterIterator; use MailPoetVendor\Symfony\Component\Finder\Iterator\FilecontentFilterIterator; use MailPoetVendor\Symfony\Component\Finder\Iterator\FilenameFilterIterator; use MailPoetVendor\Symfony\Component\Finder\Iterator\SizeRangeFilterIterator; use MailPoetVendor\Symfony\Component\Finder\Iterator\SortableIterator; class Finder implements \IteratorAggregate, \Countable { const IGNORE_VCS_FILES = 1; const IGNORE_DOT_FILES = 2; private $mode = 0; private $names = []; private $notNames = []; private $exclude = []; private $filters = []; private $depths = []; private $sizes = []; private $followLinks = \false; private $sort = \false; private $ignore = 0; private $dirs = []; private $dates = []; private $iterators = []; private $contains = []; private $notContains = []; private $paths = []; private $notPaths = []; private $ignoreUnreadableDirs = \false; private static $vcsPatterns = ['.svn', '_svn', 'CVS', '_darcs', '.arch-params', '.monotone', '.bzr', '.git', '.hg']; public function __construct() { $this->ignore = static::IGNORE_VCS_FILES | static::IGNORE_DOT_FILES; } public static function create() { return new static(); } public function directories() { $this->mode = \MailPoetVendor\Symfony\Component\Finder\Iterator\FileTypeFilterIterator::ONLY_DIRECTORIES; return $this; } public function files() { $this->mode = \MailPoetVendor\Symfony\Component\Finder\Iterator\FileTypeFilterIterator::ONLY_FILES; return $this; } public function depth($level) { $this->depths[] = new \MailPoetVendor\Symfony\Component\Finder\Comparator\NumberComparator($level); return $this; } public function date($date) { $this->dates[] = new \MailPoetVendor\Symfony\Component\Finder\Comparator\DateComparator($date); return $this; } public function name($pattern) { $this->names[] = $pattern; return $this; } public function notName($pattern) { $this->notNames[] = $pattern; return $this; } public function contains($pattern) { $this->contains[] = $pattern; return $this; } public function notContains($pattern) { $this->notContains[] = $pattern; return $this; } public function path($pattern) { $this->paths[] = $pattern; return $this; } public function notPath($pattern) { $this->notPaths[] = $pattern; return $this; } public function size($size) { $this->sizes[] = new \MailPoetVendor\Symfony\Component\Finder\Comparator\NumberComparator($size); return $this; } public function exclude($dirs) { $this->exclude = \array_merge($this->exclude, (array) $dirs); return $this; } public function ignoreDotFiles($ignoreDotFiles) { if ($ignoreDotFiles) { $this->ignore |= static::IGNORE_DOT_FILES; } else { $this->ignore &= ~static::IGNORE_DOT_FILES; } return $this; } public function ignoreVCS($ignoreVCS) { if ($ignoreVCS) { $this->ignore |= static::IGNORE_VCS_FILES; } else { $this->ignore &= ~static::IGNORE_VCS_FILES; } return $this; } public static function addVCSPattern($pattern) { foreach ((array) $pattern as $p) { self::$vcsPatterns[] = $p; } self::$vcsPatterns = \array_unique(self::$vcsPatterns); } public function sort(\Closure $closure) { $this->sort = $closure; return $this; } public function sortByName() { $this->sort = \MailPoetVendor\Symfony\Component\Finder\Iterator\SortableIterator::SORT_BY_NAME; return $this; } public function sortByType() { $this->sort = \MailPoetVendor\Symfony\Component\Finder\Iterator\SortableIterator::SORT_BY_TYPE; return $this; } public function sortByAccessedTime() { $this->sort = \MailPoetVendor\Symfony\Component\Finder\Iterator\SortableIterator::SORT_BY_ACCESSED_TIME; return $this; } public function sortByChangedTime() { $this->sort = \MailPoetVendor\Symfony\Component\Finder\Iterator\SortableIterator::SORT_BY_CHANGED_TIME; return $this; } public function sortByModifiedTime() { $this->sort = \MailPoetVendor\Symfony\Component\Finder\Iterator\SortableIterator::SORT_BY_MODIFIED_TIME; return $this; } public function filter(\Closure $closure) { $this->filters[] = $closure; return $this; } public function followLinks() { $this->followLinks = \true; return $this; } public function ignoreUnreadableDirs($ignore = \true) { $this->ignoreUnreadableDirs = (bool) $ignore; return $this; } public function in($dirs) { $resolvedDirs = []; foreach ((array) $dirs as $dir) { if (\is_dir($dir)) { $resolvedDirs[] = $this->normalizeDir($dir); } elseif ($glob = \glob($dir, (\defined('GLOB_BRACE') ? \GLOB_BRACE : 0) | \GLOB_ONLYDIR | \GLOB_NOSORT)) { \sort($glob); $resolvedDirs = \array_merge($resolvedDirs, \array_map([$this, 'normalizeDir'], $glob)); } else { throw new \InvalidArgumentException(\sprintf('The "%s" directory does not exist.', $dir)); } } $this->dirs = \array_merge($this->dirs, $resolvedDirs); return $this; } public function getIterator() { if (0 === \count($this->dirs) && 0 === \count($this->iterators)) { throw new \LogicException('You must call one of in() or append() methods before iterating over a Finder.'); } if (1 === \count($this->dirs) && 0 === \count($this->iterators)) { return $this->searchInDirectory($this->dirs[0]); } $iterator = new \AppendIterator(); foreach ($this->dirs as $dir) { $iterator->append($this->searchInDirectory($dir)); } foreach ($this->iterators as $it) { $iterator->append($it); } return $iterator; } public function append($iterator) { if ($iterator instanceof \IteratorAggregate) { $this->iterators[] = $iterator->getIterator(); } elseif ($iterator instanceof \Iterator) { $this->iterators[] = $iterator; } elseif ($iterator instanceof \Traversable || \is_array($iterator)) { $it = new \ArrayIterator(); foreach ($iterator as $file) { $it->append($file instanceof \SplFileInfo ? $file : new \SplFileInfo($file)); } $this->iterators[] = $it; } else { throw new \InvalidArgumentException('Finder::append() method wrong argument type.'); } return $this; } public function hasResults() { foreach ($this->getIterator() as $_) { return \true; } return \false; } public function count() { return \iterator_count($this->getIterator()); } private function searchInDirectory($dir) { $exclude = $this->exclude; $notPaths = $this->notPaths; if (static::IGNORE_VCS_FILES === (static::IGNORE_VCS_FILES & $this->ignore)) { $exclude = \array_merge($exclude, self::$vcsPatterns); } if (static::IGNORE_DOT_FILES === (static::IGNORE_DOT_FILES & $this->ignore)) { $notPaths[] = '#(^|/)\\..+(/|$)#'; } $minDepth = 0; $maxDepth = \PHP_INT_MAX; foreach ($this->depths as $comparator) { switch ($comparator->getOperator()) { case '>': $minDepth = $comparator->getTarget() + 1; break; case '>=': $minDepth = $comparator->getTarget(); break; case '<': $maxDepth = $comparator->getTarget() - 1; break; case '<=': $maxDepth = $comparator->getTarget(); break; default: $minDepth = $maxDepth = $comparator->getTarget(); } } $flags = \RecursiveDirectoryIterator::SKIP_DOTS; if ($this->followLinks) { $flags |= \RecursiveDirectoryIterator::FOLLOW_SYMLINKS; } $iterator = new \MailPoetVendor\Symfony\Component\Finder\Iterator\RecursiveDirectoryIterator($dir, $flags, $this->ignoreUnreadableDirs); if ($exclude) { $iterator = new \MailPoetVendor\Symfony\Component\Finder\Iterator\ExcludeDirectoryFilterIterator($iterator, $exclude); } $iterator = new \RecursiveIteratorIterator($iterator, \RecursiveIteratorIterator::SELF_FIRST); if ($minDepth > 0 || $maxDepth < \PHP_INT_MAX) { $iterator = new \MailPoetVendor\Symfony\Component\Finder\Iterator\DepthRangeFilterIterator($iterator, $minDepth, $maxDepth); } if ($this->mode) { $iterator = new \MailPoetVendor\Symfony\Component\Finder\Iterator\FileTypeFilterIterator($iterator, $this->mode); } if ($this->names || $this->notNames) { $iterator = new \MailPoetVendor\Symfony\Component\Finder\Iterator\FilenameFilterIterator($iterator, $this->names, $this->notNames); } if ($this->contains || $this->notContains) { $iterator = new \MailPoetVendor\Symfony\Component\Finder\Iterator\FilecontentFilterIterator($iterator, $this->contains, $this->notContains); } if ($this->sizes) { $iterator = new \MailPoetVendor\Symfony\Component\Finder\Iterator\SizeRangeFilterIterator($iterator, $this->sizes); } if ($this->dates) { $iterator = new \MailPoetVendor\Symfony\Component\Finder\Iterator\DateRangeFilterIterator($iterator, $this->dates); } if ($this->filters) { $iterator = new \MailPoetVendor\Symfony\Component\Finder\Iterator\CustomFilterIterator($iterator, $this->filters); } if ($this->paths || $notPaths) { $iterator = new \MailPoetVendor\Symfony\Component\Finder\Iterator\PathFilterIterator($iterator, $this->paths, $notPaths); } if ($this->sort) { $iteratorAggregate = new \MailPoetVendor\Symfony\Component\Finder\Iterator\SortableIterator($iterator, $this->sort); $iterator = $iteratorAggregate->getIterator(); } return $iterator; } private function normalizeDir($dir) { if ('/' === $dir) { return $dir; } $dir = \rtrim($dir, '/' . \DIRECTORY_SEPARATOR); if (\preg_match('#^(ssh2\\.)?s?ftp://#', $dir)) { $dir .= '/'; } return $dir; } } 