<?php
 namespace MailPoetVendor\Symfony\Component\Translation; if (!defined('ABSPATH')) exit; use MailPoetVendor\Symfony\Component\Config\ConfigCacheFactory; use MailPoetVendor\Symfony\Component\Config\ConfigCacheFactoryInterface; use MailPoetVendor\Symfony\Component\Config\ConfigCacheInterface; use MailPoetVendor\Symfony\Component\Translation\Exception\InvalidArgumentException; use MailPoetVendor\Symfony\Component\Translation\Exception\LogicException; use MailPoetVendor\Symfony\Component\Translation\Exception\NotFoundResourceException; use MailPoetVendor\Symfony\Component\Translation\Exception\RuntimeException; use MailPoetVendor\Symfony\Component\Translation\Formatter\ChoiceMessageFormatterInterface; use MailPoetVendor\Symfony\Component\Translation\Formatter\MessageFormatter; use MailPoetVendor\Symfony\Component\Translation\Formatter\MessageFormatterInterface; use MailPoetVendor\Symfony\Component\Translation\Loader\LoaderInterface; class Translator implements \MailPoetVendor\Symfony\Component\Translation\TranslatorInterface, \MailPoetVendor\Symfony\Component\Translation\TranslatorBagInterface { protected $catalogues = []; private $locale; private $fallbackLocales = []; private $loaders = []; private $resources = []; private $formatter; private $cacheDir; private $debug; private $configCacheFactory; public function __construct($locale, $formatter = null, $cacheDir = null, $debug = \false) { $this->setLocale($locale); if ($formatter instanceof \MailPoetVendor\Symfony\Component\Translation\MessageSelector) { $formatter = new \MailPoetVendor\Symfony\Component\Translation\Formatter\MessageFormatter($formatter); @\trigger_error(\sprintf('Passing a "%s" instance into the "%s()" method as a second argument is deprecated since Symfony 3.4 and will be removed in 4.0. Inject a "%s" implementation instead.', \MailPoetVendor\Symfony\Component\Translation\MessageSelector::class, __METHOD__, \MailPoetVendor\Symfony\Component\Translation\Formatter\MessageFormatterInterface::class), \E_USER_DEPRECATED); } elseif (null === $formatter) { $formatter = new \MailPoetVendor\Symfony\Component\Translation\Formatter\MessageFormatter(); } $this->formatter = $formatter; $this->cacheDir = $cacheDir; $this->debug = $debug; } public function setConfigCacheFactory(\MailPoetVendor\Symfony\Component\Config\ConfigCacheFactoryInterface $configCacheFactory) { $this->configCacheFactory = $configCacheFactory; } public function addLoader($format, \MailPoetVendor\Symfony\Component\Translation\Loader\LoaderInterface $loader) { $this->loaders[$format] = $loader; } public function addResource($format, $resource, $locale, $domain = null) { if (null === $domain) { $domain = 'messages'; } $this->assertValidLocale($locale); $this->resources[$locale][] = [$format, $resource, $domain]; if (\in_array($locale, $this->fallbackLocales)) { $this->catalogues = []; } else { unset($this->catalogues[$locale]); } } public function setLocale($locale) { $this->assertValidLocale($locale); $this->locale = $locale; } public function getLocale() { return $this->locale; } public function setFallbackLocales(array $locales) { $this->catalogues = []; foreach ($locales as $locale) { $this->assertValidLocale($locale); } $this->fallbackLocales = $locales; } public function getFallbackLocales() { return $this->fallbackLocales; } public function trans($id, array $parameters = [], $domain = null, $locale = null) { if (null === $domain) { $domain = 'messages'; } return $this->formatter->format($this->getCatalogue($locale)->get((string) $id, $domain), $locale, $parameters); } public function transChoice($id, $number, array $parameters = [], $domain = null, $locale = null) { if (!$this->formatter instanceof \MailPoetVendor\Symfony\Component\Translation\Formatter\ChoiceMessageFormatterInterface) { throw new \MailPoetVendor\Symfony\Component\Translation\Exception\LogicException(\sprintf('The formatter "%s" does not support plural translations.', \get_class($this->formatter))); } if (null === $domain) { $domain = 'messages'; } $id = (string) $id; $catalogue = $this->getCatalogue($locale); $locale = $catalogue->getLocale(); while (!$catalogue->defines($id, $domain)) { if ($cat = $catalogue->getFallbackCatalogue()) { $catalogue = $cat; $locale = $catalogue->getLocale(); } else { break; } } return $this->formatter->choiceFormat($catalogue->get($id, $domain), $number, $locale, $parameters); } public function getCatalogue($locale = null) { if (null === $locale) { $locale = $this->getLocale(); } else { $this->assertValidLocale($locale); } if (!isset($this->catalogues[$locale])) { $this->loadCatalogue($locale); } return $this->catalogues[$locale]; } protected function getLoaders() { return $this->loaders; } protected function loadCatalogue($locale) { if (null === $this->cacheDir) { $this->initializeCatalogue($locale); } else { $this->initializeCacheCatalogue($locale); } } protected function initializeCatalogue($locale) { $this->assertValidLocale($locale); try { $this->doLoadCatalogue($locale); } catch (\MailPoetVendor\Symfony\Component\Translation\Exception\NotFoundResourceException $e) { if (!$this->computeFallbackLocales($locale)) { throw $e; } } $this->loadFallbackCatalogues($locale); } private function initializeCacheCatalogue($locale) { if (isset($this->catalogues[$locale])) { return; } $this->assertValidLocale($locale); $cache = $this->getConfigCacheFactory()->cache($this->getCatalogueCachePath($locale), function (\MailPoetVendor\Symfony\Component\Config\ConfigCacheInterface $cache) use($locale) { $this->dumpCatalogue($locale, $cache); }); if (isset($this->catalogues[$locale])) { return; } $this->catalogues[$locale] = (include $cache->getPath()); } private function dumpCatalogue($locale, \MailPoetVendor\Symfony\Component\Config\ConfigCacheInterface $cache) { $this->initializeCatalogue($locale); $fallbackContent = $this->getFallbackContent($this->catalogues[$locale]); $content = \sprintf(<<<EOF
<?php

use Symfony\\Component\\Translation\\MessageCatalogue;

\$catalogue = new MessageCatalogue('%s', %s);

%s
return \$catalogue;

EOF
, $locale, \var_export($this->catalogues[$locale]->all(), \true), $fallbackContent); $cache->write($content, $this->catalogues[$locale]->getResources()); } private function getFallbackContent(\MailPoetVendor\Symfony\Component\Translation\MessageCatalogue $catalogue) { $fallbackContent = ''; $current = ''; $replacementPattern = '/[^a-z0-9_]/i'; $fallbackCatalogue = $catalogue->getFallbackCatalogue(); while ($fallbackCatalogue) { $fallback = $fallbackCatalogue->getLocale(); $fallbackSuffix = \ucfirst(\preg_replace($replacementPattern, '_', $fallback)); $currentSuffix = \ucfirst(\preg_replace($replacementPattern, '_', $current)); $fallbackContent .= \sprintf(<<<'EOF'
$catalogue%s = new MessageCatalogue('%s', %s);
$catalogue%s->addFallbackCatalogue($catalogue%s);

EOF
, $fallbackSuffix, $fallback, \var_export($fallbackCatalogue->all(), \true), $currentSuffix, $fallbackSuffix); $current = $fallbackCatalogue->getLocale(); $fallbackCatalogue = $fallbackCatalogue->getFallbackCatalogue(); } return $fallbackContent; } private function getCatalogueCachePath($locale) { return $this->cacheDir . '/catalogue.' . $locale . '.' . \strtr(\substr(\base64_encode(\hash('sha256', \serialize($this->fallbackLocales), \true)), 0, 7), '/', '_') . '.php'; } private function doLoadCatalogue($locale) { $this->catalogues[$locale] = new \MailPoetVendor\Symfony\Component\Translation\MessageCatalogue($locale); if (isset($this->resources[$locale])) { foreach ($this->resources[$locale] as $resource) { if (!isset($this->loaders[$resource[0]])) { if (\is_string($resource[1])) { throw new \MailPoetVendor\Symfony\Component\Translation\Exception\RuntimeException(\sprintf('No loader is registered for the "%s" format when loading the "%s" resource.', $resource[0], $resource[1])); } throw new \MailPoetVendor\Symfony\Component\Translation\Exception\RuntimeException(\sprintf('No loader is registered for the "%s" format.', $resource[0])); } $this->catalogues[$locale]->addCatalogue($this->loaders[$resource[0]]->load($resource[1], $locale, $resource[2])); } } } private function loadFallbackCatalogues($locale) { $current = $this->catalogues[$locale]; foreach ($this->computeFallbackLocales($locale) as $fallback) { if (!isset($this->catalogues[$fallback])) { $this->initializeCatalogue($fallback); } $fallbackCatalogue = new \MailPoetVendor\Symfony\Component\Translation\MessageCatalogue($fallback, $this->catalogues[$fallback]->all()); foreach ($this->catalogues[$fallback]->getResources() as $resource) { $fallbackCatalogue->addResource($resource); } $current->addFallbackCatalogue($fallbackCatalogue); $current = $fallbackCatalogue; } } protected function computeFallbackLocales($locale) { $locales = []; foreach ($this->fallbackLocales as $fallback) { if ($fallback === $locale) { continue; } $locales[] = $fallback; } if (\function_exists('locale_parse')) { $localeSubTags = \locale_parse($locale); if (1 < \count($localeSubTags)) { \array_pop($localeSubTags); $fallback = \locale_compose($localeSubTags); if (\false !== $fallback) { \array_unshift($locales, $fallback); } } } elseif (\false !== \strrchr($locale, '_')) { \array_unshift($locales, \substr($locale, 0, -\strlen(\strrchr($locale, '_')))); } elseif (\false !== \strrchr($locale, '-')) { \array_unshift($locales, \substr($locale, 0, -\strlen(\strrchr($locale, '-')))); } return \array_unique($locales); } protected function assertValidLocale($locale) { if (1 !== \preg_match('/^[a-z0-9@_\\.\\-]*$/i', $locale)) { throw new \MailPoetVendor\Symfony\Component\Translation\Exception\InvalidArgumentException(\sprintf('Invalid "%s" locale.', $locale)); } } private function getConfigCacheFactory() { if (!$this->configCacheFactory) { $this->configCacheFactory = new \MailPoetVendor\Symfony\Component\Config\ConfigCacheFactory($this->debug); } return $this->configCacheFactory; } } 