<?php
 namespace MailPoetVendor\Symfony\Component\Validator\Constraints; if (!defined('ABSPATH')) exit; use MailPoetVendor\Symfony\Component\Validator\Constraint; use MailPoetVendor\Symfony\Component\Validator\ConstraintValidator; use MailPoetVendor\Symfony\Component\Validator\Exception\UnexpectedTypeException; class UuidValidator extends \MailPoetVendor\Symfony\Component\Validator\ConstraintValidator { const STRICT_LENGTH = 36; const STRICT_FIRST_HYPHEN_POSITION = 8; const STRICT_LAST_HYPHEN_POSITION = 23; const STRICT_VERSION_POSITION = 14; const STRICT_VARIANT_POSITION = 19; const LOOSE_MAX_LENGTH = 39; const LOOSE_FIRST_HYPHEN_POSITION = 4; public function validate($value, \MailPoetVendor\Symfony\Component\Validator\Constraint $constraint) { if (!$constraint instanceof \MailPoetVendor\Symfony\Component\Validator\Constraints\Uuid) { throw new \MailPoetVendor\Symfony\Component\Validator\Exception\UnexpectedTypeException($constraint, \MailPoetVendor\Symfony\Component\Validator\Constraints\Uuid::class); } if (null === $value || '' === $value) { return; } if (!\is_scalar($value) && !(\is_object($value) && \method_exists($value, '__toString'))) { throw new \MailPoetVendor\Symfony\Component\Validator\Exception\UnexpectedTypeException($value, 'string'); } $value = (string) $value; if ($constraint->strict) { $this->validateStrict($value, $constraint); return; } $this->validateLoose($value, $constraint); } private function validateLoose($value, \MailPoetVendor\Symfony\Component\Validator\Constraints\Uuid $constraint) { $trimmed = \trim($value, '[]{}'); $h = self::LOOSE_FIRST_HYPHEN_POSITION; $l = self::LOOSE_MAX_LENGTH; for ($i = 0; $i < $l; ++$i) { if (!isset($trimmed[$i])) { $this->context->buildViolation($constraint->message)->setParameter('{{ value }}', $this->formatValue($value))->setCode(\MailPoetVendor\Symfony\Component\Validator\Constraints\Uuid::TOO_SHORT_ERROR)->addViolation(); return; } if ('-' === $trimmed[$i]) { if ($i !== $h) { $this->context->buildViolation($constraint->message)->setParameter('{{ value }}', $this->formatValue($value))->setCode(\MailPoetVendor\Symfony\Component\Validator\Constraints\Uuid::INVALID_HYPHEN_PLACEMENT_ERROR)->addViolation(); return; } $h += 5; continue; } if ($i === $h) { $h += 4; --$l; } if (!\ctype_xdigit($trimmed[$i])) { $this->context->buildViolation($constraint->message)->setParameter('{{ value }}', $this->formatValue($value))->setCode(\MailPoetVendor\Symfony\Component\Validator\Constraints\Uuid::INVALID_CHARACTERS_ERROR)->addViolation(); return; } } if (isset($trimmed[$i])) { $this->context->buildViolation($constraint->message)->setParameter('{{ value }}', $this->formatValue($value))->setCode(\MailPoetVendor\Symfony\Component\Validator\Constraints\Uuid::TOO_LONG_ERROR)->addViolation(); } } private function validateStrict($value, \MailPoetVendor\Symfony\Component\Validator\Constraints\Uuid $constraint) { $h = self::STRICT_FIRST_HYPHEN_POSITION; for ($i = 0; $i < self::STRICT_LENGTH; ++$i) { if (!isset($value[$i])) { $this->context->buildViolation($constraint->message)->setParameter('{{ value }}', $this->formatValue($value))->setCode(\MailPoetVendor\Symfony\Component\Validator\Constraints\Uuid::TOO_SHORT_ERROR)->addViolation(); return; } if ('-' === $value[$i]) { if ($i !== $h) { $this->context->buildViolation($constraint->message)->setParameter('{{ value }}', $this->formatValue($value))->setCode(\MailPoetVendor\Symfony\Component\Validator\Constraints\Uuid::INVALID_HYPHEN_PLACEMENT_ERROR)->addViolation(); return; } if ($h < self::STRICT_LAST_HYPHEN_POSITION) { $h += 5; } continue; } if (!\ctype_xdigit($value[$i])) { $this->context->buildViolation($constraint->message)->setParameter('{{ value }}', $this->formatValue($value))->setCode(\MailPoetVendor\Symfony\Component\Validator\Constraints\Uuid::INVALID_CHARACTERS_ERROR)->addViolation(); return; } if ($i === $h) { $this->context->buildViolation($constraint->message)->setParameter('{{ value }}', $this->formatValue($value))->setCode(\MailPoetVendor\Symfony\Component\Validator\Constraints\Uuid::INVALID_HYPHEN_PLACEMENT_ERROR)->addViolation(); return; } } if (isset($value[$i])) { $this->context->buildViolation($constraint->message)->setParameter('{{ value }}', $this->formatValue($value))->setCode(\MailPoetVendor\Symfony\Component\Validator\Constraints\Uuid::TOO_LONG_ERROR)->addViolation(); } if (!\in_array($value[self::STRICT_VERSION_POSITION], $constraint->versions)) { $this->context->buildViolation($constraint->message)->setParameter('{{ value }}', $this->formatValue($value))->setCode(\MailPoetVendor\Symfony\Component\Validator\Constraints\Uuid::INVALID_VERSION_ERROR)->addViolation(); } if (8 !== (\hexdec($value[self::STRICT_VARIANT_POSITION]) & 12)) { $this->context->buildViolation($constraint->message)->setParameter('{{ value }}', $this->formatValue($value))->setCode(\MailPoetVendor\Symfony\Component\Validator\Constraints\Uuid::INVALID_VARIANT_ERROR)->addViolation(); } } } 