<?php

if ( ! defined( 'ABSPATH' ) ) exit;

/**
*
* Sets the text domain for plugin's translations
*
*/
function waveplayer_load_languages() {
	load_plugin_textdomain('waveplayer', false, basename( dirname( dirname( __FILE__ ) ) )  . '/languages' );
}
add_action('plugins_loaded', 'waveplayer_load_languages');



function waveplayer_script_vars() {
	global $waveplayer_nonce;
	global $waveplayer_options;
	global $post;

	$options = $waveplayer_options;
	$options['site'] = get_bloginfo();
	if ( defined( 'WOOCOMMERCE_ACTIVE') ) $options['cartURL'] = wc_get_cart_url();
	$user_id = get_current_user_id();
    $user_info = get_userdata( $user_id );
    if ( !$user_info ) {
        $user_info['ID'] = '0';
        $user_info['avatar'] = get_avatar( $user_id );
    } else {
        $user_info->avatar = get_avatar( $user_id );
    }

	return array(
		'ajax_url'				=>	admin_url( 'admin-ajax.php' ),
		'nonce'					=>	$waveplayer_nonce,
		'post_id'				=>	isset( $post ) ? $post->ID : 0,
		'options'				=>	$options,
		'currentUser'			=>	$user_info,
		'thumbHeight'			=>	waveplayer_playlist_thumbnail_size()['height'],
		'messages'				=>	array(
			'audioAnalysis'			=>	__( 'audio analysis in progress&hellip;', 'waveplayer' ),
			'savingPeaks'			=>	__( 'saving the peak file&hellip;', 'waveplayer' ),
			'waveformRendering'		=>	__( 'rendering the waveform&hellip;', 'waveplayer' ),
			'playedTimes'			=>	__( 'Played %s times', 'waveplayer' ),
			'likedBy'				=>	__( 'Liked by %s users', 'waveplayer' ),
			'downloadedBy'			=>	__( 'Downloaded by %s users', 'waveplayer' ),
			'alreadyInCart'			=>	__( 'Already in cart: go to cart', 'waveplayer' ),
			'addToCart'				=>	__( 'Add to cart', 'waveplayer' ),
			'totalRuntime'			=>	__( 'Total runtime: %s', 'waveplayer' ),
			'trackLength'			=>	__( 'Track length: %s', 'waveplayer' ),
			'share'					=>	__( 'Share', 'waveplayer' ),
		)
	);
}


/**
*
* Enqueues styles and scripts for both the front end and the back end
* (since the plugin also overrides the default audio element,
* styles and scripts must be enqueued also for the back end)
*
*/
function waveplayer_enqueue_scripts() {
	global $waveplayer_options;

	$min = defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ? '' : '.min';

//  Adds the required dependency scripts
	$deps = array( 'jquery', 'underscore' );

//  Adds Font Awesome support to the plugin
	wp_register_style('font-awesome-5', 'https://use.fontawesome.com/releases/v5.1.0/css/all.css');
	wp_enqueue_style('font-awesome-5');

//  Adds custom style to the front-end
	wp_register_style('waveplayer_style', plugins_url( "/assets/css/style$min.css" , dirname(__FILE__) ), array(), WAVEPLAYER_VERSION.WAVEPLAYER_BUILD);
	wp_enqueue_style('waveplayer_style');
	if ( isset($waveplayer_options['custom_css']) && $waveplayer_options['custom_css'] !== '' ) {
    	wp_add_inline_style( 'waveplayer_style', $waveplayer_options['custom_css'] );
	}

// // Adds wavesurfer.js support to the plugin
// 	wp_register_script('wavesurfer', '//cdn.cdnjs.net/wavesurfer.js/1.0.53/wavesurfer.min.js');
// 	wp_enqueue_script('wavesurfer');

// // Adds wavesurfer.js support to the plugin
// 	wp_register_script('wavesurfer', '//cdnjs.cloudflare.com/ajax/libs/wavesurfer.js/2.0.6/wavesurfer.js');
// 	wp_enqueue_script('wavesurfer');

//  Adds custom scripts to the front-end
	wp_register_script('waveplayer_class', plugins_url( "/assets/js/waveplayer$min.js", dirname(__FILE__) ), $deps, WAVEPLAYER_VERSION.WAVEPLAYER_BUILD);
	wp_enqueue_script('waveplayer_class');

	if ( function_exists( 'wp_add_inline_script' ) && isset($waveplayer_options['custom_js']) && $waveplayer_options['custom_js'] !== '' ) {
		$custom_js = '(function($){' . $waveplayer_options['custom_js'] . '})(jQuery);';
		wp_add_inline_script( 'waveplayer_class', $custom_js );
	}

	wp_localize_script( 'waveplayer_class', 'wvplVars', waveplayer_script_vars() );

}
add_action('enqueue_embed_scripts', 'waveplayer_enqueue_scripts', 0);
add_action('wp_enqueue_scripts', 'waveplayer_enqueue_scripts', 0);
add_action('admin_enqueue_scripts', 'waveplayer_enqueue_scripts', 0);


/**
*
* Enqueues the scripts for the back end only
*
*/
function waveplayer_admin_enqueue_scripts() {
	$min = defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ? '' : '.min';

	$deps = array( 'jquery', 'underscore', 'mce-view', 'wp-color-picker', 'media-views' );

    wp_enqueue_style( 'wp-color-picker' );
    wp_enqueue_media();

//  Adds custom scripts to the front-end
	wp_register_script('waveplayer_media_waveplayer', plugins_url( "/assets/js/media-waveplayer$min.js", dirname(__FILE__) ), $deps, WAVEPLAYER_VERSION.WAVEPLAYER_BUILD);
	wp_enqueue_script('waveplayer_media_waveplayer');

	wp_register_script('waveplayer_admin_scripts', plugins_url( "/assets/js/admin-scripts$min.js", dirname(__FILE__) ), $deps, WAVEPLAYER_VERSION.WAVEPLAYER_BUILD);
	wp_enqueue_script('waveplayer_admin_scripts');

// 	wp_localize_script( 'waveplayer_admin_scripts', 'waveplayer_ajax', array( 'ajax_url' => admin_url( 'admin-ajax.php' ), 'nonce' => $waveplayer_nonce ) );

	wp_register_style('waveplayer_admin_style', plugins_url( "/assets/css/admin_style$min.css" , dirname(__FILE__) ), array(), WAVEPLAYER_VERSION.WAVEPLAYER_BUILD);
	wp_enqueue_style('waveplayer_admin_style');

}
add_action('admin_enqueue_scripts', 'waveplayer_admin_enqueue_scripts', 0);


function waveplayer_admin_print_style(){
	$taxonomies = get_object_taxonomies( 'attachment:audio', 'names' );
	$cfl = array_map( function($item) {
		return ".compat-field-$item .label";
	}, $taxonomies );
	$cfls = array_map( function($item) {
		return ".compat-field-$item .label span";
	}, $taxonomies );
	$cff = array_map( function($item) {
		return ".compat-field-$item .field";
	}, $taxonomies );
	$cfl = implode(",", array_merge($cfl,$cff) ) . "{float: none;width: 100%;}";
	$cfls = implode(",", $cfls) . "{text-align:left;}";
	foreach( $taxonomies as $taxonomy ) {

	}
?>
	<style>
		.wvpl-taxonomydiv ul {column-count:2;}
		.wvpl-taxonomydiv div.tabs-panel{max-height:100%;}
		.attachment-details .wvpl-taxonomydiv input[type=radio],
		.attachment-details .wvpl-taxonomydiv input[type=checkbox] {margin:-4px 4px 0 0;}
		<?php echo $cfl . $cfls; ?>
	</style>
<?php
}
add_action( 'admin_head', 'waveplayer_admin_print_style', 99999 );



?>
