<?php

if ( ! defined( 'ABSPATH' ) ) exit;


function waveplayer_template( $template, $args = array() ) {
    global $waveplayer_options;

    if (is_array($args)) extract($args);

    ob_start();

    if ( file_exists( get_stylesheet_directory() . "/waveplayer/$template.php" ) ) {
        include( get_stylesheet_directory() . "/waveplayer/$template.php" );
    } else {
        include( plugin_dir_path( dirname(__FILE__) ) . "templates/$template.php" );
    }

    return ob_get_clean();
}


function waveplayer_placeholder_templates() {

    $placeholder_templates = array();
    foreach (glob( plugin_dir_path( dirname(__FILE__) ) . "templates/placeholders/*.php" ) as $filename) {
        $placeholder_templates[] = basename($filename, '.php');
    }
    foreach (glob( get_stylesheet_directory() . "/waveplayer/placeholders/*.php" ) as $filename) {
        $placeholder_templates[] = basename($filename, '.php');
    }
    $placeholder_templates = array_unique($placeholder_templates);

?>

    <script type="text/html" id="tmpl-placeholders">
        <%  var s = track[ key ] || '';
            switch (key) {
                <?php foreach ( $placeholder_templates as $tmpl ) { ?>
                    case '<?php echo $tmpl; ?>': %>
                        <?php echo waveplayer_template("placeholders/$tmpl"); ?>
                        <%  break;
                <?php } ?>
                default: %>
                    <?php echo waveplayer_template('placeholders/default'); ?>
                <%  break;
        } %>
    </script>

<?php
}
add_action( 'wp_footer', 'waveplayer_placeholder_templates', 100 );
