<?php

if ( ! defined( 'ABSPATH' ) ) exit;

if ( defined( 'WOOCOMMERCE_ACTIVE') ) {

    function waveplayer_woocommerce_init() {
        global $waveplayer_options;

        $shop_player = $waveplayer_options['woocommerce_shop_player'];
        $product_player = $waveplayer_options['woocommerce_product_player'];

        if ( 'none' != $product_player ) {
            switch ( $product_player ) {
                case 'before':
                    add_action( 'woocommerce_single_product_summary', 'waveplayer_woocommerce_add_player', 4 );
                    break;
                case 'after':
                    add_action( 'woocommerce_single_product_summary', 'waveplayer_woocommerce_add_player', 6 );
                    break;
                case 'after_summary';
                    add_action( 'woocommerce_after_single_product_summary', 'waveplayer_woocommerce_add_player', 5 );
                    break;
            }
        }

        if ( $waveplayer_options['woocommerce_replace_product_image'] ) {
            add_filter( 'woocommerce_single_product_image_thumbnail_html', 'waveplayer_woocommerce_single_product_image', 10, 2 );
            add_filter( 'woocommerce_product_get_image', 'waveplayer_woocommerce_product_get_image', 10, 5 );
        }

        if ( $waveplayer_options['woocommerce_remove_shop_image'] ) {
			add_filter( 'post_class', 'waveplayer_woocommerce_loop_class', 25, 3 );
		}

        if ( 'none' != $shop_player ) {
            add_action( 'woocommerce_shop_loop_item_title', 'waveplayer_woocommerce_add_player', $shop_player == 'before' ? 5 : 15 );
        }

        add_action( 'woocommerce_product_options_advanced', 'waveplayer_woocommerce_add_preview_files' );
        add_action( 'woocommerce_process_product_meta', 'waveplayer_woocommerce_save_preview_files' );
        add_action( 'woocommerce_process_product_meta', 'waveplayer_woocommerce_save_music_type' );

        add_action( 'wp_ajax_waveplayer_add_to_cart', 'waveplayer_ajax_add_to_cart' );
        add_action( 'wp_ajax_nopriv_waveplayer_add_to_cart', 'waveplayer_ajax_add_to_cart' );

        add_action( 'wp_ajax_waveplayer_create_product', 'waveplayer_ajax_create_product' );

        add_filter( 'waveplayer_add_track_info', 'waveplayer_add_product_info_to_track', 10, 3 );
    }

    function waveplayer_woocommerce_loop_class( $classes, $class = '', $post_id = '' ) {
		if ( ! $post_id || ! in_array( get_post_type( $post_id ), array( 'product', 'product_variation' ) ) ) {
			return $classes;
		}
		if ( get_post_meta( $post_id, '_preview_files', true) ) {
			$classes[] = 'waveplayer-no-thumbnail';
		}
		return $classes;
	}


    function waveplayer_get_product_thumbnail( $post_id = 0, $size = 'shop_catalog' ) {
        global $post;

		if ( !$post_id ) $post_id = $post->ID;
        $image_size = apply_filters( 'single_product_archive_thumbnail_size', $size );

        if ( has_post_thumbnail( $post_id ) ) {
            $props = wc_get_product_attachment_props( get_post_thumbnail_id(), $post );
            $image = get_the_post_thumbnail( $post_id, $image_size, array(
                'title'  => $props['title'],
                'alt'	 => $props['alt']
            ) );
        } else if ( $image = waveplayer_get_preview_files_thumbnail( $post_id, $image_size, null ) ) {
            // Product has preview files with at least one featured image
        } else if ( wc_placeholder_img_src() ) {
            $image = wc_placeholder_img( $image_size );
        }
        return $image;
    }

    function waveplayer_woocommerce_single_product_image( $html, $post_thumbnail_id ) {
        global $post;

        if ( !has_post_thumbnail( $post->ID ) && $thumbnail_id = waveplayer_get_preview_files_thumbnail_id( $post->ID ) ) {
            $html  = wc_get_gallery_image_html( $thumbnail_id, true );
		}
        return $html;
    }

    function waveplayer_woocommerce_product_get_image( $image, $product, $size, $attr, $placeholder ) {
        if ( has_post_thumbnail( $product->get_id() ) ) {
			$image = get_the_post_thumbnail( $product->get_id(), $size, $attr );
		} elseif ( ( $parent_id = wp_get_post_parent_id( $product->get_id() ) ) && has_post_thumbnail( $parent_id ) ) { // @phpcs:ignore Squiz.PHP.DisallowMultipleAssignments.Found
			$image = get_the_post_thumbnail( $parent_id, $size, $attr );
        } else if ( $image = waveplayer_get_preview_files_thumbnail( $product->get_id(), $size, $attr ) ) {
            // Product has preview files with at least one featured image
		} elseif ( $placeholder ) {
			$image = wc_placeholder_img( $size );
		} else {
			$image = '';
		}

        return $image;
    }


    function waveplayer_get_preview_files_thumbnail_id( $post_id ) {
        $preview_files = get_post_meta( $post_id, '_preview_files', true);
        if ( $preview_files ) {
            if ( !is_array( $preview_files ) ) {
                $files = explode( ',', $preview_files );
                foreach( $files as $file ) {
                    $preview_file_id = waveplayer_get_audio_attachment_id( $file );
                    if ( $thumbnail_id = get_post_thumbnail_id( $preview_file_id ) ) return $thumbnail_id;
                }
            } else {
                foreach( $preview_files as $key => $file ) {
                    $preview_file_id = waveplayer_get_audio_attachment_id( $file['file'] );
                    if ( $thumbnail_id = get_post_thumbnail_id( $preview_file_id ) ) return $thumbnail_id;
                }
            }
        }
        return false;
    }

    function waveplayer_get_preview_files_thumbnail( $post_id, $size = 'shop_catalog', $attr ) {
        $thumbnail = false;
        if ( $preview_file_id = waveplayer_get_preview_files_thumbnail_id($post_id) ) {
            $thumbnail = wp_get_attachment_image( $preview_file_id, $size, false, $attr );
        }
        return $thumbnail;
    }


    function waveplayer_woocommerce_cart_item_thumbnail( $content, $cart_item, $cart_item_key ) {
        return waveplayer_get_product_thumbnail($cart_item['product_id'], 'thumbnail');
    }


    function waveplayer_woocommerce_add_preview_files() {
        global $post;

        $post_id = $post->ID;
    ?>
        <p class="form-field _music_type_field">
            <label for="_music_type">Music type</label>
            <select id="_music_type" name="_music_type" class="select short" style="">
                <option value="single" <?php selected(get_post_meta( $post_id, '_music_type', true ) == 'single'); ?>>Single</option>
                <option value="album" <?php selected(get_post_meta( $post_id, '_music_type', true ) == 'album'); ?>>Album</option>
            </select>
            <span class="description">Choose a music type.</span>
        </p>
        <div class="form-field preview_files">
            <label>Preview files</label>
            <table class="widefat">
                <thead>
                    <tr>
                        <th class="sort">&nbsp;</th>
                        <th>Name <span class="woocommerce-help-tip"></span></th>
                        <th colspan="2">File URL <span class="woocommerce-help-tip"></span></th>
                        <th>&nbsp;</th>
                    </tr>
                </thead>
                <tbody class="ui-sortable">
                    <?php
                    $preview_files = get_post_meta( $post_id, '_preview_files', true );

                    if ( $preview_files ) {
                        if ( !is_array( $preview_files ) ) { ?>
        	                    <tr>
                	            	<td class="sort"></td>
                        	    	<td class="file_name"><input type="text" class="input_text" placeholder="<?php esc_attr_e( 'File Name', 'woocommerce' ); ?>" name="_wc_preview_file_names[]" value="" /></td>
                        	    	<td class="file_url"><input type="text" class="input_text" placeholder="<?php esc_attr_e( "http://", 'woocommerce' ); ?>" name="_wc_preview_file_urls[]" value="<?php echo esc_attr( $preview_files ); ?>" /></td>
                            		<td class="file_url_choose" width="1%"><a href="#" class="button upload_preview_button" data-choose="<?php esc_attr_e( 'Choose file', 'woocommerce' ); ?>" data-update="<?php esc_attr_e( 'Insert file URL', 'woocommerce' ); ?>"><?php echo str_replace( ' ', '&nbsp;', __( 'Choose file', 'woocommerce' ) ); ?></a></td>
                            		<td width="1%"><a href="#" class="delete"><?php _e( 'Delete', 'woocommerce' ); ?></a></td>
                            	</tr>
                        <?php } else {
	                        foreach ( $preview_files as $key => $file ) { ?>
        	                    <tr>
                	            	<td class="sort"></td>
                        	    	<td class="file_name"><input type="text" class="input_text" placeholder="<?php esc_attr_e( 'File Name', 'woocommerce' ); ?>" name="_wc_preview_file_names[]" value="<?php echo esc_attr( $file['name'] ); ?>" /></td>
                        	    	<td class="file_url"><input type="text" class="input_text" placeholder="<?php esc_attr_e( "http://", 'woocommerce' ); ?>" name="_wc_preview_file_urls[]" value="<?php echo esc_attr( $file['file'] ); ?>" /></td>
                            		<td class="file_url_choose" width="1%"><a href="#" class="button upload_preview_button" data-choose="<?php esc_attr_e( 'Choose file', 'woocommerce' ); ?>" data-update="<?php esc_attr_e( 'Insert file URL', 'woocommerce' ); ?>"><?php echo str_replace( ' ', '&nbsp;', __( 'Choose file', 'woocommerce' ) ); ?></a></td>
                            		<td width="1%"><a href="#" class="delete"><?php _e( 'Delete', 'woocommerce' ); ?></a></td>
                            	</tr>
	                        <?php }
			            }
                    } ?>
                </tbody>
                <tfoot>
                    <tr>
                        <th colspan="5">
                            <a href="#" class="button insert" data-row="<tr>
    <td class=&quot;sort&quot;></td>
    <td class=&quot;file_name&quot;><input type=&quot;text&quot; class=&quot;input_text&quot; placeholder=&quot;File Name&quot; name=&quot;_wc_preview_file_names[]&quot; value=&quot;&quot; /></td>
    <td class=&quot;file_url&quot;><input type=&quot;text&quot; class=&quot;input_text&quot; placeholder=&quot;http://&quot; name=&quot;_wc_preview_file_urls[]&quot; value=&quot;&quot; /></td>
    <td class=&quot;file_url_choose&quot; width=&quot;1%&quot;><a href=&quot;#&quot; class=&quot;button upload_preview_button&quot; data-choose=&quot;Choose file&quot; data-update=&quot;Insert file URL&quot;>Choose&nbsp;file</a></td>
    <td width=&quot;1%&quot;><a href=&quot;#&quot; class=&quot;delete&quot;>Delete</a></td>
    </tr>">Add File</a>
                        </th>
                    </tr>
                </tfoot>
            </table>
        </div>
    <?php
    }

    function waveplayer_woocommerce_save_preview_files( $post_id ) {
        global $wpdb;

    	$files = array();

        if ( isset( $_REQUEST['_wc_preview_file_urls'] ) ) {
    		$file_names         = isset( $_REQUEST['_wc_preview_file_names'] ) ? $_REQUEST['_wc_preview_file_names'] : array();
    		$file_urls          = isset( $_REQUEST['_wc_preview_file_urls'] )  ? wp_unslash( array_map( 'trim', $_REQUEST['_wc_preview_file_urls'] ) ) : array();
    		$file_url_size      = sizeof( $file_urls );

    		for ( $i = 0; $i < $file_url_size; $i ++ ) {
    			if ( ! empty( $file_urls[ $i ] ) ) {
    				// Find type and file URL
    				if ( 0 === strpos( $file_urls[ $i ], 'http' ) ) {
    					$file_is  = 'absolute';
    					$file_url = $file_urls[ $i ];
    				} elseif ( '[' === substr( $file_urls[ $i ], 0, 1 ) && ']' === substr( $file_urls[ $i ], -1 ) ) {
    					$file_is  = 'shortcode';
    					$file_url = wc_clean( $file_urls[ $i ] );
    				} else {
    					$file_is = 'relative';
    					$file_url = wc_clean( $file_urls[ $i ] );
    				}

    				$file_name = wc_clean( $file_names[ $i ] );
    				$file_hash = md5( $file_url );

    				// Validate the file exists
    				if ( 'relative' === $file_is ) {
    					$_file_url = $file_url;
    					if ( '..' === substr( $file_url, 0, 2 ) || '/' !== substr( $file_url, 0, 1 ) ) {
    						$_file_url = realpath( ABSPATH . $file_url );
    					}

    					if ( ! apply_filters( 'woocommerce_downloadable_file_exists', file_exists( $_file_url ), $file_url ) ) {
    						WC_Admin_Meta_Boxes::add_error( sprintf( __( 'The downloadable file %s cannot be used as it does not exist on the server.', 'woocommerce' ), '<code>' . $file_url . '</code>' ) );
    						continue;
    					}
    				}

    				$files[ $file_hash ] = array(
    					'name' => $file_name,
    					'file' => $file_url
    				);
    			}
    		}
    	}

    	update_post_meta( $post_id, '_preview_files', $files );
    }

    function waveplayer_woocommerce_product_bulk_edit_save( $post ) {
        waveplayer_woocommerce_save_preview_files( $post->ID );
    }
    //add_action( 'woocommerce_product_quick_edit_save', 'waveplayer_woocommerce_product_bulk_edit_save', 10, 1 );

    function waveplayer_woocommerce_product_quick_edit_save( $post ) {
        waveplayer_woocommerce_save_preview_files( $post->ID );
    }
    //add_action( 'woocommerce_product_quick_edit_save', 'waveplayer_woocommerce_product_quick_edit_save', 10, 1 );

    function waveplayer_woocommerce_save_music_type( $post_id ) {

        if ( ! isset( $_REQUEST['_music_type'] ) ) return;

        update_post_meta( $post_id, '_music_type', $_REQUEST['_music_type'] );
    }


    function waveplayer_woocommerce_add_player() {
        global $post;
        global $waveplayer_options;

        $product = wc_get_product( $post );

        $products = array();
        $file_ids = array();
        $file_urls = array();

        if ( $product->is_type( 'grouped' ) ) {
            $products = $product->get_children();
        } else {
            $products[] = $product->get_id();
        }
        foreach( $products as $id ) {
            $preview_files = get_post_meta( $id, '_preview_files', true);
            $size = $waveplayer_options['woocommerce_product_player_size'];
            $info = $waveplayer_options['woocommerce_product_player_info'];
            if ( is_shop() || is_product_category() ) {
                $size = $waveplayer_options['woocommerce_shop_player_size'];
                $info = $waveplayer_options['woocommerce_shop_player_info'];
            }
            if ( $preview_files ) {
        	    if ( !is_array( $preview_files ) ) {
                    if ( $file_id = waveplayer_get_audio_attachment_id( $preview_files ) ) {
	                    $file_ids[] = $file_id;
					} else {
						$file_urls[] = $preview_files;
					}
        	    } else {
                    foreach ( $preview_files as $key => $value ) {
						if ( $file_id = waveplayer_get_audio_attachment_id( $value['file'] ) ) {
	                        $file_ids[] = $file_id;
						} else {
							$file_urls[] = $value['file'];
						}
                    }
        	    }
            }
        }
        if ( $file_ids ) {
            $ids = implode( ',', $file_ids );
            echo do_shortcode("[waveplayer size='$size' info='$info' ids='$ids']");
        } elseif ( $file_urls ) {
            $urls = implode( ',', $file_urls );
            echo do_shortcode("[waveplayer size='$size' info='$info' url='$urls']");
		}
    }


    /**
    *
    * Updates the number of likes in the metadata for the audio track corresponding to the provided post ID
    *
    */
    function waveplayer_ajax_add_to_cart() {
        $product_id        = $_POST['product_id'];
        $quantity          = 1;
        $passed_validation = apply_filters( 'woocommerce_add_to_cart_validation', true, $product_id, $quantity );
        $product_status    = get_post_status( $product_id );

        if ( $passed_validation && WC()->cart->add_to_cart( $product_id, $quantity ) && 'publish' === $product_status ) {
            do_action( 'woocommerce_ajax_added_to_cart', $product_id );
            $msg = wc_add_to_cart_message( $product_id, false, true );

            wp_send_json_success( array( 'message' => $msg, 'cart' => WC()->cart->get_cart_contents() ) );
        } else {
            $data = array(
                'product_url' => apply_filters( 'woocommerce_cart_redirect_after_error', get_permalink( $product_id ), $product_id ),
                'product_id'  => $product_id
            );
            wp_send_json_error( $data );
        }

    }

    /**
    *
    * Updates the number of likes in the metadata for the audio track corresponding to the provided post ID
    *
    */
    function waveplayer_ajax_create_product() {

        $type = $_POST['type'] == 'tracks' ? 'single' : 'album';
        $product_type = isset( $_POST['product_type'] ) ? $_POST['product_type'] : 'simple';
        $files = array();
        switch( $type ) {
            case 'single':
                $id = $_POST['id'];
                $price = isset($_POST['price']) ? $_POST['price'] : '0.99';
                $track = wp_get_attachment_metadata( $id );
                $post = get_post( $id );
                if ( $post->post_title ) $track['title'] = $post->post_title;
                $file_name = $track['title'];
                $file_name = wc_clean( $file_name );
                $file_url = wp_get_attachment_url($id);
                $file_hash = md5( $file_url );
                $files[ $file_hash ] = array(
                    'name' => $file_name,
                    'file' => $file_url
                );
                $title = $file_name;
                break;
            case 'album':
                $price = isset($_POST['price']) ? $_POST['price'] : '9.99';
                $ids = isset($_POST['tracks']) ? $_POST['tracks'] : '';
                $ids = explode( ',', $ids );
                foreach( $ids as $id ) {
                    $track = wp_get_attachment_metadata( $id );
                    $post = get_post( $id );
                    if ( $post->post_title ) $track['title'] = $post->post_title;
                    $file_name = $track['title'];
                    $file_name = wc_clean( $file_name );
                    $file_url = wp_get_attachment_url($id);
                    $file_hash = md5( $file_url );
                    $files[ $file_hash ] = array(
                        'name' => $file_name,
                        'file' => $file_url
                    );
                }
                $title = isset($_POST['title']) ? $_POST['title'] : _e('New Album', 'waveplayer');
                break;
            default:
                break;
        }

        $post_id = wp_insert_post( array(
            'post_title' => $title,
            'post_status' => 'draft',
            'post_type' => 'product',
        ) );
        wp_set_object_terms( $post_id, $product_type, 'product_type' );
        update_post_meta( $post_id, '_visibility', 'visible' );
        update_post_meta( $post_id, '_stock_status', 'instock');
        update_post_meta( $post_id, 'total_sales', '0' );
        update_post_meta( $post_id, '_virtual', 'yes' );
        update_post_meta( $post_id, '_downloadable', 'yes' );
        update_post_meta( $post_id, '_regular_price', $price );
        update_post_meta( $post_id, '_featured', 'no' );
        update_post_meta( $post_id, '_price', $price );
        update_post_meta( $post_id, '_sold_individually', 'yes' );
        update_post_meta( $post_id, '_preview_files', $files );
        update_post_meta( $post_id, '_music_type', $type );

        wp_send_json_success();
    }


    function waveplayer_get_audio_attachments() {
        global $wpdb;

        $tracks = array();
        $albums = array();

        $attachments = $wpdb->get_results("SELECT ID from {$wpdb->posts} WHERE post_type = 'attachment' and post_mime_type LIKE 'audio%';");

        foreach( $attachments as $attachment ) {
            $id = $attachment->ID;
            if ( ! $track = wp_get_attachment_metadata( $id ) ) $track = array();
            $track['id'] = $id;
            $post = get_post( $id );
            if ( $post->post_title ) $track['title'] = $post->post_title;
            $track_file = wp_get_attachment_url($id);
            $track['file'] = $track_file;

            $track['product'] = waveplayer_woocommerce_get_product_id( 'single', $track_file );

            $tracks[] = $track;
            if ( isset($track['album']) && $key = $track['album'] ) {
                if ( ! isset( $albums[$key] ) ) {
                    $albums[$key] = array();
                    $albums[$key]['count'] = 0;
                    $albums[$key]['tracks'] = array();
                }
                $albums[$key]['count']++;
                $albums[$key]['tracks'][] = $track['id'];
            }
        }
        foreach( $albums as $title => $album ) {
            $album['product'] = waveplayer_woocommerce_get_product_id( 'album', $title );
            $album['tracks'] = implode( ',', $album['tracks'] );
            $albums[$title] = $album;
        }

        return array( 'tracks' => $tracks, 'albums' => $albums );
    }


    function waveplayer_woocommerce_music_inputs() {
        if ( $result = waveplayer_get_audio_attachments() ) {
            $albums = $result['albums'];
            $tracks = $result['tracks'];
        } else {
            return;
        }
        $track_inputs = '';
        $album_inputs = '';
        foreach($tracks as $track) {
            $id = $track['id'];
            $title = $track['title'];
            $length = $track['length_formatted'];
            $file = basename( $track['file'] );
            $product = $track['product'];
            $disabled = $product > 0 ? "disabled" : "";

            $track_inputs .= "<input type='checkbox' name='music_track_$id' value='$id' $disabled data-title='$title' /><span class='$disabled'>$id. <strong>$title</strong> – $length ($file)</span><br/>";
        }
        $j = 0;
        foreach($albums as $title => $album) {
            $count = $album['count'];
            $plural = $count == 1 ? '' : 's';
            $ids = $album['tracks'];
            $product = isset($album['product']) ? $album['product'] : 0;
            $disabled = $product > 0 ? "disabled" : "";
            $album_inputs .= "<input type='checkbox' name='music_album_$j' value='$j' data-tracks='$ids' data-title='$title' $disabled /><span class='$disabled'><strong>$title</strong> ($count track$plural)</span><br/>";
            $j++;
        }
        return array( 'track_inputs' => $track_inputs, 'album_inputs' => $album_inputs );
    }


    function waveplayer_woocommerce_get_product_id( $music_type, $data = '' ) {

        $product_id = 0;

        $args = array(
            'number_posts'    => 1,
            'post_status'     => 'any',
            'post_type'       => 'product',
        );

        $meta_query = array();
        $meta_query[] = array(
            'key'     => '_music_type',
            'value'   => $music_type,
            'compare' => '='
        );
        if ( $music_type == 'single' ) {
            $meta_query['relation'] = 'AND';
            $meta_query[] = array(
                'key'     => '_preview_files',
                'value'   => $data,
                'compare' => 'LIKE'
            );
        } else {
            $args['title'] = $data;
        }
        $args['meta_query'] = $meta_query;

        $query = new WP_Query( $args );
        if ( $query->have_posts() ) {
            $query->the_post();
            $product_id = get_the_ID();
        }

        return $product_id;
    }

    function waveplayer_add_product_info_to_track( $track, $track_id, $post_id ) {
        $track['in_cart'] = 0;
        $track_file = $track['file'];
        $args = array(
            'number_posts'    => 1,
            'post_status'     => 'any',
            'post_type'       => 'product',
            'meta_query'      => array(
                'relation'    => 'AND',
                array(
                    'key'     => '_music_type',
                    'value'   => 'single',
                    'compare' => '='
                ),
                array(
                    'key'     => '_preview_files',
                    'value'   => $track_file,
                    'compare' => 'LIKE'
                )
            )
        );
        $query = new WP_Query( $args );
        if ( $query->have_posts() ) {
            $query->the_post();
            $track['product_id'] = get_the_ID();
            $track['product_url'] = get_permalink( $track['product_id'] );
            $track['product_price'] = floatval( wc_get_product( $track['product_id'] )->get_price() );
            $track['product_formatted_price'] = wc_price( wc_get_product( $track['product_id'] ) );
            foreach( WC()->cart->get_cart() as $cart_item ) {
                if( $track['product_id'] == $cart_item['product_id'] ) {
                    $track['in_cart'] = 1;
                    break;
                }
            }
        }
        return $track;
    }

    function waveplayer_woocommerce_add_music_type() {
        $music_type = isset($_GET['music_type']) ? $_GET['music_type'] : 'single';
        ob_start();
?>
        <form class="woocommerce-ordering woocommerce-music-type" method="get">
            <select name="music_type" class="orderby">
                <option value="single" <?php selected( $music_type, 'single' ); ?>>Singles</option>
                <option value="album" <?php selected( $music_type, 'album' ); ?>>Albums</option>
            </select>
        </form>
<?php
        echo ob_get_clean();
    }


    function shop_filter_cat($query) {
        global $post;
        $music_type = isset($_GET['music_type']) ? $_GET['music_type'] : 'single';

        if ( !is_admin() && is_post_type_archive( 'product' ) && $query->is_main_query()) {
            $query->set(
                'meta_query',
                array(
                    array (
                        'key' => '_music_type',
                        'value' => $music_type,
                        'compare'   => '='
                    )
                )
            );
        }
    }

    function waveplayer_woocommerce_music_type_filter( $q ){
        $music_type = isset($_GET['music_type']) ? $_GET['music_type'] : 'single';
        $meta_query = $q->get( 'meta_query' );

        $meta_query[] = array(
            'key' => '_music_type',
            'value' => $music_type,
            'compare'   => '='
        );

        $q->set( 'meta_query', $meta_query );
    }

}

?>
