<?php

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
namespace SimpleCalendar\plugin_deps\Google\Service\Calendar;

class Events extends \SimpleCalendar\plugin_deps\Google\Collection
{
    protected $collection_key = 'items';
    /**
     * @var string
     */
    public $accessRole;
    protected $defaultRemindersType = EventReminder::class;
    protected $defaultRemindersDataType = 'array';
    /**
     * @var string
     */
    public $description;
    /**
     * @var string
     */
    public $etag;
    protected $itemsType = Event::class;
    protected $itemsDataType = 'array';
    /**
     * @var string
     */
    public $kind;
    /**
     * @var string
     */
    public $nextPageToken;
    /**
     * @var string
     */
    public $nextSyncToken;
    /**
     * @var string
     */
    public $summary;
    /**
     * @var string
     */
    public $timeZone;
    /**
     * @var string
     */
    public $updated;
    /**
     * @param string
     */
    public function setAccessRole($accessRole)
    {
        $this->accessRole = $accessRole;
    }
    /**
     * @return string
     */
    public function getAccessRole()
    {
        return $this->accessRole;
    }
    /**
     * @param EventReminder[]
     */
    public function setDefaultReminders($defaultReminders)
    {
        $this->defaultReminders = $defaultReminders;
    }
    /**
     * @return EventReminder[]
     */
    public function getDefaultReminders()
    {
        return $this->defaultReminders;
    }
    /**
     * @param string
     */
    public function setDescription($description)
    {
        $this->description = $description;
    }
    /**
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * @param string
     */
    public function setEtag($etag)
    {
        $this->etag = $etag;
    }
    /**
     * @return string
     */
    public function getEtag()
    {
        return $this->etag;
    }
    /**
     * @param Event[]
     */
    public function setItems($items)
    {
        $this->items = $items;
    }
    /**
     * @return Event[]
     */
    public function getItems()
    {
        return $this->items;
    }
    /**
     * @param string
     */
    public function setKind($kind)
    {
        $this->kind = $kind;
    }
    /**
     * @return string
     */
    public function getKind()
    {
        return $this->kind;
    }
    /**
     * @param string
     */
    public function setNextPageToken($nextPageToken)
    {
        $this->nextPageToken = $nextPageToken;
    }
    /**
     * @return string
     */
    public function getNextPageToken()
    {
        return $this->nextPageToken;
    }
    /**
     * @param string
     */
    public function setNextSyncToken($nextSyncToken)
    {
        $this->nextSyncToken = $nextSyncToken;
    }
    /**
     * @return string
     */
    public function getNextSyncToken()
    {
        return $this->nextSyncToken;
    }
    /**
     * @param string
     */
    public function setSummary($summary)
    {
        $this->summary = $summary;
    }
    /**
     * @return string
     */
    public function getSummary()
    {
        return $this->summary;
    }
    /**
     * @param string
     */
    public function setTimeZone($timeZone)
    {
        $this->timeZone = $timeZone;
    }
    /**
     * @return string
     */
    public function getTimeZone()
    {
        return $this->timeZone;
    }
    /**
     * @param string
     */
    public function setUpdated($updated)
    {
        $this->updated = $updated;
    }
    /**
     * @return string
     */
    public function getUpdated()
    {
        return $this->updated;
    }
}
// Adding a class alias for backwards compatibility with the previous class name.
\class_alias(Events::class, 'SimpleCalendar\\plugin_deps\\Google_Service_Calendar_Events');
