<?php
/**
 * This is the template used for the single RSS feed item
 * generated by the [waveplayer_rss] shortcode
 *
 * You can customize this interface copying the whole folder
 * in your current child theme folder, in the following location:
 * /wp-content/themes/<your-child-theme>/waveplayer/interface/rss-feed/item-default.php
 *
 * If WavePlayer find this file in your child theme folder, it will override the factory one.
 *
 * @package WavePlayer/Renderer
 */

?>

<div class="feed-item">
	<div class="feed-item-thumbnail">
		<a href="<?php echo esc_attr( $permalink ); ?>" target="_blank">
			<img src="<?php echo esc_url( $image ); ?>" />
		</a>
	</div>
	<div class="feed-item-main">
		<h3>
			<a href="<?php echo esc_attr( $permalink ); ?>" target="_blank">
				<?php echo esc_html( $title ); ?>
			</a>
		</h3>
		<p>
			<a href="<?php echo esc_url( $author_link ); ?>" target="_blank">
				<?php echo esc_html( $author ); ?>
			</a>
			<?php echo esc_html( $date ); ?>
		</p>
	</div>
	<div class="feed-item-body">
		<?php echo $player; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
		<div class="feed-item-description">
			<?php echo $description; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
		</div>
	</div>
</div>
