<?php

namespace YOOtheme\Theme\Wordpress\Listener;

use YOOtheme\Config;
use YOOtheme\Event;
use YOOtheme\Metadata;
use YOOtheme\Path;

class LoadCustomizer
{
    public Config $config;
    public Metadata $metadata;

    public function __construct(Config $config, Metadata $metadata)
    {
        $this->config = $config;
        $this->metadata = $metadata;
    }

    public function handle()
    {
        // add config
        $this->config->addFile('customizer', Path::get('../../config/customizer.json'));

        // init customizer
        Event::emit('customizer.init');

        // add assets
        $this->metadata->set('style:customizer', [
            'href' => Path::get('../../assets/css/admin.css'),
        ]);

        $this->metadata->set('script:customizer', [
            'src' => Path::get('../../app/customizer.min.js'),
        ]);
    }
}
