<?php

namespace YOOtheme\Theme;

use YOOtheme\Path;

class SystemCheck
{
    /**
     * Gets the requirements.
     *
     * @return array
     */
    public function getRequirements()
    {
        $res = [];

        if (!extension_loaded('JSON')) {
            $res[] = 'common_json';
        }

        if (
            !extension_loaded('GD') ||
            !is_callable('imagegif') ||
            !is_callable('imagejpeg') ||
            !is_callable('imagepng')
        ) {
            $res[] = 'common_gd';
        }

        if (!extension_loaded('mbstring')) {
            $res[] = 'common_mbstring';
        }

        return $res;
    }

    /**
     * Gets the recommendations.
     *
     * @return array
     */
    public function getRecommendations()
    {
        $res = [];

        if (version_compare('8.1', PHP_VERSION, '>')) {
            $res[] = ['key' => 'common_php_ver', 'version' => PHP_VERSION];
        }

        /** @phpstan-ignore-next-line */
        if (extension_loaded('GD') && !is_callable('imagewebp')) {
            $res[] = 'common_webp';
        }

        if (!is_writable(Path::get('~theme/cache'))) {
            $res[] = 'common_cachedir';
        }

        $post_max_size = $this->parseSize(ini_get('post_max_size'));
        if ($post_max_size < $this->parseSize('8M')) {
            $res[] = 'common_post_max_size';
        }

        $upload_max_filesize = $this->parseSize(ini_get('upload_max_filesize'));
        if ($upload_max_filesize < $this->parseSize('8M')) {
            $res[] = 'common_upload_max_filesize';
        }

        $memory_limit = $this->parseSize(ini_get('memory_limit'));
        if ($memory_limit > 0 && $memory_limit < $this->parseSize('128M')) {
            $res[] = 'common_memory_limit';
        }

        $max_execution_time = ini_get('max_execution_time');
        if ($max_execution_time > 0 && $max_execution_time < 60) {
            $res[] = 'common_max_execution_time';
        }

        if (is_callable('apache_get_modules') && in_array('mod_pagespeed', apache_get_modules())) {
            $res[] = 'common_mod_pagespeed';
        }

        return $res;
    }

    /**
     * @param  string $size
     * @return float
     */
    protected function parseSize($size)
    {
        $unit = preg_replace('/[^bkmgtpezy]/i', '', $size);
        $size = (float) preg_replace('/[^0-9.\-]/', '', $size);
        if ($unit) {
            return round($size * pow(1024, stripos('bkmgtpezy', $unit[0])));
        }

        return round($size);
    }
}
