<?php
/**
 * Plugin Name: WavePlayer
 * Plugin URI: http://www.waveplayer.info
 * Description: WavePlayer is an audio player that uses the waveform of each track as its timeline.
 * Author: Luigi Pulcini
 * Version: 3.2.1
 * Author URI: http://www.luigipulcini.com
 * Requires PHP: 7.2
 * Update URI: https://waveplayer.info
 *
 * WC requires at least: 4.0
 * WC tested up to: 6.8.2
 *
 * @package WavePlayer
 */

namespace PerfectPeach\WavePlayer; //phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedNamespaceFound

defined( 'ABSPATH' ) || exit;

require_once 'includes/class-waveplayer.php';
require_once 'includes/class-debug.php';

/**
 * Returns the main instance of WavePlayer.
 *
 * @since  3.0.0
 * @return WavePlayer
 */
function waveplayer() {
	return WavePlayer::instance();
}

$GLOBALS['waveplayer'] = waveplayer();
