<?php

namespace YOOtheme\Theme\Wordpress\Listener;

class AddBuilderAction
{
    public static function handle(array $actions, \WP_Post $post): array
    {
        if (!empty($post->builder)) {
            $link = add_query_arg(
                ['url' => urlencode(get_permalink($post->ID)), 'autofocus[section]' => 'builder'],
                wp_customize_url()
            );

            $actions['yootheme'] = sprintf(
                '<a href="%s" class="tm-button">%s</a>',
                $link,
                __('YOOtheme Builder', 'yootheme')
            );

            unset($actions['classic']);
        }

        return $actions;
    }
}
