<?php

namespace YOOtheme\Theme\Wordpress\Listener;

use YOOtheme\Config;
use YOOtheme\Path;

class AddAdminMenuButton
{
    public Config $config;

    public function __construct(Config $config)
    {
        $this->config = $config;
    }

    /**
     * Fires before the administration menu loads in the admin.
     *
     * @link https://developer.wordpress.org/reference/hooks/admin_menu/
     */
    public function handle()
    {
        add_menu_page(
            '',
            'YOOtheme',
            'edit_theme_options',
            Path::relative(get_admin_url(), wp_customize_url()),
            '',
            '',
            60
        );

        wp_enqueue_style(
            'yootheme-link-style',
            get_template_directory_uri() . '/vendor/yootheme/theme-wordpress/assets/css/icon.css'
        );
    }
}
