<?php
/**
 * This is the template used for the RSS feed page header
 * generated by the [waveplayer_rss] shortcode
 *
 * You can customize this interface copying the whole folder
 * in your current child theme folder, in the following location:
 * /wp-content/themes/<your-child-theme>/waveplayer/interface/rss-feed/header.php
 *
 * If WavePlayer find this file in your child theme folder, it will override the factory one.
 *
 * @package WavePlayer/Renderer
 */

?>
<div class="feed-page-header" style="--background:<?php echo esc_attr( $background_color ); ?>; --color:<?php echo esc_attr( $color ); ?>; --feed-image:url(<?php echo esc_attr( $feed_image ); ?>)">
	<div class="feed-page-header-content">
		<div class="feed-page-thumbnail">
			<a href="<?php echo esc_url( $feed_permalink ); ?>" target="_blank">
				<img src="<?php echo esc_url( $feed_image ); ?>" />
			</a>
		</div>
		<div class="feed-page-main">
			<h2>
				<a href="<?php echo esc_url( $feed_permalink ); ?>" target="_blank">
					<?php echo esc_html( $feed_title ); ?>
				</a>
			</h2>
			<div class="feed-page-description">
				<?php echo wp_kses( $feed_description, 'post' ); ?>
			</div>
		</div>
	</div>
</div>
